/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.client.ColorUtils;
import immersive_aircraft.entity.VehicleEntity;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class DyeableVehicleEntity
extends VehicleEntity {
    protected static final EntityDataAccessor<Integer> DYE_COLOR = SynchedEntityData.m_135353_(DyeableVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public DyeableVehicleEntity(EntityType<? extends VehicleEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DYE_COLOR, (Object)-1);
    }

    @Override
    protected void addItemTag(@NotNull CompoundTag tag) {
        super.addItemTag(tag);
        if (this.getDyeColor() >= 0) {
            tag.m_128469_("display").m_128405_("color", this.getDyeColor());
        }
    }

    @Override
    protected void readItemTag(@NotNull CompoundTag tag) {
        super.readItemTag(tag);
        CompoundTag displayTag = tag.m_128469_("display");
        if (displayTag.m_128425_("color", 99)) {
            this.setDyeColor(displayTag.m_128451_("color"));
        }
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Color")) {
            this.setDyeColor(tag.m_128451_("Color"));
        }
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Color", this.getDyeColor());
    }

    public int getDyeColor() {
        return (Integer)this.f_19804_.m_135370_(DYE_COLOR);
    }

    public void setDyeColor(int v) {
        this.f_19804_.m_135381_(DYE_COLOR, (Object)v);
    }

    public int getBodyColor() {
        int[] rgb = ColorUtils.hexToRGB(this.getDyeColor() < 0 ? this.getDefaultDyeColor() : this.getDyeColor());
        float[] hsb = Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], null);
        hsb[2] = Mth.m_14036_((float)hsb[2], (float)0.18f, (float)0.95f);
        Color resultColor = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        return resultColor.getRGB();
    }

    public int getHighlightColor() {
        int[] rgb = ColorUtils.hexToRGB(this.getBodyColor());
        float[] hsb = Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], null);
        hsb[1] = Mth.m_14036_((float)(hsb[1] * 0.88311f), (float)0.0f, (float)1.0f);
        hsb[2] = Mth.m_14036_((float)(hsb[2] * 1.11494f), (float)0.0f, (float)1.0f);
        Color resultColor = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        return resultColor.getRGB();
    }

    public int getDefaultDyeColor() {
        return 0xFFFFFF;
    }

    @Override
    public Component m_5446_() {
        return super.m_5446_();
    }
}

