/*
 * Decompiled with CFR 0.152.
 */
package net.walksanator.hextweaks.casting;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.castables.Action;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.math.HexAngle;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.lib.hex.HexActions;
import at.petrak.hexcasting.server.ScrungledPatternsSave;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.walksanator.hextweaks.HexTweaks;
import net.walksanator.hextweaks.casting.PatternRegistryKt;
import net.walksanator.hextweaks.casting.actions.OpBiggerBomb;
import net.walksanator.hextweaks.casting.actions.OpEgyptianPlagues;
import net.walksanator.hextweaks.casting.actions.OpEnlightenPattern;
import net.walksanator.hextweaks.casting.actions.OpLackingWill;
import net.walksanator.hextweaks.casting.actions.OpLoopWhile;
import net.walksanator.hextweaks.casting.actions.OpMindflayPlus;
import net.walksanator.hextweaks.casting.actions.OpPageFlip;
import net.walksanator.hextweaks.casting.actions.OpSlateNormal;
import net.walksanator.hextweaks.casting.actions.OpSuicide;
import net.walksanator.hextweaks.casting.actions.OpWaveRefl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0014\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\f\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ9\u0010\u0006\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0016J1\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\u0018\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJC\u0010!\u001a\u00020\u001324\u0010 \u001a0\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u001c\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u001e0\u001d0\u001bj\u0002`\u001f\u00a2\u0006\u0004\b!\u0010\"J1\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t\u0018\u00010\u001e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010$\u001a\u00020\u001c\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010(\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b(\u0010)J%\u0010/\u001a\u00020'2\u0006\u0010+\u001a\u00020*2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020'\u00a2\u0006\u0004\b/\u00100J%\u0010/\u001a\u00020'2\u0006\u00102\u001a\u0002012\u0006\u00104\u001a\u0002032\u0006\u0010.\u001a\u00020'\u00a2\u0006\u0004\b/\u00105J!\u00108\u001a\u00020\u000b2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\t06\u00a2\u0006\u0004\b8\u00109R2\u0010;\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u001e0:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<RH\u0010>\u001a6\u00122\u00120\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u001c\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u001e0\u001d0\u001bj\u0002`\u001f0=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R \u0010@\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00150:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010<R\u0017\u0010A\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\bA\u0010B\u001a\u0004\bC\u0010DR\u0017\u0010E\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\bE\u0010B\u001a\u0004\bF\u0010DR\u0017\u0010G\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\bG\u0010B\u001a\u0004\bH\u0010DR\u0017\u0010I\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\bI\u0010B\u001a\u0004\bJ\u0010DR\u0017\u0010K\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\bK\u0010B\u001a\u0004\bL\u0010DR\u0017\u0010M\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\bM\u0010B\u001a\u0004\bN\u0010DR\u0017\u0010O\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\bO\u0010B\u001a\u0004\bP\u0010D\u00a8\u0006Q"}, d2={"Lnet/walksanator/hextweaks/casting/PatternRegistry;", "", "<init>", "()V", "", "Lat/petrak/hexcasting/api/casting/math/HexAngle;", "pattern", "Lat/petrak/hexcasting/api/casting/castables/Action;", "action", "Lnet/minecraft/resources/ResourceLocation;", "namespace", "", "registerGrandSpells", "(Ljava/util/List;Lat/petrak/hexcasting/api/casting/castables/Action;Lnet/minecraft/resources/ResourceLocation;)V", "Lat/petrak/hexcasting/api/casting/math/HexDir;", "start", "", "angles", "name", "", "isGrand", "Lat/petrak/hexcasting/api/casting/ActionRegistryEntry;", "(Lat/petrak/hexcasting/api/casting/math/HexDir;Ljava/lang/String;Ljava/lang/String;Lat/petrak/hexcasting/api/casting/castables/Action;Z)Lat/petrak/hexcasting/api/casting/ActionRegistryEntry;", "parent", "parentIsGreat", "patternGrand", "(Lat/petrak/hexcasting/api/casting/ActionRegistryEntry;Ljava/lang/String;Lat/petrak/hexcasting/api/casting/castables/Action;Z)V", "Ljava/util/function/BiFunction;", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Ljava/util/Optional;", "Lkotlin/Pair;", "Lnet/walksanator/hextweaks/casting/GrandPatternResolve;", "fn", "registerAlternative", "(Ljava/util/function/BiFunction;)Z", "sigs", "env", "getGrandEntry", "(Ljava/util/List;Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)Lkotlin/Pair;", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "patternAllowIllegal", "(Lat/petrak/hexcasting/api/casting/math/HexDir;Ljava/lang/String;)Lat/petrak/hexcasting/api/casting/math/HexPattern;", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lnet/minecraft/server/level/ServerLevel;", "level", "pat", "getGrandSpellPattern", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/level/ServerLevel;Lat/petrak/hexcasting/api/casting/math/HexPattern;)Lat/petrak/hexcasting/api/casting/math/HexPattern;", "Ljava/util/UUID;", "uuid", "", "seed", "(Ljava/util/UUID;JLat/petrak/hexcasting/api/casting/math/HexPattern;)Lat/petrak/hexcasting/api/casting/math/HexPattern;", "Ljava/util/function/BiConsumer;", "r", "register", "(Ljava/util/function/BiConsumer;)V", "Ljava/util/HashMap;", "GRAND_REGISTRY", "Ljava/util/HashMap;", "", "ALTERNATIVE_REGISTRY", "Ljava/util/List;", "deferred", "THE_FUNNY", "Lat/petrak/hexcasting/api/casting/ActionRegistryEntry;", "getTHE_FUNNY", "()Lat/petrak/hexcasting/api/casting/ActionRegistryEntry;", "INFUSE_WILL", "getINFUSE_WILL", "PAGE_RIGHT", "getPAGE_RIGHT", "PAGE_LEFT", "getPAGE_LEFT", "WHILE", "getWHILE", "GETWAVE", "getGETWAVE", "SLATE_NORMAL", "getSLATE_NORMAL", "hextweaks"})
public final class PatternRegistry {
    @NotNull
    public static final PatternRegistry INSTANCE = new PatternRegistry();
    @NotNull
    private static final HashMap<List<HexAngle>, Pair<Action, ResourceLocation>> GRAND_REGISTRY = new HashMap();
    @NotNull
    private static final List<BiFunction<List<HexAngle>, CastingEnvironment, Optional<Pair<Action, ResourceLocation>>>> ALTERNATIVE_REGISTRY = new ArrayList();
    @NotNull
    private static final HashMap<ResourceLocation, ActionRegistryEntry> deferred = new HashMap();
    @NotNull
    private static final ActionRegistryEntry THE_FUNNY = INSTANCE.pattern(HexDir.WEST, "dewdeqwwedaqedwadweqewwd", "suicide", (Action)new OpSuicide(), true);
    @NotNull
    private static final ActionRegistryEntry INFUSE_WILL = PatternRegistry.pattern$default(INSTANCE, HexDir.SOUTH_WEST, "waawaawaqwaeaeaeaeaea", "infusion", (Action)new OpEnlightenPattern(), false, 16, null);
    @NotNull
    private static final ActionRegistryEntry PAGE_RIGHT = PatternRegistry.pattern$default(INSTANCE, HexDir.SOUTH_WEST, "qqaw", "page/right", (Action)new OpPageFlip(true), false, 16, null);
    @NotNull
    private static final ActionRegistryEntry PAGE_LEFT = PatternRegistry.pattern$default(INSTANCE, HexDir.SOUTH_EAST, "eedw", "page/left", (Action)new OpPageFlip(false), false, 16, null);
    @NotNull
    private static final ActionRegistryEntry WHILE = PatternRegistry.pattern$default(INSTANCE, HexDir.NORTH_EAST, "wdwadad", "while", OpLoopWhile.INSTANCE, false, 16, null);
    @NotNull
    private static final ActionRegistryEntry GETWAVE = PatternRegistry.pattern$default(INSTANCE, HexDir.SOUTH_EAST, "qdewedq", "wave", (Action)OpWaveRefl.INSTANCE, false, 16, null);
    @NotNull
    private static final ActionRegistryEntry SLATE_NORMAL = PatternRegistry.pattern$default(INSTANCE, HexDir.SOUTH_EAST, "qdewedqwqaq", "normal", (Action)OpSlateNormal.INSTANCE, false, 16, null);

    private PatternRegistry() {
    }

    public final void registerGrandSpells(@NotNull List<? extends HexAngle> pattern, @NotNull Action action, @NotNull ResourceLocation namespace) {
        Intrinsics.checkNotNullParameter(pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        if (GRAND_REGISTRY.containsKey(pattern)) {
            String string = "a pattern is allready registered under that pattern id: %s sig: %s trying to register %s";
            Object[] objectArray = new Object[3];
            Pair<Action, ResourceLocation> pair = GRAND_REGISTRY.get(pattern);
            objectArray[0] = pair != null ? (ResourceLocation)pair.getSecond() : null;
            objectArray[1] = PatternRegistryKt.toSig(pattern);
            objectArray[2] = namespace;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new IllegalArgumentException(string2);
        }
        ((Map)GRAND_REGISTRY).put(pattern, new Pair((Object)action, (Object)namespace));
    }

    @NotNull
    public final ActionRegistryEntry getTHE_FUNNY() {
        return THE_FUNNY;
    }

    @NotNull
    public final ActionRegistryEntry getINFUSE_WILL() {
        return INFUSE_WILL;
    }

    @NotNull
    public final ActionRegistryEntry getPAGE_RIGHT() {
        return PAGE_RIGHT;
    }

    @NotNull
    public final ActionRegistryEntry getPAGE_LEFT() {
        return PAGE_LEFT;
    }

    @NotNull
    public final ActionRegistryEntry getWHILE() {
        return WHILE;
    }

    @NotNull
    public final ActionRegistryEntry getGETWAVE() {
        return GETWAVE;
    }

    @NotNull
    public final ActionRegistryEntry getSLATE_NORMAL() {
        return SLATE_NORMAL;
    }

    private final ActionRegistryEntry pattern(HexDir start, String angles, String name, Action action, boolean isGrand) {
        HexPattern pat = this.patternAllowIllegal(start, angles);
        ResourceLocation resourceLocation = new ResourceLocation("hextweaks", name);
        ActionRegistryEntry ARE = new ActionRegistryEntry(pat, action);
        if (isGrand) {
            this.registerGrandSpells(pat.getAngles(), action, resourceLocation);
        } else {
            if (deferred.containsKey(resourceLocation)) {
                throw new IllegalArgumentException("two patterns are vying for " + resourceLocation + " id. fix this");
            }
            ((Map)deferred).put(resourceLocation, ARE);
        }
        return ARE;
    }

    static /* synthetic */ ActionRegistryEntry pattern$default(PatternRegistry patternRegistry, HexDir hexDir, String string, String string2, Action action, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return patternRegistry.pattern(hexDir, string, string2, action, bl);
    }

    private final void patternGrand(ActionRegistryEntry parent, String name, Action action, boolean parentIsGreat) {
        if (parentIsGreat) {
            this.registerAlternative((arg_0, arg_1) -> PatternRegistry.patternGrand$lambda$0(parent, action, name, arg_0, arg_1));
        } else {
            ResourceLocation resourceLocation = new ResourceLocation("hextweaks", name);
            this.registerGrandSpells(parent.prototype().getAngles(), action, resourceLocation);
        }
    }

    static /* synthetic */ void patternGrand$default(PatternRegistry patternRegistry, ActionRegistryEntry actionRegistryEntry, String string, Action action, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        patternRegistry.patternGrand(actionRegistryEntry, string, action, bl);
    }

    public final boolean registerAlternative(@NotNull BiFunction<List<HexAngle>, CastingEnvironment, Optional<Pair<Action, ResourceLocation>>> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        return ALTERNATIVE_REGISTRY.add(fn);
    }

    @Nullable
    public final Pair<Action, ResourceLocation> getGrandEntry(@NotNull List<? extends HexAngle> sigs, @NotNull CastingEnvironment env) {
        LivingEntity livingEntity;
        ServerPlayer caster;
        Intrinsics.checkNotNullParameter(sigs, (String)"sigs");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Pair<Action, ResourceLocation> registry_check = GRAND_REGISTRY.get(sigs);
        if (registry_check == null) {
            for (BiFunction<List<HexAngle>, CastingEnvironment, Optional<Pair<Action, ResourceLocation>>> biFunction : ALTERNATIVE_REGISTRY) {
                Optional<Pair<Action, ResourceLocation>> res;
                Intrinsics.checkNotNullExpressionValue(biFunction.apply(sigs, env), (String)"apply(...)");
                if (!res.isPresent()) continue;
                registry_check = res.get();
            }
        }
        ServerPlayer serverPlayer = caster = (livingEntity = env.getCastingEntity()) instanceof ServerPlayer ? (ServerPlayer)livingEntity : null;
        if (registry_check != null) {
            if (caster != null) {
                ResourceLocation resourceLocation = (ResourceLocation)registry_check.getSecond();
                String string = resourceLocation.m_135827_();
                String string2 = "grandspell/%s";
                Object[] objectArray = new Object[]{resourceLocation.m_135815_()};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                ResourceLocation advid = new ResourceLocation(string, string3);
                Advancement adv = caster.f_8924_.m_129889_().m_136041_(advid);
                if (adv != null) {
                    caster.m_8960_().m_135988_(adv, "grant");
                } else {
                    HexTweaks.LOGGER.warn("Advancement from grand spell {} does not exists", (Object)advid);
                }
            } else {
                HexTweaks.LOGGER.info("There is no player to grant advancement to for grand spell");
            }
        }
        return registry_check;
    }

    @NotNull
    public final HexPattern patternAllowIllegal(@NotNull HexDir start, @NotNull String angles) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)angles, (String)"angles");
        HexPattern pat = new HexPattern(start, (List)new ArrayList());
        int n = angles.length();
        for (int i = 0; i < n; ++i) {
            int idx = i;
            char c = angles.charAt(i);
            HexAngle angle = switch (c) {
                case 'w' -> HexAngle.FORWARD;
                case 'e' -> HexAngle.RIGHT;
                case 'd' -> HexAngle.RIGHT_BACK;
                case 's' -> HexAngle.BACK;
                case 'a' -> HexAngle.LEFT_BACK;
                case 'q' -> HexAngle.LEFT;
                default -> throw new IllegalArgumentException("Cannot match " + c + " at idx " + idx + " to a direction");
            };
            pat.getAngles().add(angle);
        }
        return pat;
    }

    @NotNull
    public final HexPattern getGrandSpellPattern(@NotNull ServerPlayer player, @NotNull ServerLevel level, @NotNull HexPattern pat) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pat, (String)"pat");
        UUID uUID = player.m_20148_();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return this.getGrandSpellPattern(uUID, level.m_7328_(), pat);
    }

    @NotNull
    public final HexPattern getGrandSpellPattern(@NotNull UUID uuid, long seed, @NotNull HexPattern pat) {
        long bit;
        int i;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)pat, (String)"pat");
        long upper = uuid.getMostSignificantBits() ^ seed;
        long lower = uuid.getLeastSignificantBits() ^ seed;
        List expected_bits = new ArrayList();
        for (i = 63; -1 < i; --i) {
            bit = upper >> i & 1L;
            expected_bits.add((int)bit == 1);
        }
        for (i = 63; -1 < i; --i) {
            bit = lower >> i & 1L;
            expected_bits.add((int)bit == 1);
        }
        List resulting = new ArrayList();
        for (HexAngle sig : pat.getAngles()) {
            if (((Boolean)expected_bits.remove(0)).booleanValue()) {
                resulting.add(HexAngle.BACK);
                resulting.add(HexAngle.BACK);
            }
            resulting.add(sig);
        }
        return new HexPattern(pat.getStartDir(), resulting);
    }

    public final void register(@NotNull BiConsumer<ActionRegistryEntry, ResourceLocation> r) {
        Intrinsics.checkNotNullParameter(r, (String)"r");
        for (Map.Entry entry : ((Map)deferred).entrySet()) {
            ResourceLocation key = (ResourceLocation)entry.getKey();
            ActionRegistryEntry value = (ActionRegistryEntry)entry.getValue();
            r.accept(value, key);
        }
    }

    private static final Optional patternGrand$lambda$0(ActionRegistryEntry $parent, Action $action, String $name, List angles, CastingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)angles, (String)"angles");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Registry reg = IXplatAbstractions.INSTANCE.getActionRegistry();
        ScrungledPatternsSave save = ScrungledPatternsSave.open((ServerLevel)env.getWorld());
        ScrungledPatternsSave.PerWorldEntry lookup = save.lookup(PatternRegistryKt.toSig(angles));
        if (lookup != null ? Intrinsics.areEqual((Object)reg.m_6246_(lookup.key()), (Object)$parent) : Intrinsics.areEqual((Object)$parent.prototype().getAngles(), (Object)angles)) {
            return Optional.of(new Pair((Object)$action, (Object)new ResourceLocation("hextweaks", $name)));
        }
        return Optional.empty();
    }

    static {
        ActionRegistryEntry actionRegistryEntry = HexActions.BRAINSWEEP;
        Intrinsics.checkNotNullExpressionValue((Object)actionRegistryEntry, (String)"BRAINSWEEP");
        INSTANCE.patternGrand(actionRegistryEntry, "mindflayplus", (Action)OpMindflayPlus.INSTANCE, true);
        ActionRegistryEntry actionRegistryEntry2 = HexActions.EXPLODE;
        Intrinsics.checkNotNullExpressionValue((Object)actionRegistryEntry2, (String)"EXPLODE");
        INSTANCE.patternGrand(actionRegistryEntry2, "explode", (Action)new OpBiggerBomb(false), false);
        ActionRegistryEntry actionRegistryEntry3 = HexActions.EXPLODE$FIRE;
        Intrinsics.checkNotNullExpressionValue((Object)actionRegistryEntry3, (String)"EXPLODE$FIRE");
        INSTANCE.patternGrand(actionRegistryEntry3, "fireball", (Action)new OpBiggerBomb(true), false);
        if (Platform.isModLoaded((String)"moreiotas")) {
            ActionRegistryEntry hell = PatternRegistry.pattern$default(INSTANCE, HexDir.EAST, "wqwqwqwqwqwewawwwawwwaw", "you_like_drinking_potions", (Action)OpLackingWill.INSTANCE, false, 16, null);
            INSTANCE.patternGrand(hell, "nadith", (Action)OpEgyptianPlagues.INSTANCE, true);
        }
    }
}

