/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe.ingredient.brainsweep;

import at.petrak.hexcasting.common.recipe.ingredient.brainsweep.BrainsweepeeIngredient;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class EntityTagIngredient
extends BrainsweepeeIngredient {
    public final TagKey<EntityType<?>> entityTypeTag;

    public EntityTagIngredient(TagKey<EntityType<?>> tag) {
        this.entityTypeTag = tag;
    }

    @Override
    public boolean test(Entity entity, ServerLevel level) {
        return entity.m_6095_().m_204039_(this.entityTypeTag);
    }

    private static String tagKey(ResourceLocation tagLoc) {
        return "tag." + tagLoc.m_135827_() + "." + tagLoc.m_135815_().replace('/', '.');
    }

    @Override
    public Component getName() {
        String key = EntityTagIngredient.tagKey(this.entityTypeTag.f_203868_());
        boolean moddersDidAGoodJob = I18n.m_118936_((String)key);
        return moddersDidAGoodJob ? Component.m_237115_((String)key) : Component.m_237113_((String)("#" + this.entityTypeTag.f_203868_()));
    }

    @Override
    public List<Component> getTooltip(boolean advanced) {
        ResourceLocation loc = this.entityTypeTag.f_203868_();
        String key = EntityTagIngredient.tagKey(loc);
        boolean moddersDidAGoodJob = I18n.m_118936_((String)key);
        ArrayList<Component> out = new ArrayList<Component>();
        out.add((Component)(moddersDidAGoodJob ? Component.m_237115_((String)key) : Component.m_237113_((String)("#" + loc))));
        if (advanced && moddersDidAGoodJob) {
            out.add((Component)Component.m_237113_((String)("#" + loc)).m_130940_(ChatFormatting.DARK_GRAY));
        }
        out.add(BrainsweepeeIngredient.getModNameComponent(loc.m_135827_()));
        return out;
    }

    @Override
    public Entity exampleEntity(Level level) {
        Iterator someEntityTys = BuiltInRegistries.f_256780_.m_206058_(this.entityTypeTag).iterator();
        if (someEntityTys.hasNext()) {
            Holder someTy = (Holder)someEntityTys.next();
            return ((EntityType)someTy.m_203334_()).m_20615_(level);
        }
        return null;
    }

    @Override
    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", BrainsweepeeIngredient.Type.ENTITY_TAG.m_7912_());
        obj.addProperty("tag", this.entityTypeTag.f_203868_().toString());
        return obj;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.entityTypeTag.f_203868_());
    }

    public static EntityTagIngredient deserialize(JsonObject obj) {
        ResourceLocation tagLoc = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)obj, (String)"tag"));
        if (tagLoc == null) {
            throw new IllegalArgumentException("unknown tag " + obj);
        }
        TagKey type = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagLoc);
        return new EntityTagIngredient(type);
    }

    public static EntityTagIngredient read(FriendlyByteBuf buf) {
        ResourceLocation typeLoc = buf.m_130281_();
        TagKey type = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)typeLoc);
        return new EntityTagIngredient(type);
    }

    @Override
    public BrainsweepeeIngredient.Type ingrType() {
        return BrainsweepeeIngredient.Type.ENTITY_TAG;
    }

    @Override
    public String getSomeKindOfReasonableIDForEmi() {
        ResourceLocation resloc = this.entityTypeTag.f_203868_();
        return resloc.m_135827_() + "//" + resloc.m_135815_();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityTagIngredient that = (EntityTagIngredient)o;
        return Objects.equals(this.entityTypeTag, that.entityTypeTag);
    }

    public int hashCode() {
        return Objects.hashCode(this.entityTypeTag);
    }
}

