/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.items.ItemJewelerHammer;
import at.petrak.hexcasting.common.items.ItemLens;
import at.petrak.hexcasting.common.items.ItemLoreFragment;
import at.petrak.hexcasting.common.items.ItemStaff;
import at.petrak.hexcasting.common.items.magic.ItemArtifact;
import at.petrak.hexcasting.common.items.magic.ItemCreativeUnlocker;
import at.petrak.hexcasting.common.items.magic.ItemCypher;
import at.petrak.hexcasting.common.items.magic.ItemMediaBattery;
import at.petrak.hexcasting.common.items.magic.ItemTrinket;
import at.petrak.hexcasting.common.items.pigment.ItemAmethystAndCopperPigment;
import at.petrak.hexcasting.common.items.pigment.ItemDyePigment;
import at.petrak.hexcasting.common.items.pigment.ItemPridePigment;
import at.petrak.hexcasting.common.items.pigment.ItemUUIDPigment;
import at.petrak.hexcasting.common.items.storage.ItemAbacus;
import at.petrak.hexcasting.common.items.storage.ItemFocus;
import at.petrak.hexcasting.common.items.storage.ItemScroll;
import at.petrak.hexcasting.common.items.storage.ItemSlate;
import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import at.petrak.hexcasting.common.items.storage.ItemThoughtKnot;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexCreativeTabs;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class HexItems {
    private static final Map<ResourceLocation, Item> ITEMS = new LinkedHashMap<ResourceLocation, Item>();
    private static final Map<CreativeModeTab, List<TabEntry>> ITEM_TABS = new LinkedHashMap<CreativeModeTab, List<TabEntry>>();
    public static final Item AMETHYST_DUST = HexItems.make("amethyst_dust", new Item(HexItems.props()));
    public static final Item CHARGED_AMETHYST = HexItems.make("charged_amethyst", new Item(HexItems.props()));
    public static final Item QUENCHED_SHARD = HexItems.make("quenched_allay_shard", new Item(HexItems.props()));
    public static final ItemStaff STAFF_OAK = HexItems.make("staff/oak", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_SPRUCE = HexItems.make("staff/spruce", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_BIRCH = HexItems.make("staff/birch", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_JUNGLE = HexItems.make("staff/jungle", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_ACACIA = HexItems.make("staff/acacia", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_DARK_OAK = HexItems.make("staff/dark_oak", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_CRIMSON = HexItems.make("staff/crimson", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_WARPED = HexItems.make("staff/warped", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_MANGROVE = HexItems.make("staff/mangrove", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_CHERRY = HexItems.make("staff/cherry", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_BAMBOO = HexItems.make("staff/bamboo", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_EDIFIED = HexItems.make("staff/edified", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_QUENCHED = HexItems.make("staff/quenched", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_MINDSPLICE = HexItems.make("staff/mindsplice", new ItemStaff(HexItems.unstackable()));
    public static final ItemLens SCRYING_LENS = HexItems.make("lens", new ItemLens(IXplatAbstractions.INSTANCE.addEquipSlotFabric(EquipmentSlot.HEAD).m_41487_(1)));
    public static final ItemAbacus ABACUS = HexItems.make("abacus", new ItemAbacus(HexItems.unstackable()));
    public static final ItemThoughtKnot THOUGHT_KNOT = HexItems.make("thought_knot", new ItemThoughtKnot(HexItems.unstackable()));
    public static final ItemFocus FOCUS = HexItems.make("focus", new ItemFocus(HexItems.unstackable()));
    public static final ItemSpellbook SPELLBOOK = HexItems.make("spellbook", new ItemSpellbook(HexItems.unstackable()));
    public static final ItemCypher CYPHER = HexItems.make("cypher", new ItemCypher(HexItems.unstackable()));
    public static final ItemTrinket TRINKET = HexItems.make("trinket", new ItemTrinket(HexItems.unstackable().m_41497_(Rarity.UNCOMMON)));
    public static final ItemArtifact ARTIFACT = HexItems.make("artifact", new ItemArtifact(HexItems.unstackable().m_41497_(Rarity.RARE)));
    public static final ItemJewelerHammer JEWELER_HAMMER = HexItems.make("jeweler_hammer", new ItemJewelerHammer((Tier)Tiers.IRON, 0, -2.8f, HexItems.props().m_41487_(1).m_41499_(Tiers.DIAMOND.m_6609_())));
    public static final ItemScroll SCROLL_SMOL = HexItems.make("scroll_small", new ItemScroll(HexItems.props(), 1));
    public static final ItemScroll SCROLL_MEDIUM = HexItems.make("scroll_medium", new ItemScroll(HexItems.props(), 2));
    public static final ItemScroll SCROLL_LARGE = HexItems.make("scroll", new ItemScroll(HexItems.props(), 3));
    public static final ItemSlate SLATE = HexItems.make("slate", new ItemSlate(HexBlocks.SLATE, HexItems.props()));
    public static final ItemMediaBattery BATTERY = HexItems.make("battery", new ItemMediaBattery(HexItems.unstackable()), null);
    public static final Supplier<ItemStack> BATTERY_DUST_STACK = HexItems.addToTab(() -> ItemMediaBattery.withMedia(new ItemStack((ItemLike)BATTERY), 640000L, 640000L), HexCreativeTabs.HEX);
    public static final Supplier<ItemStack> BATTERY_SHARD_STACK = HexItems.addToTab(() -> ItemMediaBattery.withMedia(new ItemStack((ItemLike)BATTERY), 3200000L, 3200000L), HexCreativeTabs.HEX);
    public static final Supplier<ItemStack> BATTERY_CRYSTAL_STACK = HexItems.addToTab(() -> ItemMediaBattery.withMedia(new ItemStack((ItemLike)BATTERY), 6400000L, 6400000L), HexCreativeTabs.HEX);
    public static final Supplier<ItemStack> BATTERY_QUENCHED_SHARD_STACK = HexItems.addToTab(() -> ItemMediaBattery.withMedia(new ItemStack((ItemLike)BATTERY), 19200000L, 19200000L), HexCreativeTabs.HEX);
    public static final Supplier<ItemStack> BATTERY_QUENCHED_BLOCK_STACK = HexItems.addToTab(() -> ItemMediaBattery.withMedia(new ItemStack((ItemLike)BATTERY), 76800000L, 76800000L), HexCreativeTabs.HEX);
    public static final EnumMap<DyeColor, ItemDyePigment> DYE_PIGMENTS = (EnumMap)Util.m_137537_(() -> {
        EnumMap<DyeColor, ItemDyePigment> out = new EnumMap<DyeColor, ItemDyePigment>(DyeColor.class);
        for (DyeColor dye : DyeColor.values()) {
            out.put(dye, HexItems.make("dye_colorizer_" + dye.m_41065_(), new ItemDyePigment(dye, HexItems.unstackable())));
        }
        return out;
    });
    public static final EnumMap<ItemPridePigment.Type, ItemPridePigment> PRIDE_PIGMENTS = (EnumMap)Util.m_137537_(() -> {
        EnumMap<ItemPridePigment.Type, ItemPridePigment> out = new EnumMap<ItemPridePigment.Type, ItemPridePigment>(ItemPridePigment.Type.class);
        for (ItemPridePigment.Type politicsInMyVidya : ItemPridePigment.Type.values()) {
            out.put(politicsInMyVidya, HexItems.make("pride_colorizer_" + politicsInMyVidya.getName(), new ItemPridePigment(politicsInMyVidya, HexItems.unstackable())));
        }
        return out;
    });
    public static final Item UUID_PIGMENT = HexItems.make("uuid_colorizer", new ItemUUIDPigment(HexItems.unstackable()));
    public static final Item DEFAULT_PIGMENT = HexItems.make("default_colorizer", new ItemAmethystAndCopperPigment(HexItems.unstackable()));
    public static final Item SUBMARINE_SANDWICH = HexItems.make("sub_sandwich", new Item(HexItems.props().m_41489_(new FoodProperties.Builder().m_38760_(14).m_38758_(1.2f).m_38767_())));
    public static final ItemLoreFragment LORE_FRAGMENT = HexItems.make("lore_fragment", new ItemLoreFragment(HexItems.unstackable().m_41497_(Rarity.RARE)));
    public static final ItemCreativeUnlocker CREATIVE_UNLOCKER = HexItems.make("creative_unlocker", new ItemCreativeUnlocker(HexItems.unstackable().m_41497_(Rarity.EPIC).m_41489_(new FoodProperties.Builder().m_38760_(20).m_38758_(1.0f).m_38765_().m_38767_())));

    public static void registerItems(BiConsumer<Item, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, Item> e : ITEMS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    public static void registerItemCreativeTab(CreativeModeTab.Output r, CreativeModeTab tab) {
        for (TabEntry item : ITEM_TABS.getOrDefault(tab, List.of())) {
            item.register(r);
        }
    }

    public static Item.Properties props() {
        return new Item.Properties();
    }

    public static Item.Properties unstackable() {
        return HexItems.props().m_41487_(1);
    }

    private static <T extends Item> T make(ResourceLocation id, T item, @Nullable CreativeModeTab tab) {
        Item old = ITEMS.put(id, item);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + id);
        }
        if (tab != null) {
            ITEM_TABS.computeIfAbsent(tab, t -> new ArrayList()).add(new TabEntry.ItemEntry(item));
        }
        return item;
    }

    private static <T extends Item> T make(String id, T item, @Nullable CreativeModeTab tab) {
        return HexItems.make(HexAPI.modLoc(id), item, tab);
    }

    private static <T extends Item> T make(String id, T item) {
        return HexItems.make(HexAPI.modLoc(id), item, HexCreativeTabs.HEX);
    }

    private static Supplier<ItemStack> addToTab(Supplier<ItemStack> stack, CreativeModeTab tab) {
        com.google.common.base.Supplier memoised = Suppliers.memoize(stack::get);
        ITEM_TABS.computeIfAbsent(tab, t -> new ArrayList()).add(new TabEntry.StackEntry((Supplier<ItemStack>)memoised));
        return memoised;
    }

    private static abstract class TabEntry {
        private TabEntry() {
        }

        abstract void register(CreativeModeTab.Output var1);

        static class StackEntry
        extends TabEntry {
            private final Supplier<ItemStack> stack;

            StackEntry(Supplier<ItemStack> stack) {
                this.stack = stack;
            }

            @Override
            void register(CreativeModeTab.Output r) {
                r.m_246342_(this.stack.get());
            }
        }

        static class ItemEntry
        extends TabEntry {
            private final Item item;

            ItemEntry(Item item) {
                this.item = item;
            }

            @Override
            void register(CreativeModeTab.Output r) {
                r.m_246326_((ItemLike)this.item);
            }
        }
    }
}

