/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.impl;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HexAPIImpl
implements HexAPI {
    private static final ConcurrentMap<EntityType<?>, HexAPI.EntityVelocityGetter<?>> SPECIAL_VELOCITIES = new ConcurrentHashMap();
    private static final ConcurrentMap<EntityType<?>, Consumer<?>> SPECIAL_BRAINSWEEPS = new ConcurrentHashMap();
    ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(){

        public int m_266425_(ArmorItem.Type type) {
            return 0;
        }

        public int m_7366_(ArmorItem.Type type) {
            return 0;
        }

        public int m_6646_() {
            return 0;
        }

        @NotNull
        public SoundEvent m_7344_() {
            return SoundEvents.f_11678_;
        }

        @NotNull
        public Ingredient m_6230_() {
            return Ingredient.f_43901_;
        }

        public String m_6082_() {
            return "robes";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    };

    @Override
    public <T extends Entity> void registerSpecialVelocityGetter(EntityType<T> key, HexAPI.EntityVelocityGetter<T> getter) {
        if (SPECIAL_VELOCITIES.containsKey(key)) {
            HexAPI.LOGGER.warn("A special velocity getter was already registered to {}, clobbering it!", (Object)key.toString());
        }
        SPECIAL_VELOCITIES.put(key, getter);
    }

    @Override
    public Vec3 getEntityVelocitySpecial(Entity entity) {
        EntityType type = entity.m_6095_();
        if (SPECIAL_VELOCITIES.containsKey(type)) {
            HexAPI.EntityVelocityGetter velGetter;
            HexAPI.EntityVelocityGetter erasedGetter = velGetter = (HexAPI.EntityVelocityGetter)SPECIAL_VELOCITIES.get(type);
            return erasedGetter.getVelocity(entity);
        }
        return entity.m_20184_();
    }

    @Override
    public <T extends Mob> void registerCustomBrainsweepingBehavior(EntityType<T> key, Consumer<T> hook) {
        if (SPECIAL_BRAINSWEEPS.containsKey(key)) {
            HexAPI.LOGGER.warn("A special brainsweep hook was already registered to {}, clobbering it!", (Object)key.toString());
        }
        SPECIAL_BRAINSWEEPS.put(key, hook);
    }

    @Override
    public <T extends Mob> Consumer<T> getBrainsweepBehavior(EntityType<T> mobType) {
        Consumer<Mob> behavior = SPECIAL_BRAINSWEEPS.getOrDefault(mobType, this.defaultBrainsweepingBehavior());
        return behavior;
    }

    @Override
    public Consumer<Mob> defaultBrainsweepingBehavior() {
        return mob -> mob.m_147272_();
    }

    @Override
    @Nullable
    public Sentinel getSentinel(ServerPlayer player) {
        return IXplatAbstractions.INSTANCE.getSentinel((Player)player);
    }

    @Override
    @Nullable
    public ADMediaHolder findMediaHolder(ItemStack stack) {
        return IXplatAbstractions.INSTANCE.findMediaHolder(stack);
    }

    @Override
    public FrozenPigment getColorizer(Player player) {
        return IXplatAbstractions.INSTANCE.getPigment(player);
    }

    @Override
    public ArmorMaterial robesMaterial() {
        return this.ARMOR_MATERIAL;
    }
}

