/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells.great;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapAlreadyBrainswept;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadBrainsweep;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadLocation;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.common.recipe.BrainsweepRecipe;
import at.petrak.hexcasting.common.recipe.HexRecipeStuffRegistry;
import at.petrak.hexcasting.ktxt.AccessorWrappers;
import at.petrak.hexcasting.mixin.accessor.AccessorLivingEntity;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/great/OpBrainsweep;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "()V", "argc", "", "getArgc", "()I", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "hasCastingSound", "", "ctx", "Spell", "hexcasting-forge-1.20.1"})
public final class OpBrainsweep
implements SpellAction {
    @NotNull
    public static final OpBrainsweep INSTANCE = new OpBrainsweep();
    private static final int argc = 2;

    private OpBrainsweep() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return false;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Object v0;
        BlockState state;
        BlockPos pos;
        Mob sacrifice;
        block5: {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            sacrifice = OperatorUtils.getMob(args, 0, this.getArgc());
            Vec3 vecPos = OperatorUtils.getVec3(args, 1, this.getArgc());
            pos = BlockPos.m_274446_((Position)((Position)vecPos));
            env.assertVecInRange(vecPos);
            env.assertEntityInRange((Entity)sacrifice);
            if (!env.canEditBlockAt(pos)) {
                throw new MishapBadLocation(vecPos, "forbidden");
            }
            if (sacrifice.m_6095_().m_204039_(HexTags.Entities.NO_BRAINSWEEPING)) {
                Intrinsics.checkNotNullExpressionValue((Object)pos, (String)"pos");
                throw new MishapBadBrainsweep(sacrifice, pos);
            }
            if (IXplatAbstractions.INSTANCE.isBrainswept(sacrifice)) {
                throw new MishapAlreadyBrainswept(sacrifice);
            }
            state = env.getWorld().m_8055_(pos);
            RecipeManager recman = env.getWorld().m_7465_();
            List recipes = recman.m_44013_(HexRecipeStuffRegistry.BRAINSWEEP_TYPE);
            Intrinsics.checkNotNullExpressionValue((Object)recipes, (String)"recipes");
            Iterable iterable = recipes;
            for (Object t : iterable) {
                BrainsweepRecipe it = (BrainsweepRecipe)t;
                boolean bl = false;
                if (!it.matches(state, (Entity)sacrifice, env.getWorld())) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        BrainsweepRecipe brainsweepRecipe = v0;
        if (brainsweepRecipe == null) {
            Intrinsics.checkNotNullExpressionValue((Object)pos, (String)"pos");
            throw new MishapBadBrainsweep(sacrifice, pos);
        }
        BrainsweepRecipe recipe = brainsweepRecipe;
        Intrinsics.checkNotNullExpressionValue((Object)pos, (String)"pos");
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"state");
        RenderedSpell renderedSpell = new Spell(pos, state, sacrifice, recipe);
        long l = recipe.mediaCost();
        Object[] objectArray = new ParticleSpray[2];
        Vec3 vec3 = sacrifice.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"sacrifice.position()");
        objectArray[0] = ParticleSpray.Companion.cloud$default(ParticleSpray.Companion, vec3, 1.0, 0, 4, null);
        Vec3 vec32 = Vec3.m_82512_((Vec3i)((Vec3i)pos));
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"atCenterOf(pos)");
        objectArray[1] = ParticleSpray.Companion.burst(vec32, 0.3, 100);
        return new SpellAction.Result(renderedSpell, l, CollectionsKt.listOf((Object[])objectArray), 0L, 8, null);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/great/OpBrainsweep$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "sacrifice", "Lnet/minecraft/world/entity/Mob;", "recipe", "Lat/petrak/hexcasting/common/recipe/BrainsweepRecipe;", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/Mob;Lat/petrak/hexcasting/common/recipe/BrainsweepRecipe;)V", "getPos", "()Lnet/minecraft/core/BlockPos;", "getRecipe", "()Lat/petrak/hexcasting/common/recipe/BrainsweepRecipe;", "getSacrifice", "()Lnet/minecraft/world/entity/Mob;", "getState", "()Lnet/minecraft/world/level/block/state/BlockState;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-forge-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final BlockPos pos;
        @NotNull
        private final BlockState state;
        @NotNull
        private final Mob sacrifice;
        @NotNull
        private final BrainsweepRecipe recipe;

        public Spell(@NotNull BlockPos pos, @NotNull BlockState state, @NotNull Mob sacrifice, @NotNull BrainsweepRecipe recipe) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)sacrifice, (String)"sacrifice");
            Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
            this.pos = pos;
            this.state = state;
            this.sacrifice = sacrifice;
            this.recipe = recipe;
        }

        @NotNull
        public final BlockPos getPos() {
            return this.pos;
        }

        @NotNull
        public final BlockState getState() {
            return this.state;
        }

        @NotNull
        public final Mob getSacrifice() {
            return this.sacrifice;
        }

        @NotNull
        public final BrainsweepRecipe getRecipe() {
            return this.recipe;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            env.getWorld().m_46597_(this.pos, BrainsweepRecipe.copyProperties(this.state, this.recipe.result()));
            IXplatAbstractions.INSTANCE.setBrainsweepAddlData(this.sacrifice);
            if (this.sacrifice instanceof Villager && HexConfig.server().doVillagersTakeOffenseAtMindMurder()) {
                LivingEntity livingEntity = env.getCastingEntity();
                if (livingEntity != null) {
                    LivingEntity it = livingEntity;
                    boolean bl = false;
                    AccessorWrappers.tellWitnessesThatIWasMurdered((Villager)this.sacrifice, (Entity)it);
                }
            }
            Mob mob = this.sacrifice;
            Intrinsics.checkNotNull((Object)mob, (String)"null cannot be cast to non-null type at.petrak.hexcasting.mixin.accessor.AccessorLivingEntity");
            SoundEvent sound = ((AccessorLivingEntity)mob).hex$getDeathSound();
            if (sound != null) {
                env.getWorld().m_6269_(null, (Entity)this.sacrifice, sound, SoundSource.AMBIENT, 0.8f, 1.0f);
            }
            env.getWorld().m_6269_(null, (Entity)this.sacrifice, SoundEvents.f_12275_, SoundSource.AMBIENT, 0.5f, 0.8f);
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final BlockPos component1() {
            return this.pos;
        }

        @NotNull
        public final BlockState component2() {
            return this.state;
        }

        @NotNull
        public final Mob component3() {
            return this.sacrifice;
        }

        @NotNull
        public final BrainsweepRecipe component4() {
            return this.recipe;
        }

        @NotNull
        public final Spell copy(@NotNull BlockPos pos, @NotNull BlockState state, @NotNull Mob sacrifice, @NotNull BrainsweepRecipe recipe) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)sacrifice, (String)"sacrifice");
            Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
            return new Spell(pos, state, sacrifice, recipe);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, BlockPos blockPos, BlockState blockState, Mob mob, BrainsweepRecipe brainsweepRecipe, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = spell.pos;
            }
            if ((n & 2) != 0) {
                blockState = spell.state;
            }
            if ((n & 4) != 0) {
                mob = spell.sacrifice;
            }
            if ((n & 8) != 0) {
                brainsweepRecipe = spell.recipe;
            }
            return spell.copy(blockPos, blockState, mob, brainsweepRecipe);
        }

        @NotNull
        public String toString() {
            return "Spell(pos=" + this.pos + ", state=" + this.state + ", sacrifice=" + this.sacrifice + ", recipe=" + this.recipe + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + this.state.hashCode();
            result = result * 31 + this.sacrifice.hashCode();
            result = result * 31 + this.recipe.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)spell.pos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.state, (Object)spell.state)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sacrifice, (Object)spell.sacrifice)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.recipe, (Object)spell.recipe);
        }
    }
}

