/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadItem;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadOffhandItem;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.common.items.magic.ItemMediaHolder;
import at.petrak.hexcasting.common.lib.HexItems;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpMakeBattery;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "()V", "argc", "", "getArgc", "()I", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Spell", "hexcasting-forge-1.20.1"})
public final class OpMakeBattery
implements SpellAction {
    @NotNull
    public static final OpMakeBattery INSTANCE = new OpMakeBattery();
    private static final int argc = 1;

    private OpMakeBattery() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        InteractionHand hand;
        ItemStack handStack;
        ItemEntity entity;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter(args, (String)"args");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                entity = OperatorUtils.getItemEntity(args, 0, this.getArgc());
                CastingEnvironment.HeldItemInfo heldItemInfo = env.getHeldItemToOperateOn(OpMakeBattery::execute$lambda$0);
                if (heldItemInfo == null) {
                    throw MishapBadOffhandItem.Companion.of(ItemStack.f_41583_.m_41777_(), "bottle", new Object[0]);
                }
                CastingEnvironment.HeldItemInfo heldItemInfo2 = heldItemInfo;
                handStack = heldItemInfo2.component1();
                hand = heldItemInfo2.component2();
                if (!handStack.m_204117_(HexTags.Items.PHIAL_BASE)) {
                    throw MishapBadOffhandItem.Companion.of(handStack, "bottle", new Object[0]);
                }
                if (handStack.m_41613_() != 1) {
                    throw MishapBadOffhandItem.Companion.of(handStack, "only_one", new Object[0]);
                }
                env.assertEntityInRange((Entity)entity);
                ItemStack itemStack = entity.m_32055_();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"entity.item");
                if (!MediaHelper.isMediaItem(itemStack)) break block6;
                ItemStack itemStack2 = entity.m_32055_();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"entity.item");
                if (MediaHelper.extractMedia$default(itemStack2, 0L, true, true, 2, null) > 0L) break block7;
            }
            throw MishapBadItem.Companion.of(entity, "media_for_battery");
        }
        Intrinsics.checkNotNullExpressionValue((Object)handStack, (String)"handStack");
        RenderedSpell renderedSpell = new Spell(entity, handStack, hand);
        Vec3 vec3 = entity.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"entity.position()");
        return new SpellAction.Result(renderedSpell, 100000L, CollectionsKt.listOf((Object)ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec3, 0.5, 0, 4, null)), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    private static final boolean execute$lambda$0(ItemStack it) {
        return it.m_204117_(HexTags.Items.PHIAL_BASE);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpMakeBattery$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "itemEntity", "Lnet/minecraft/world/entity/item/ItemEntity;", "handStack", "Lnet/minecraft/world/item/ItemStack;", "hand", "Lnet/minecraft/world/InteractionHand;", "(Lnet/minecraft/world/entity/item/ItemEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/InteractionHand;)V", "getHand", "()Lnet/minecraft/world/InteractionHand;", "getHandStack", "()Lnet/minecraft/world/item/ItemStack;", "getItemEntity", "()Lnet/minecraft/world/entity/item/ItemEntity;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-forge-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final ItemEntity itemEntity;
        @NotNull
        private final ItemStack handStack;
        @Nullable
        private final InteractionHand hand;

        public Spell(@NotNull ItemEntity itemEntity, @NotNull ItemStack handStack, @Nullable InteractionHand hand) {
            Intrinsics.checkNotNullParameter((Object)itemEntity, (String)"itemEntity");
            Intrinsics.checkNotNullParameter((Object)handStack, (String)"handStack");
            this.itemEntity = itemEntity;
            this.handStack = handStack;
            this.hand = hand;
        }

        @NotNull
        public final ItemEntity getItemEntity() {
            return this.itemEntity;
        }

        @NotNull
        public final ItemStack getHandStack() {
            return this.handStack;
        }

        @Nullable
        public final InteractionHand getHand() {
            return this.hand;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (!this.itemEntity.m_6084_()) {
                return;
            }
            ItemStack entityStack = this.itemEntity.m_32055_().m_41777_();
            Intrinsics.checkNotNullExpressionValue((Object)entityStack, (String)"entityStack");
            long mediamount = MediaHelper.extractMedia$default(entityStack, 0L, true, false, 10, null);
            if (mediamount > 0L && !env.replaceItem(arg_0 -> Spell.cast$lambda$0(this, arg_0), ItemMediaHolder.withMedia(new ItemStack((ItemLike)HexItems.BATTERY), mediamount, mediamount), this.hand)) {
                return;
            }
            this.itemEntity.m_32045_(entityStack);
            if (entityStack.m_41619_()) {
                this.itemEntity.m_6074_();
            }
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final ItemEntity component1() {
            return this.itemEntity;
        }

        @NotNull
        public final ItemStack component2() {
            return this.handStack;
        }

        @Nullable
        public final InteractionHand component3() {
            return this.hand;
        }

        @NotNull
        public final Spell copy(@NotNull ItemEntity itemEntity, @NotNull ItemStack handStack, @Nullable InteractionHand hand) {
            Intrinsics.checkNotNullParameter((Object)itemEntity, (String)"itemEntity");
            Intrinsics.checkNotNullParameter((Object)handStack, (String)"handStack");
            return new Spell(itemEntity, handStack, hand);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, ItemEntity itemEntity, ItemStack itemStack, InteractionHand interactionHand, int n, Object object) {
            if ((n & 1) != 0) {
                itemEntity = spell.itemEntity;
            }
            if ((n & 2) != 0) {
                itemStack = spell.handStack;
            }
            if ((n & 4) != 0) {
                interactionHand = spell.hand;
            }
            return spell.copy(itemEntity, itemStack, interactionHand);
        }

        @NotNull
        public String toString() {
            return "Spell(itemEntity=" + this.itemEntity + ", handStack=" + this.handStack + ", hand=" + this.hand + ")";
        }

        public int hashCode() {
            int result = this.itemEntity.hashCode();
            result = result * 31 + this.handStack.hashCode();
            result = result * 31 + (this.hand == null ? 0 : this.hand.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.itemEntity, (Object)spell.itemEntity)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.handStack, (Object)spell.handStack)) {
                return false;
            }
            return this.hand == spell.hand;
        }

        private static final boolean cast$lambda$0(Spell this$0, ItemStack it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return Intrinsics.areEqual((Object)it, (Object)this$0.handStack);
        }
    }
}

