/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.akashic;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.client.render.HexPatternPoints;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BlockEntityAkashicBookshelf
extends HexBlockEntity {
    public static final String TAG_PATTERN = "pattern";
    public static final String TAG_IOTA = "iota";
    public static final String TAG_DUMMY = "dummy";
    private HexPattern pattern = null;
    private CompoundTag iotaTag = null;
    public HexPatternPoints points;

    public BlockEntityAkashicBookshelf(BlockPos pWorldPosition, BlockState pBlockState) {
        super(HexBlockEntities.AKASHIC_BOOKSHELF_TILE, pWorldPosition, pBlockState);
    }

    @Nullable
    public HexPattern getPattern() {
        return this.pattern;
    }

    @Nullable
    public CompoundTag getIotaTag() {
        return this.iotaTag;
    }

    public void setNewMapping(HexPattern pattern, Iota iota) {
        boolean previouslyEmpty = this.pattern == null;
        this.pattern = pattern;
        this.iotaTag = IotaType.serialize(iota);
        if (previouslyEmpty) {
            BlockState oldBs = this.m_58900_();
            BlockState newBs = (BlockState)oldBs.m_61124_((Property)BlockAkashicBookshelf.HAS_BOOKS, (Comparable)Boolean.valueOf(true));
            this.f_58857_.m_7731_(this.m_58899_(), newBs, 3);
            this.f_58857_.m_7260_(this.m_58899_(), oldBs, newBs, 3);
        } else {
            this.m_6596_();
        }
    }

    public void clearIota() {
        boolean previouslyEmpty = this.pattern == null;
        this.pattern = null;
        this.iotaTag = null;
        if (!previouslyEmpty) {
            BlockState oldBs = this.m_58900_();
            BlockState newBs = (BlockState)oldBs.m_61124_((Property)BlockAkashicBookshelf.HAS_BOOKS, (Comparable)Boolean.valueOf(false));
            this.f_58857_.m_7731_(this.m_58899_(), newBs, 3);
            this.f_58857_.m_7260_(this.m_58899_(), oldBs, newBs, 3);
        } else {
            this.m_6596_();
        }
    }

    @Override
    protected void saveModData(CompoundTag compoundTag) {
        if (this.pattern != null && this.iotaTag != null) {
            compoundTag.m_128365_(TAG_PATTERN, (Tag)this.pattern.serializeToNBT());
            compoundTag.m_128365_(TAG_IOTA, (Tag)this.iotaTag);
        } else {
            compoundTag.m_128379_(TAG_DUMMY, false);
        }
    }

    @Override
    protected void loadModData(CompoundTag tag) {
        if (tag.m_128441_(TAG_PATTERN) && tag.m_128441_(TAG_IOTA)) {
            this.pattern = HexPattern.fromNBT(tag.m_128469_(TAG_PATTERN));
            this.iotaTag = tag.m_128469_(TAG_IOTA);
        } else if (tag.m_128441_(TAG_DUMMY)) {
            this.pattern = null;
            this.iotaTag = null;
        }
    }
}

