/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.template.packets;

import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.formations.tools.template.Template;
import com.supermartijn642.formations.tools.template.TemplateManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public class AllTemplatesPacket
implements BasePacket {
    private static final int MAX_TEMPLATES = 1000;
    private List<Template> templates;

    public AllTemplatesPacket(Collection<Template> templates) {
        if (templates.size() > 1000) {
            throw new IllegalArgumentException("More than 1000 templates! Realistically this should never happen!");
        }
        this.templates = new ArrayList<Template>(templates);
    }

    public AllTemplatesPacket() {
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.templates.size());
        this.templates.forEach(template -> template.write(buffer));
    }

    public void read(FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        if (count > 1000) {
            throw new IllegalStateException("Received AllTemplatesPacket packet for " + count + " templates! This should never be more than 1000!");
        }
        this.templates = new ArrayList<Template>(count);
        for (int i = 0; i < count; ++i) {
            this.templates.add(Template.load(buffer));
        }
    }

    public boolean verify(PacketContext context) {
        return this.templates.stream().allMatch(template -> Template.isValidName(template.getName()));
    }

    public void handle(PacketContext context) {
        if (context.getHandlingSide() == CoreSide.CLIENT) {
            TemplateManager templateManager = TemplateManager.get(context.getWorld());
            templateManager.clearAll();
            this.templates.forEach(templateManager::addTemplate);
        }
    }
}

