/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import org.jetbrains.annotations.NotNull;

public class FormationsBlockAgeProcessor
extends StructureProcessor
implements FormationsStructureProcessor {
    public static final Codec<FormationsBlockAgeProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("mossy_chance", (Object)Float.valueOf(0.3f)).forGetter(p -> Float.valueOf(p.mossiness)), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("degradation_chance", (Object)Float.valueOf(0.15f)).forGetter(p -> Float.valueOf(p.degradation)), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("disintegration_chance", (Object)Float.valueOf(0.05f)).forGetter(p -> Float.valueOf(p.disintegration))).apply((Applicative)instance, FormationsBlockAgeProcessor::new));
    private static final Set<Block> DISINTEGRATABLE_BLOCKS = Set.of(Blocks.f_50222_, Blocks.f_50194_, Blocks.f_50411_, Blocks.f_50609_, Blocks.f_50224_, Blocks.f_50225_, Blocks.f_50652_, Blocks.f_50157_, Blocks.f_50409_, Blocks.f_50274_, Blocks.f_50223_, Blocks.f_50631_, Blocks.f_50645_, Blocks.f_50079_, Blocks.f_50633_, Blocks.f_50647_, Blocks.f_50275_, Blocks.f_50062_, Blocks.f_50263_, Blocks.f_50406_, Blocks.f_50613_, Blocks.f_50064_, Blocks.f_50063_, Blocks.f_50394_, Blocks.f_50397_, Blocks.f_50467_, Blocks.f_50606_, Blocks.f_50396_, Blocks.f_50395_);
    private static final Map<Block, Block> BLOCK_TO_STAIR = Map.of(Blocks.f_50222_, Blocks.f_50194_, Blocks.f_50652_, Blocks.f_50157_, Blocks.f_50062_, Blocks.f_50263_, Blocks.f_50394_, Blocks.f_50263_, Blocks.f_152589_, Blocks.f_152590_);
    private static final Map<Block, Block> STAIR_TO_SLAB = Map.of(Blocks.f_50194_, Blocks.f_50411_, Blocks.f_50157_, Blocks.f_50409_, Blocks.f_50263_, Blocks.f_50406_, Blocks.f_50397_, Blocks.f_50467_, Blocks.f_152590_, Blocks.f_152591_);
    private static final Map<Block, List<Block>> BLOCK_TO_MOSSINESS = Map.of(Blocks.f_50222_, List.of(Blocks.f_50223_, Blocks.f_50224_), Blocks.f_50194_, List.of(Blocks.f_50631_), Blocks.f_50411_, List.of(Blocks.f_50645_), Blocks.f_50609_, List.of(Blocks.f_50607_), Blocks.f_50652_, List.of(Blocks.f_50079_), Blocks.f_50157_, List.of(Blocks.f_50633_), Blocks.f_50409_, List.of(Blocks.f_50647_), Blocks.f_50274_, List.of(Blocks.f_50275_), Blocks.f_152589_, List.of(Blocks.f_152594_), Blocks.f_50735_, List.of(Blocks.f_50736_));
    private final float mossiness;
    private final float degradation;
    private final float disintegration;

    public FormationsBlockAgeProcessor(float mossiness, float degradation, float disintegration) {
        this.mossiness = mossiness;
        this.degradation = degradation;
        this.disintegration = disintegration;
    }

    public FormationsBlockAgeProcessor() {
        this(0.3f, 0.15f, 0.05f);
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, BlockPos pos, LevelReader level, BlockPos piecePosition, BlockPos structurePosition, StructurePlaceSettings placeSettings, Map<BlockPos, BlockInstance> pieceBlocks) {
        RandomSource random = placeSettings.m_230326_(pos);
        BlockState state = block.state();
        if (DISINTEGRATABLE_BLOCKS.contains(state.m_60734_()) && random.m_188501_() < this.disintegration) {
            return BlockInstance.NOTHING;
        }
        if (BLOCK_TO_STAIR.containsKey(state.m_60734_()) && random.m_188501_() < this.degradation) {
            if ((state = BLOCK_TO_STAIR.get(state.m_60734_()).m_152465_(state)).m_61138_((Property)BlockStateProperties.f_61374_)) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(random));
            }
            if (state.m_61138_((Property)BlockStateProperties.f_61402_)) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)(random.m_188499_() ? Half.TOP : Half.BOTTOM));
            }
        }
        if (STAIR_TO_SLAB.containsKey(state.m_60734_()) && random.m_188501_() < this.degradation) {
            boolean topHalf = state.m_61138_((Property)BlockStateProperties.f_61402_) ? state.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP : random.m_188499_();
            state = STAIR_TO_SLAB.get(state.m_60734_()).m_152465_(state);
            if (state.m_61138_((Property)BlockStateProperties.f_61397_)) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)(topHalf ? SlabType.TOP : SlabType.BOTTOM));
            }
        }
        if (BLOCK_TO_MOSSINESS.containsKey(state.m_60734_()) && random.m_188501_() < this.mossiness) {
            List<Block> options = BLOCK_TO_MOSSINESS.get(state.m_60734_());
            state = options.get(random.m_188503_(options.size())).m_152465_(state);
        }
        if (state == block.state()) {
            return block;
        }
        return new BlockInstance(state, state.m_60713_(block.state().m_60734_()) ? block.nbt() : null);
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)FormationsStructures.BLOCK_AGE_PROCESSOR.get();
    }
}

