/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.StructurePlacement;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class SimpleStructure
extends Structure {
    public static final Codec<SimpleStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Structure.StructureSettings.f_226688_.forGetter(s -> s.modifiableStructureInfo().getOriginalStructureInfo().structureSettings()), (App)Codec.either((Codec)StructurePoolElement.f_210468_, (Codec)StructureTemplatePool.f_210555_).fieldOf("template").forGetter(s -> s.structure), (App)StructurePlacement.CODEC.fieldOf("placement").forGetter(s -> s.placement)).apply((Applicative)instance, SimpleStructure::new));
    private final Either<StructurePoolElement, Holder<StructureTemplatePool>> structure;
    private final StructurePlacement placement;

    public SimpleStructure(Structure.StructureSettings settings, Either<StructurePoolElement, Holder<StructureTemplatePool>> structure, StructurePlacement placement) {
        super(settings);
        this.structure = structure;
        this.placement = placement;
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        StructurePoolElement element = (StructurePoolElement)this.structure.map(Function.identity(), holder -> ((StructureTemplatePool)holder.m_203334_()).m_227355_((RandomSource)context.f_226626_()));
        if (element == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        int x = context.f_226628_().m_151382_(context.f_226626_().m_188503_(16));
        int z = context.f_226628_().m_151391_(context.f_226626_().m_188503_(16));
        Rotation rotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        BoundingBox boundingBox = element.m_214015_(context.f_226625_(), new BlockPos(x, 0, z), rotation);
        Optional<Integer> height = this.placement.findHeight(context, boundingBox);
        return height.map(y -> y - element.m_210540_() + 1).filter(y -> y >= context.f_226629_().m_141937_()).map(y -> new Structure.GenerationStub(new BlockPos(x, y.intValue(), z), piecesBuilder -> piecesBuilder.m_142679_((StructurePiece)new PoolElementStructurePiece(context.f_226625_(), element, new BlockPos(x, y.intValue(), z), element.m_210540_(), rotation, boundingBox.m_162367_(0, y.intValue(), 0)))));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)FormationsStructures.SIMPLE_STRUCTURE.get();
    }
}

