/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.StructurePlacement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PiecedStructure
extends Structure {
    public static final Codec<PiecedStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Structure.StructureSettings.f_226688_.forGetter(structure -> structure.modifiableStructureInfo().getOriginalStructureInfo().structureSettings()), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)7).fieldOf("max_depth").forGetter(structure -> structure.maxDepth), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)StructurePlacement.CODEC.fieldOf("placement").forGetter(s -> s.placement)).apply((Applicative)instance, PiecedStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final int maxDepth;
    private final int maxDistanceFromCenter;
    private final StructurePlacement placement;

    public PiecedStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth, int maxDistanceFromCenter, StructurePlacement placement) {
        super(settings);
        this.startPool = startPool;
        this.maxDepth = maxDepth;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.placement = placement;
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        StructurePoolElement element = ((StructureTemplatePool)this.startPool.m_203334_()).m_227355_((RandomSource)context.f_226626_());
        if (element == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        int x = context.f_226628_().m_151382_(context.f_226626_().m_188503_(16));
        int z = context.f_226628_().m_151391_(context.f_226626_().m_188503_(16));
        Rotation rotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        BoundingBox boundingBox = element.m_214015_(context.f_226625_(), new BlockPos(x, 0, z), rotation);
        Optional<Integer> height = this.placement.findHeight(context, boundingBox);
        if (height.isEmpty()) {
            return Optional.empty();
        }
        BlockPos pos = new BlockPos(x, height.get() + 1, z);
        return PiecedStructure.addPieces(context, element, rotation, this.maxDepth, pos, this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)FormationsStructures.PIECED_STRUCTURE.get();
    }

    private static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext context, StructurePoolElement startElement, Rotation rotation, int maxDepth, BlockPos pos, int maxDistanceFromCenter) {
        if (startElement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        ChunkGenerator chunkGenerator = context.f_226622_();
        StructureTemplateManager templateManager = context.f_226625_();
        LevelHeightAccessor levelHeightAccessor = context.f_226629_();
        WorldgenRandom random = context.f_226626_();
        Registry registry = context.f_226621_().m_175515_(Registries.f_256948_);
        PoolElementStructurePiece structurePiece = new PoolElementStructurePiece(templateManager, startElement, pos, startElement.m_210540_(), rotation, startElement.m_214015_(templateManager, pos, rotation));
        BoundingBox boundingBox = structurePiece.m_73547_();
        int centeredX = (boundingBox.m_162399_() + boundingBox.m_162395_()) / 2;
        int centeredZ = (boundingBox.m_162401_() + boundingBox.m_162398_()) / 2;
        int heightOffset = boundingBox.m_162396_() + structurePiece.m_72647_();
        structurePiece.m_6324_(0, pos.m_123342_() - heightOffset, 0);
        BlockPos centeredPos = new BlockPos(centeredX, pos.m_123342_(), centeredZ);
        return Optional.of(new Structure.GenerationStub(centeredPos, piecesBuilder -> {
            piecesBuilder.m_142679_((StructurePiece)structurePiece);
            if (maxDepth <= 0) {
                return;
            }
            VoxelShape allowedSpace = Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)new AABB(centeredPos).m_82400_((double)maxDistanceFromCenter)), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingBox)), (BooleanOp)BooleanOp.f_82685_);
            ArrayList pieces = Lists.newArrayList();
            JigsawPlacement.m_227210_((RandomState)context.f_226624_(), (int)maxDepth, (boolean)false, (ChunkGenerator)chunkGenerator, (StructureTemplateManager)templateManager, (LevelHeightAccessor)levelHeightAccessor, (RandomSource)random, (Registry)registry, (PoolElementStructurePiece)structurePiece, (List)pieces, (VoxelShape)allowedSpace);
            pieces.forEach(arg_0 -> ((StructurePiecesBuilder)piecesBuilder).m_142679_(arg_0));
        }));
    }
}

