/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.google.common.collect.ImmutableMap;
import com.stal111.forbidden_arcanus.common.item.CapacityBucket;
import com.stal111.forbidden_arcanus.common.item.EdelwoodMobBucketItem;
import com.stal111.forbidden_arcanus.core.init.ModEnchantments;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.valhelsia.valhelsia_core.api.common.util.ItemStackUtils;

public class EdelwoodBucketItem
extends BucketItem
implements CapacityBucket {
    public static final Map<Item, Supplier<? extends Item>> ITEM_TO_BUCKET = new ImmutableMap.Builder().put((Object)Items.f_42447_, ModItems.EDELWOOD_WATER_BUCKET).put((Object)Items.f_42448_, ModItems.EDELWOOD_LAVA_BUCKET).put((Object)Items.f_42455_, ModItems.EDELWOOD_MILK_BUCKET).put((Object)Items.f_151055_, ModItems.EDELWOOD_POWDER_SNOW_BUCKET).build();
    private static final double BURN_CHANCE = 0.005;
    private final int capacity;

    public EdelwoodBucketItem(Supplier<? extends Fluid> supplier, Item.Properties properties) {
        this(supplier, 0, properties);
    }

    public EdelwoodBucketItem(Supplier<? extends Fluid> supplier, int capacity, Item.Properties properties) {
        super(supplier, properties);
        this.capacity = capacity;
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Entity entity, int slot, boolean isSelected) {
        if (this.shouldBurn(stack, level, entity)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_150109_().m_6836_(slot, new ItemStack((ItemLike)Items.f_42414_));
            }
            BlockPos pos = entity.m_20183_();
            if (stack.m_150930_((Item)ModItems.EDELWOOD_LAVA_BUCKET.get())) {
                level.m_46597_(pos, this.getFluid().m_76145_().m_76188_());
            } else {
                Item item = stack.m_41720_();
                if (item instanceof EdelwoodMobBucketItem) {
                    EdelwoodMobBucketItem mobBucket = (EdelwoodMobBucketItem)item;
                    mobBucket.spawn((ServerLevel)level, stack, pos);
                }
            }
        }
        super.m_6883_(stack, level, entity, slot, isSelected);
    }

    private boolean shouldBurn(ItemStack stack, Level level, Entity entity) {
        if (level.m_5776_() || !this.canBurn(stack) || EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.PERMAFROST.get()), (ItemStack)stack) != 0) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_) {
                return false;
            }
        }
        return level.m_213780_().m_188500_() < 0.005;
    }

    protected boolean canBurn(ItemStack stack) {
        return this.getFluid().m_205067_(FluidTags.f_13132_);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        BlockHitResult hitResult;
        ItemStack stack = player.m_21120_(hand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)level, (ItemStack)stack, (HitResult)(hitResult = EdelwoodBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(this.getFluid() == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE))));
        if (ret != null) {
            return ret;
        }
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos pos = hitResult.m_82425_();
        Direction direction = hitResult.m_82434_();
        BlockPos relativePos = pos.m_121945_(direction);
        if (!level.m_7966_(player, pos) || !player.m_36204_(relativePos, direction, stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        BlockState state = level.m_8055_(pos);
        boolean flag = this.getFluid() == level.m_8055_(relativePos).m_60819_().m_76152_();
        boolean isEmptyFluid = this.getFluid().m_6212_(Fluids.f_76191_);
        if (isEmptyFluid || flag && !this.isFull(stack)) {
            Block block;
            if (!isEmptyFluid) {
                state = level.m_8055_(relativePos);
                pos = relativePos;
            }
            if ((block = state.m_60734_()) instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)block;
                ItemStack filledBucket = bucketPickup.m_142598_((LevelAccessor)level, pos, state);
                if (filledBucket.m_41619_() || !ITEM_TO_BUCKET.containsKey(filledBucket.m_41720_())) {
                    return this.cancelFluidPickup(pos, state, level, stack);
                }
                ItemStack bucket = new ItemStack((ItemLike)ITEM_TO_BUCKET.get(filledBucket.m_41720_()).get());
                ItemStack itemStack = filledBucket = stack.m_150930_(bucket.m_41720_()) ? stack.m_41777_() : ItemStackUtils.transferEnchantments((ItemStack)stack, (ItemStack)bucket);
                if (!isEmptyFluid && !((Boolean)this.tryFill(filledBucket).getFirst()).booleanValue()) {
                    return this.cancelFluidPickup(pos, state, level, stack);
                }
                filledBucket = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)filledBucket);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                bucketPickup.m_142298_().ifPresent(event -> player.m_5496_(event, 1.0f, 1.0f));
                level.m_142346_((Entity)player, GameEvent.f_157816_, pos);
                if (!level.m_5776_()) {
                    CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, filledBucket);
                }
                return InteractionResultHolder.m_19092_((Object)filledBucket, (boolean)level.m_5776_());
            }
        } else {
            BlockPos blockPos = pos = this.canBlockContainFluid(level, pos, state) ? pos : relativePos;
            if (this.m_142073_(player, level, pos, hitResult)) {
                this.m_142131_(player, level, stack, pos);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, pos, stack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)this.drainBucket(stack, player), (boolean)level.m_5776_());
            }
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private InteractionResultHolder<ItemStack> cancelFluidPickup(BlockPos pos, BlockState state, Level level, ItemStack stack) {
        level.m_7731_(pos, state, 11);
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private ItemStack drainBucket(ItemStack stack, Player player) {
        if (player.m_150110_().f_35937_) {
            return stack;
        }
        EdelwoodBucketItem edelwoodBucketItem = this;
        if (edelwoodBucketItem instanceof EdelwoodMobBucketItem) {
            EdelwoodMobBucketItem item = (EdelwoodMobBucketItem)edelwoodBucketItem;
            stack = this.transferFullness(stack, item.getFluidBucket());
        }
        stack = ((CapacityBucket)stack.m_41720_()).tryDrain(stack);
        return stack;
    }

    protected boolean canBlockContainFluid(Level level, BlockPos pos, BlockState state) {
        LiquidBlockContainer liquidBlockContainer;
        Block block = state.m_60734_();
        return block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, state, this.getFluid());
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public ItemStack getEmptyBucket() {
        return new ItemStack((ItemLike)ModItems.EDELWOOD_BUCKET.get());
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return !stack.m_150930_((Item)ModItems.EDELWOOD_BUCKET.get());
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return ItemStackUtils.transferEnchantments((ItemStack)stack, (ItemStack)new ItemStack((ItemLike)ModItems.EDELWOOD_BUCKET.get()));
    }
}

