/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.util.shapes;

import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.shapes.IPlane;
import com.flansmod.physics.common.util.shapes.IPolygon;
import com.flansmod.physics.common.util.shapes.VertexIndex;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record Polygon(@Nonnull ImmutableList<Vec3> vertices) implements IPolygon
{
    private static final Polygon EMPTY_POLYGON = new Polygon((ImmutableList<Vec3>)ImmutableList.of());

    @Nonnull
    public static Polygon empty() {
        return EMPTY_POLYGON;
    }

    @Nonnull
    public static Polygon point(@Nonnull Vec3 point) {
        return new Polygon((ImmutableList<Vec3>)ImmutableList.of((Object)point));
    }

    @Nonnull
    public static Polygon line(@Nonnull Vec3 a, @Nonnull Vec3 b) {
        return new Polygon((ImmutableList<Vec3>)ImmutableList.of((Object)a, (Object)b));
    }

    @Nonnull
    public static Polygon triangle(@Nonnull Vec3 a, @Nonnull Vec3 b, @Nonnull Vec3 c) {
        return new Polygon((ImmutableList<Vec3>)ImmutableList.of((Object)a, (Object)b, (Object)c));
    }

    @Nonnull
    public static Polygon square(@Nonnull Vec3 a, @Nonnull Vec3 b, @Nonnull Vec3 c, @Nonnull Vec3 d) {
        return new Polygon((ImmutableList<Vec3>)ImmutableList.of((Object)a, (Object)b, (Object)c, (Object)d));
    }

    @Nonnull
    public static Polygon ofLoopedVerts(@Nonnull ImmutableList<Vec3> vertices) {
        if (!vertices.isEmpty() && ((Vec3)vertices.get(0)).equals(vertices.get(vertices.size() - 1))) {
            return new Polygon((ImmutableList<Vec3>)ImmutableList.copyOf((Collection)vertices.subList(0, vertices.size() - 1)));
        }
        return new Polygon(vertices);
    }

    @Nonnull
    public static Polygon ofNonLoopedVerts(@Nonnull ImmutableList<Vec3> vertices) {
        return new Polygon(vertices);
    }

    @Nonnull
    public static IPolygon of(@Nonnull AABB aabb, @Nonnull Direction dir) {
        return new Polygon(VertexIndex.getAABBFace(aabb, dir));
    }

    @Nonnull
    public static IPolygon of(@Nonnull TransformedBB obb, @Nonnull Direction dir) {
        return obb.GetFace(dir);
    }

    @Override
    @Nonnull
    public List<Vec3> getVertices() {
        return this.vertices;
    }

    @Override
    @Nonnull
    public IPolygon clip(@Nonnull IPlane clipPlane) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.vertices.size(); ++i) {
            Optional<Vec3> clipPos;
            Vec3 vCurr = (Vec3)this.vertices.get(i);
            Vec3 vNext = this.getVertexLooped(i + 1);
            double dCurr = clipPlane.getPointHeightAbove(vCurr);
            double dNext = clipPlane.getPointHeightAbove(vNext);
            if (dCurr <= 0.0 && dNext <= 0.0) {
                builder.add((Object)vNext);
                continue;
            }
            if (dCurr > 0.0 && Maths.approx(dNext, 0.0)) {
                builder.add((Object)vNext);
                continue;
            }
            if (Maths.approx(dCurr, 0.0) && dNext > 0.0) continue;
            if (dCurr <= 0.0 && dNext > 0.0) {
                clipPos = clipPlane.rayPlaneIntersect(vCurr, vNext.m_82546_(vCurr));
                if (clipPos.isPresent()) {
                    builder.add((Object)clipPos.get());
                    continue;
                }
                FlansPhysicsMod.LOGGER.error("Clipped edge positive somehow didn't intersect");
                builder.add((Object)vNext);
                continue;
            }
            if (!(dCurr > 0.0) || !(dNext <= 0.0)) continue;
            clipPos = clipPlane.rayPlaneIntersect(vCurr, vNext.m_82546_(vCurr));
            if (clipPos.isPresent()) {
                builder.add((Object)clipPos.get());
            } else {
                FlansPhysicsMod.LOGGER.error("Clipped edge negative somehow didn't intersect");
                builder.add((Object)vNext);
            }
            builder.add((Object)vNext);
        }
        return Polygon.ofLoopedVerts((ImmutableList<Vec3>)builder.build());
    }

    @Override
    @Nonnull
    public IPolygon cullClip(@Nonnull IPlane clipPlane) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.vertices.size(); ++i) {
            Vec3 vCurr = (Vec3)this.vertices.get(i);
            double dCurr = -clipPlane.getPointHeightAbove(vCurr);
            if (!(dCurr >= 0.0)) continue;
            builder.add((Object)vCurr);
        }
        return Polygon.ofNonLoopedVerts((ImmutableList<Vec3>)builder.build());
    }
}

