/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.util.shapes;

import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.collision.TransformedBBCollection;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.ProjectedRange;
import com.flansmod.physics.common.util.ProjectionUtil;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.shapes.IPlane;
import com.flansmod.physics.common.util.shapes.Plane;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Vector3f;

public interface ISeparationAxis {
    @Nonnull
    public Vec3 getNormal();

    public double project(@Nonnull Vec3 var1);

    default public double projectOriginBoxMax(@Nonnull Vector3f halfExtents) {
        return Math.abs(this.getNormal().f_82479_ * (double)halfExtents.x) + Math.abs(this.getNormal().f_82480_ * (double)halfExtents.y) + Math.abs(this.getNormal().f_82481_ * (double)halfExtents.z);
    }

    default public double projectOriginBoxMin(@Nonnull Vector3f halfExtents) {
        return -(Math.abs(this.getNormal().f_82479_ * (double)halfExtents.x) + Math.abs(this.getNormal().f_82480_ * (double)halfExtents.y) + Math.abs(this.getNormal().f_82481_ * (double)halfExtents.z));
    }

    @Nonnull
    default public ProjectedRange projectOriginBox(@Nonnull Vector3f halfExtents) {
        return ProjectionUtil.ProjectAABBMinMax(this.getNormal(), -halfExtents.x, -halfExtents.y, -halfExtents.z, halfExtents.x, halfExtents.y, halfExtents.z);
    }

    @Nonnull
    default public ProjectedRange projectAABBMinMax(@Nonnull Vec3 point, @Nonnull Vector3f halfExtents) {
        return ProjectionUtil.ProjectAABBMinMax(this.getNormal(), point.f_82479_ - (double)halfExtents.x, point.f_82480_ - (double)halfExtents.y, point.f_82481_ - (double)halfExtents.z, point.f_82479_ + (double)halfExtents.x, point.f_82480_ + (double)halfExtents.y, point.f_82481_ + (double)halfExtents.z);
    }

    default public double projectAABBMin(@Nonnull Vec3 point, @Nonnull Vector3f halfExtents) {
        return this.projectAABBMinMax(point, halfExtents).min();
    }

    default public double projectAABBMax(@Nonnull Vec3 point, @Nonnull Vector3f halfExtents) {
        return this.projectAABBMinMax(point, halfExtents).max();
    }

    @Nonnull
    default public ProjectedRange projectAABBMinMax(@Nonnull AABB aabb) {
        return ProjectionUtil.ProjectAABBMinMax(this.getNormal(), aabb);
    }

    default public double projectAABBMin(@Nonnull AABB aabb) {
        return this.projectAABBMinMax(aabb).min();
    }

    default public double projectAABBMax(@Nonnull AABB aabb) {
        return this.projectAABBMinMax(aabb).max();
    }

    @Nonnull
    default public Pair<Double, IPlane> getSeparationPlaneAtoB(@Nonnull TransformedBB a, @Nonnull AABB b) {
        ProjectedRange aProjection = this.projectOBBMinMax(a);
        ProjectedRange bProjection = this.projectAABBMinMax(b);
        Pair<Double, ProjectionUtil.ProjectionComparison> pair = ProjectionUtil.GetSeparationDistanceAndOrder(aProjection, bProjection);
        return switch ((ProjectionUtil.ProjectionComparison)((Object)pair.getSecond())) {
            default -> throw new IncompatibleClassChangeError();
            case ProjectionUtil.ProjectionComparison.Separate_A_Then_B, ProjectionUtil.ProjectionComparison.Colliding_A_Then_B -> Pair.of((Object)((Double)pair.getFirst()), (Object)Plane.of(this.getNormal(), aProjection.max()));
            case ProjectionUtil.ProjectionComparison.Separate_B_Then_A, ProjectionUtil.ProjectionComparison.Colliding_B_Then_A -> Pair.of((Object)((Double)pair.getFirst()), (Object)Plane.of(this.getNormal().m_82490_(-1.0), -aProjection.min()));
        };
    }

    @Nonnull
    default public ProjectedRange projectOBBMinMax(@Nonnull Vec3 point, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        return ProjectionUtil.ProjectOBBMinMax(this.getNormal(), point, halfExtents, ori);
    }

    default public double projectOBBMin(@Nonnull Vec3 point, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        return this.projectOBBMinMax(point, halfExtents, ori).min();
    }

    default public double projectOBBMax(@Nonnull Vec3 point, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        return this.projectOBBMinMax(point, halfExtents, ori).max();
    }

    @Nonnull
    default public ProjectedRange projectOBBMinMax(@Nonnull TransformedBB obb) {
        return ProjectionUtil.ProjectOBBMinMax(this.getNormal(), obb);
    }

    default public double projectOBBMin(@Nonnull TransformedBB obb) {
        return this.projectOBBMinMax(obb).min();
    }

    default public double projectOBBMax(@Nonnull TransformedBB obb) {
        return this.projectOBBMinMax(obb).max();
    }

    @Nonnull
    default public ProjectedRange projectOBBsMinMax(@Nonnull TransformedBBCollection set) {
        Matrix3f matrix = set.Location().oriMatrix();
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < set.getCount(); ++i) {
            ProjectedRange projection = this.projectOBBMinMax(set.getCenter(i), set.getHalfExtents(i), matrix);
            min = Maths.min(projection.min(), min);
            max = Maths.min(projection.max(), max);
        }
        return ProjectedRange.preSorted(min, max);
    }

    default public double projectOBBsMin(@Nonnull TransformedBBCollection set) {
        return this.projectOBBsMinMax(set).min();
    }

    default public double projectOBBsMax(@Nonnull TransformedBBCollection set) {
        return this.projectOBBsMinMax(set).max();
    }

    default public boolean separates(@Nonnull TransformedBB a, @Nonnull TransformedBB b) {
        ProjectedRange projectionA = this.projectOBBMinMax(a);
        ProjectedRange projectionB = this.projectOBBMinMax(b);
        return ProjectionUtil.Separated(projectionA, projectionB);
    }

    default public boolean separates(@Nonnull TransformedBBCollection a, @Nonnull TransformedBBCollection b) {
        ProjectedRange projectionA = this.projectOBBsMinMax(a);
        ProjectedRange projectionB = this.projectOBBsMinMax(b);
        return ProjectionUtil.Separated(projectionA, projectionB);
    }

    default public double getSeparationDistance(@Nonnull TransformedBB a, @Nonnull TransformedBB b) {
        ProjectedRange aProjection = this.projectOBBMinMax(a);
        ProjectedRange bProjection = this.projectOBBMinMax(b);
        return ProjectionUtil.GetSeparationDistance(aProjection, bProjection);
    }

    @Nonnull
    default public Pair<Double, IPlane> getSeparationPlaneAtoB(@Nonnull TransformedBB a, @Nonnull TransformedBB b) {
        ProjectedRange aProjection = this.projectOBBMinMax(a);
        ProjectedRange bProjection = this.projectOBBMinMax(b);
        Pair<Double, ProjectionUtil.ProjectionComparison> pair = ProjectionUtil.GetSeparationDistanceAndOrder(aProjection, bProjection);
        return switch ((ProjectionUtil.ProjectionComparison)((Object)pair.getSecond())) {
            default -> throw new IncompatibleClassChangeError();
            case ProjectionUtil.ProjectionComparison.Separate_A_Then_B, ProjectionUtil.ProjectionComparison.Colliding_A_Then_B -> Pair.of((Object)((Double)pair.getFirst()), (Object)Plane.of(this.getNormal(), aProjection.max()));
            case ProjectionUtil.ProjectionComparison.Separate_B_Then_A, ProjectionUtil.ProjectionComparison.Colliding_B_Then_A -> Pair.of((Object)((Double)pair.getFirst()), (Object)Plane.of(this.getNormal().m_82490_(-1.0), -aProjection.min()));
        };
    }

    default public double getSeparationDistance(@Nonnull TransformedBBCollection a, @Nonnull TransformedBBCollection b) {
        ProjectedRange aProjection = this.projectOBBsMinMax(a);
        ProjectedRange bProjection = this.projectOBBsMinMax(b);
        return ProjectionUtil.GetSeparationDistance(aProjection, bProjection);
    }

    default public boolean separatesWithMotion(@Nonnull TransformedBB a, @Nonnull Vec3 motionA, @Nonnull TransformedBB b, @Nonnull Vec3 motionB) {
        ProjectedRange projectedRangeA = this.projectOBBMinMax(a);
        double projectedMotionA = this.project(motionA);
        ProjectedRange projectedRangeB = this.projectOBBMinMax(b);
        double projectedMotionB = this.project(motionB);
        return ProjectionUtil.SeparatedWithMotion(projectedRangeA, projectedMotionA, projectedRangeB, projectedMotionB);
    }

    default public boolean separatesWithMotion(@Nonnull TransformedBBCollection a, @Nonnull Vec3 motionA, @Nonnull TransformedBBCollection b, @Nonnull Vec3 motionB) {
        ProjectedRange projectedRangeA = this.projectOBBsMinMax(a);
        double projectedMotionA = this.project(motionA);
        ProjectedRange projectedRangeB = this.projectOBBsMinMax(b);
        double projectedMotionB = this.project(motionB);
        return ProjectionUtil.SeparatedWithMotion(projectedRangeA, projectedMotionA, projectedRangeB, projectedMotionB);
    }

    default public double getSeparationDistanceWithMotion(@Nonnull TransformedBB a, @Nonnull Vec3 motionA, @Nonnull TransformedBB b, @Nonnull Vec3 motionB) {
        ProjectedRange aProjection = this.projectOBBMinMax(a);
        double projectedMotionA = this.project(motionA);
        ProjectedRange bProjection = this.projectOBBMinMax(b);
        double projectedMotionB = this.project(motionB);
        return ProjectionUtil.GetSeparationDistanceWithMotion(aProjection, projectedMotionA, bProjection, projectedMotionB);
    }

    default public double getSeparationDistanceWithMotion(@Nonnull TransformedBBCollection a, @Nonnull Vec3 motionA, @Nonnull TransformedBBCollection b, @Nonnull Vec3 motionB) {
        ProjectedRange aProjection = this.projectOBBsMinMax(a);
        double projectedMotionA = this.project(motionA);
        ProjectedRange bProjection = this.projectOBBsMinMax(b);
        double projectedMotionB = this.project(motionB);
        return ProjectionUtil.GetSeparationDistanceWithMotion(aProjection, projectedMotionA, bProjection, projectedMotionB);
    }

    default public double getMaximumProjectedMotion(@Nonnull TransformedBB start, @Nonnull Transform endPos) {
        return ProjectionUtil.ProjectMaxVertexDelta(this.getNormal(), start.HalfExtents(), start.GetCenter(), start.Loc().oriMatrix(), endPos.positionVec3(), endPos.oriMatrix());
    }

    default public double getMaximumProjectedMotion(@Nonnull TransformedBBCollection start, @Nonnull Transform endPos) {
        double max = 0.0;
        for (int i = 0; i < start.getCount(); ++i) {
            double motion = this.getMaximumProjectedMotion(start.getColliderBB(i), endPos);
            if (!(motion > max)) continue;
            max = motion;
        }
        return max;
    }
}

