/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.util.shapes;

import com.flansmod.physics.client.DebugRenderer;
import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.collision.TransformedBBCollection;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.ProjectionUtil;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.shapes.IPolygon;
import com.flansmod.physics.common.util.shapes.ISeparationAxis;
import com.flansmod.physics.common.util.shapes.VertexIndex;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public interface IPlane
extends ISeparationAxis {
    public double getDistance();

    @Nonnull
    public Optional<Vec3> rayPlaneIntersect(@Nonnull Vec3 var1, @Nonnull Vec3 var2);

    default public double getPointHeightAbove(@Nonnull Vec3 point) {
        return this.project(point) - this.getDistance();
    }

    default public boolean isPointOn(@Nonnull Vec3 point) {
        return Maths.approx(this.getPointHeightAbove(point), 0.0);
    }

    default public boolean isPointOn(@Nonnull Vec3 point, double epsilon) {
        return Maths.approx(this.getPointHeightAbove(point), 0.0, epsilon);
    }

    default public boolean isPointOnOrBelow(@Nonnull Vec3 point) {
        return this.getPointHeightAbove(point) <= 0.0;
    }

    default public boolean isPointOnOrAbove(@Nonnull Vec3 point) {
        return this.getPointHeightAbove(point) >= 0.0;
    }

    default public boolean isPointApproxBelow(@Nonnull Vec3 point) {
        return this.getPointHeightAbove(point) < -1.0E-7;
    }

    default public boolean isPointApproxAbove(@Nonnull Vec3 point) {
        return this.getPointHeightAbove(point) > 1.0E-7;
    }

    default public boolean isPointApproxBelow(@Nonnull Vec3 point, double epsilon) {
        return this.getPointHeightAbove(point) < -epsilon;
    }

    default public boolean isPointApproxAbove(@Nonnull Vec3 point, double epsilon) {
        return this.getPointHeightAbove(point) > epsilon;
    }

    default public boolean isAABBFullyBelow(@Nonnull Vec3 point, @Nonnull Vector3f halfExtents) {
        return this.projectAABBMax(point, halfExtents) <= this.getDistance();
    }

    default public boolean isAABBFullyAbove(@Nonnull Vec3 point, @Nonnull Vector3f halfExtents) {
        return this.projectAABBMin(point, halfExtents) >= this.getDistance();
    }

    default public double getAABBHeightAbove(@Nonnull Vec3 point, @Nonnull Vector3f halfExtents) {
        return this.projectAABBMin(point, halfExtents) - this.getDistance();
    }

    default public double getAABBHeightBelow(@Nonnull Vec3 point, @Nonnull Vector3f halfExtents) {
        return this.projectAABBMax(point, halfExtents) - this.getDistance();
    }

    default public boolean isAABBFullyBelow(@Nonnull AABB aabb) {
        return this.projectAABBMax(aabb) <= this.getDistance();
    }

    default public boolean isAABBFullyAbove(@Nonnull AABB aabb) {
        return this.projectAABBMin(aabb) >= this.getDistance();
    }

    default public double getAABBHeightAbove(@Nonnull AABB aabb) {
        return this.projectAABBMin(aabb) - this.getDistance();
    }

    default public double getAABBHeightBelow(@Nonnull AABB aabb) {
        return this.projectAABBMax(aabb) - this.getDistance();
    }

    default public boolean isOBBFullyBelow(@Nonnull Vec3 point, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        return this.projectOBBMin(point, halfExtents, ori) <= this.getDistance();
    }

    default public boolean isOBBFullyAbove(@Nonnull Vec3 point, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        return this.projectOBBMax(point, halfExtents, ori) >= this.getDistance();
    }

    default public double getOBBHeightAbove(@Nonnull Vec3 point, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        return this.projectOBBMin(point, halfExtents, ori) - this.getDistance();
    }

    default public double getOBBHeightBelow(@Nonnull Vec3 point, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        return this.projectOBBMax(point, halfExtents, ori) - this.getDistance();
    }

    default public boolean isOBBFullyBelow(@Nonnull TransformedBB bb) {
        return this.isOBBFullyBelow(bb.GetCenter(), bb.HalfExtents(), bb.Loc().oriMatrix());
    }

    default public boolean isOBBFullyAbove(@Nonnull TransformedBB bb) {
        return this.isOBBFullyAbove(bb.GetCenter(), bb.HalfExtents(), bb.Loc().oriMatrix());
    }

    default public double getOBBHeightAbove(@Nonnull TransformedBB bb) {
        return this.getOBBHeightAbove(bb.GetCenter(), bb.HalfExtents(), bb.Loc().oriMatrix());
    }

    default public double getOBBHeightBelow(@Nonnull TransformedBB bb) {
        return this.getOBBHeightBelow(bb.GetCenter(), bb.HalfExtents(), bb.Loc().oriMatrix());
    }

    default public boolean isOBBsFullyBelow(@Nonnull TransformedBBCollection bbs) {
        return this.projectOBBsMax(bbs) <= this.getDistance();
    }

    default public boolean isOBBsFullyAbove(@Nonnull TransformedBBCollection bbs) {
        return this.projectOBBsMin(bbs) >= this.getDistance();
    }

    default public double getOBBsHeightAbove(@Nonnull TransformedBBCollection bbs) {
        return this.projectOBBsMin(bbs) - this.getDistance();
    }

    default public double getOBBsHeightBelow(@Nonnull TransformedBBCollection bbs) {
        return this.projectOBBsMax(bbs) - this.getDistance();
    }

    @Nonnull
    default public Optional<Vec3> linePlaneIntersect(@Nonnull Vec3 pointA, @Nonnull Vec3 pointB) {
        return this.rayPlaneIntersect(pointA, pointB.m_82546_(pointA));
    }

    @Nonnull
    default public VertexIndex selectCornerOBBMax(@Nonnull Vec3 center, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        return ProjectionUtil.SelectCornerOBBMax(this.getNormal(), center, halfExtents, ori);
    }

    @Nonnull
    default public VertexIndex selectCornerOBBMin(@Nonnull Vec3 center, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        return ProjectionUtil.SelectCornerOBBMin(this.getNormal(), center, halfExtents, ori);
    }

    @Nonnull
    default public Direction selectFaceOBBMax(@Nonnull Vec3 center, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        VertexIndex corner = this.selectCornerOBBMax(center, halfExtents, ori);
        Direction bestDir = null;
        double mostParallel = -1.0;
        for (Direction dir : corner.getPossibleFaces()) {
            Vec3i dirNormal = dir.m_122436_();
            Vector3f dirNormalF = new Vector3f((float)dirNormal.m_123341_(), (float)dirNormal.m_123342_(), (float)dirNormal.m_123343_());
            dirNormalF.mul((Matrix3fc)ori);
            Vec3 faceNormal = new Vec3(dirNormalF);
            double parallelity = faceNormal.m_82526_(this.getNormal());
            if (!(parallelity > mostParallel)) continue;
            bestDir = dir;
            mostParallel = parallelity;
        }
        if (bestDir == null) {
            FlansPhysicsMod.LOGGER.error("No faces parallel??");
            return Direction.UP;
        }
        return bestDir;
    }

    @Nonnull
    default public Direction selectFaceOBBMax(@Nonnull TransformedBB obb) {
        return this.selectFaceOBBMax(obb.GetCenter(), obb.HalfExtents(), obb.Loc().oriMatrix());
    }

    @Nonnull
    default public Direction selectFaceOBBMin(@Nonnull Vec3 center, @Nonnull Vector3f halfExtents, @Nonnull Matrix3f ori) {
        return this.selectFaceOBBMax(center, halfExtents, ori).m_122424_();
    }

    @Nonnull
    default public Direction selectFaceOBBMin(@Nonnull TransformedBB obb) {
        return this.selectFaceOBBMax(obb).m_122424_();
    }

    @Nonnull
    default public Direction selectFaceAABBMin(@Nonnull AABB aabb) {
        return Direction.m_122366_((double)this.getNormal().f_82479_, (double)this.getNormal().f_82480_, (double)this.getNormal().f_82481_).m_122424_();
    }

    @Nonnull
    default public Direction selectFaceAABBMax(@Nonnull AABB aabb) {
        return Direction.m_122366_((double)this.getNormal().f_82479_, (double)this.getNormal().f_82480_, (double)this.getNormal().f_82481_);
    }

    @Nonnull
    default public IPolygon collisionClip(@Nonnull IPolygon incident, @Nonnull IPolygon reference) {
        Vec3 vEdge;
        Transform vCurrent;
        int i;
        for (i = 0; i < incident.GetNumVertices(); ++i) {
            vCurrent = Transform.fromPos(incident.getVertex(i));
            vEdge = incident.getEdgeVector(i);
            DebugRenderer.renderLine(vCurrent, 4, new Vector4f(1.0f, 0.0f, 0.0f, 1.0f), vEdge);
            DebugRenderer.renderPoint(vCurrent, 4, new Vector4f(1.0f, 0.0f, 0.0f, 1.0f));
        }
        for (i = 0; i < reference.GetNumVertices(); ++i) {
            vCurrent = Transform.fromPos(reference.getVertex(i));
            vEdge = reference.getEdgeVector(i);
            DebugRenderer.renderLine(vCurrent, 4, new Vector4f(0.0f, 1.0f, 0.0f, 1.0f), vEdge);
            DebugRenderer.renderPoint(vCurrent, 4, new Vector4f(0.0f, 1.0f, 0.0f, 1.0f));
        }
        int refVertexCount = reference.GetNumVertices();
        for (int i2 = 0; i2 < refVertexCount; ++i2) {
            IPlane clipPlane = reference.getEdgeClipPlane(this.getNormal(), i2);
            incident = incident.clip(clipPlane);
        }
        incident = incident.cullClip(reference.getFaceClipPlane());
        return incident;
    }

    default public boolean areOBBsFullyBelow(@Nonnull TransformedBBCollection set) {
        Matrix3f mat = set.Location().oriMatrix();
        for (int i = 0; i < set.getCount(); ++i) {
            if (this.isOBBFullyBelow(set.getCenter(i), set.getHalfExtents(i), mat)) continue;
            return false;
        }
        return true;
    }

    default public boolean areOBBsFullyAbove(@Nonnull TransformedBBCollection set) {
        Matrix3f mat = set.Location().oriMatrix();
        for (int i = 0; i < set.getCount(); ++i) {
            if (this.isOBBFullyAbove(set.getCenter(i), set.getHalfExtents(i), mat)) continue;
            return false;
        }
        return true;
    }
}

