/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.util;

import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryUtil;

public class Transform {
    private static final Vector3d IDENTITY_POS = new Vector3d();
    private static final Quaternionf IDENTITY_QUAT = new Quaternionf();
    private static final Vector3f IDENTITY_SCALE = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final Transform IDENTITY = new Transform();
    @Nonnull
    public final Vector3d Position;
    @Nonnull
    public final Quaternionf Orientation;
    @Nonnull
    public final Vector3f Scale;
    private static final NumberFormat FLOAT_FORMAT = new DecimalFormat("#.##");
    private static final NumberFormat ANGLE_FORMAT = new DecimalFormat("#");

    private void constructorNaNCheck() {
        if (FMLEnvironment.production) {
            return;
        }
        if ((double)this.Orientation.lengthSquared() < 0.01) {
            FlansPhysicsMod.LOGGER.error("Transform has near-zero Quaternion");
        }
        if (this.hasNaN()) {
            FlansPhysicsMod.LOGGER.error("Transform failed NaN check");
        }
    }

    private Transform(double x, double y, double z, float pitch, float yaw, float roll, float scale) {
        this.Position = new Vector3d(x, y, z);
        this.Orientation = Transform.quatFromEuler(pitch, yaw, roll);
        this.Scale = new Vector3f(scale, scale, scale);
        this.constructorNaNCheck();
    }

    private Transform(@Nonnull Vec3 pos, @Nonnull Quaternionf rotation, @Nonnull Vector3f scale) {
        this.Position = new Vector3d(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.Orientation = new Quaternionf((Quaternionfc)rotation);
        this.Scale = new Vector3f((Vector3fc)scale);
        this.constructorNaNCheck();
    }

    private Transform(@Nonnull Vector3d pos, @Nonnull Quaternionf rotation, @Nonnull Vector3f scale) {
        this.Position = new Vector3d(pos.x, pos.y, pos.z);
        this.Orientation = new Quaternionf((Quaternionfc)rotation);
        this.Scale = new Vector3f((Vector3fc)scale);
        this.constructorNaNCheck();
    }

    private Transform(double x, double y, double z, @Nonnull Quaternionf rotation, float scale) {
        this.Position = new Vector3d(x, y, z);
        this.Orientation = new Quaternionf((Quaternionfc)rotation);
        this.Scale = new Vector3f(scale, scale, scale);
        this.constructorNaNCheck();
    }

    private Transform(double x, double y, double z, float scale) {
        this.Position = new Vector3d(x, y, z);
        this.Orientation = IDENTITY_QUAT;
        this.Scale = new Vector3f(scale, scale, scale);
        this.constructorNaNCheck();
    }

    private Transform(@Nonnull Vector3f pos, @Nonnull Quaternionf rotation, @Nonnull Vector3f scale) {
        this.Position = new Vector3d((double)pos.x, (double)pos.y, (double)pos.z);
        this.Orientation = new Quaternionf((Quaternionfc)rotation);
        this.Scale = new Vector3f((Vector3fc)scale);
        this.constructorNaNCheck();
    }

    private Transform(float scale) {
        this.Position = IDENTITY_POS;
        this.Orientation = IDENTITY_QUAT;
        this.Scale = new Vector3f(scale, scale, scale);
        this.constructorNaNCheck();
    }

    private Transform() {
        this.Position = IDENTITY_POS;
        this.Orientation = IDENTITY_QUAT;
        this.Scale = IDENTITY_SCALE;
        this.constructorNaNCheck();
    }

    private Transform(@Nonnull Transform other) {
        this(other.Position, other.Orientation, other.Scale);
    }

    @Nonnull
    public static Transform compose(Transform ... transforms) {
        return TransformStack.of(transforms).top();
    }

    @Nonnull
    public static Transform identity() {
        return new Transform();
    }

    @Nonnull
    public static Transform fromScale(float scale) {
        return new Transform(scale);
    }

    @Nonnull
    public static Transform fromScale(@Nonnull Vector3f scale) {
        return new Transform(IDENTITY_POS, IDENTITY_QUAT, scale);
    }

    @Nonnull
    public static Transform fromPos(@Nonnull Vec3 pos) {
        return new Transform(pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.0f);
    }

    @Nonnull
    public static Transform fromPos(@Nonnull Vector3d pos) {
        return new Transform(pos, IDENTITY_QUAT, IDENTITY_SCALE);
    }

    @Nonnull
    public static Transform fromPos(double x, double y, double z) {
        return new Transform(x, y, z, 1.0f);
    }

    @Nonnull
    public static Transform fromPosAndQuat(double x, double y, double z, @Nonnull Quaternionf ori) {
        return new Transform(x, y, z, ori, 1.0f);
    }

    @Nonnull
    public static Transform fromPosAndQuat(@Nonnull Vector3d pos, @Nonnull Quaternionf ori) {
        return new Transform(pos.x, pos.y, pos.z, ori, 1.0f);
    }

    @Nonnull
    public static Transform fromPosAndQuat(@Nonnull Vec3 pos, @Nonnull Quaternionf ori) {
        return new Transform(pos.f_82479_, pos.f_82480_, pos.f_82481_, ori, 1.0f);
    }

    @Nonnull
    public static Transform fromPosAndEuler(@Nonnull Vec3 pos, @Nonnull Vector3f euler) {
        return new Transform(pos.f_82479_, pos.f_82480_, pos.f_82481_, euler.x, euler.y, euler.z, 1.0f);
    }

    @Nonnull
    public static Transform fromPosAndEuler(@Nonnull Vector3f pos, @Nonnull Vector3f euler) {
        return new Transform(pos.x, pos.y, pos.z, euler.x, euler.y, euler.z, 1.0f);
    }

    @Nonnull
    public static Transform fromPosAndEuler(@Nonnull Vec3 pos, float pitch, float yaw, float roll) {
        return new Transform(pos.f_82479_, pos.f_82480_, pos.f_82481_, pitch, yaw, roll, 1.0f);
    }

    @Nonnull
    public static Transform fromEuler(float pitch, float yaw, float roll) {
        return new Transform(0.0, 0.0, 0.0, Transform.quatFromEuler(pitch, yaw, roll), 1.0f);
    }

    @Nonnull
    public static Transform fromEulerRadians(float pitch, float yaw, float roll) {
        return new Transform(0.0, 0.0, 0.0, Transform.quatFromEulerRadians(pitch, yaw, roll), 1.0f);
    }

    @Nonnull
    public static Transform fromEuler(@Nonnull Vector3f euler) {
        return new Transform(0.0, 0.0, 0.0, Transform.quatFromEuler(euler), 1.0f);
    }

    @Nonnull
    public static Transform fromLookDirection(@Nonnull Vec3 forward, @Nonnull Vec3 up) {
        return new Transform(0.0, 0.0, 0.0, Transform.lookAlong(forward, up), 1.0f);
    }

    @Nonnull
    public static Transform fromPositionAndLookDirection(@Nonnull Vec3 pos, @Nonnull Vec3 forward, @Nonnull Vec3 up) {
        return new Transform(pos.f_82479_, pos.f_82480_, pos.f_82481_, Transform.lookAlong(forward, up), 1.0f);
    }

    @Nonnull
    public static Transform fromBlockPos(@Nonnull BlockPos blockPos) {
        return new Transform(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), 1.0f);
    }

    @Nonnull
    public static Transform fromItem(@Nonnull ItemTransform itemTransform) {
        return new Transform(itemTransform.f_111756_.x, itemTransform.f_111756_.y, itemTransform.f_111756_.z, Transform.quatFromEuler(itemTransform.f_111755_), itemTransform.f_111757_.x);
    }

    @Nonnull
    public static Transform fromEntity(@Nonnull Entity entity) {
        return Transform.fromPosAndEuler(entity.m_20182_(), entity.m_146909_(), entity.m_146908_(), 0.0f);
    }

    @Nonnull
    public static Transform copy(@Nonnull Transform other) {
        return new Transform(other);
    }

    @Nonnull
    public static Transform error(final @Nonnull String errorMessage) {
        return new Transform(){

            @Override
            @Nonnull
            public String toString() {
                return errorMessage;
            }
        };
    }

    @Nonnull
    public static Transform extractOrientation(@Nonnull Transform from, boolean invert) {
        Quaternionf ori = invert ? from.Orientation.invert(new Quaternionf()) : from.Orientation;
        return new Transform(0.0, 0.0, 0.0, ori, 1.0f);
    }

    @Nonnull
    public static Transform extractPosition(@Nonnull Transform from, double scale) {
        Vector3d pos = from.Position.mul(scale, new Vector3d());
        return new Transform(pos.x, pos.y, pos.z, IDENTITY_QUAT, 1.0f);
    }

    @Nonnull
    public static Transform flatten(@Nonnull Consumer<TransformStack> func) {
        TransformStack stack = TransformStack.of();
        func.accept(stack);
        return stack.top();
    }

    @Nonnull
    public CompoundTag toTag(boolean storePos, boolean storeOri, boolean storeScale) {
        CompoundTag tags = new CompoundTag();
        if (storePos) {
            tags.m_128347_("px", this.Position.x);
            tags.m_128347_("py", this.Position.y);
            tags.m_128347_("pz", this.Position.z);
        }
        if (storeOri) {
            Vector3f euler = Transform.toEuler(this.Orientation);
            tags.m_128350_("rp", euler.x);
            tags.m_128350_("ry", euler.y);
            tags.m_128350_("rr", euler.z);
        }
        if (storeScale) {
            tags.m_128350_("sx", this.Scale.x);
            tags.m_128350_("sy", this.Scale.y);
            tags.m_128350_("sz", this.Scale.z);
        }
        return tags;
    }

    @Nonnull
    public CompoundTag toPosTag() {
        return this.toTag(true, false, false);
    }

    @Nonnull
    public CompoundTag toPosAndOriTag() {
        return this.toTag(true, true, false);
    }

    @Nonnull
    public static Transform fromTag(@Nonnull CompoundTag tags, @Nullable Vec3 withPos, @Nullable Quaternionf withOri, @Nullable Vector3f withScale) {
        if (withPos == null) {
            double x = tags.m_128459_("px");
            double y = tags.m_128459_("py");
            double z = tags.m_128459_("pz");
            withPos = new Vec3(x, y, z);
        }
        if (withOri == null) {
            float pitch = tags.m_128457_("rp");
            float yaw = tags.m_128457_("ry");
            float roll = tags.m_128457_("rr");
            withOri = Transform.quatFromEuler(pitch, yaw, roll);
        }
        if (withScale == null) {
            float scaleX = tags.m_128457_("sx");
            float scaleY = tags.m_128457_("sy");
            float scaleZ = tags.m_128457_("sz");
            withScale = new Vector3f(scaleX, scaleY, scaleZ);
        }
        return new Transform(withPos, withOri, withScale);
    }

    @Nonnull
    public static Transform fromTag(@Nonnull CompoundTag tags) {
        return Transform.fromTag(tags, null, null, null);
    }

    @Nonnull
    public static Transform fromPosAndOriTag(@Nonnull CompoundTag tags) {
        return Transform.fromTag(tags, null, null, new Vector3f(1.0f, 1.0f, 1.0f));
    }

    @Nonnull
    public static Transform fromTagWithScale(@Nonnull CompoundTag tags, @Nonnull Vector3f scale) {
        return Transform.fromTag(tags, null, null, scale);
    }

    @Nonnull
    public Transform inverse() {
        return this.localToGlobalTransform(IDENTITY);
    }

    public void applyToPoseStack(@Nonnull PoseStack poseStack) {
        poseStack.m_85837_(this.Position.x, this.Position.y, this.Position.z);
        poseStack.m_252781_(this.Orientation);
        poseStack.m_85841_(this.Scale.x, this.Scale.y, this.Scale.z);
    }

    @Nonnull
    public PoseStack toNewPoseStack() {
        PoseStack poseStack = new PoseStack();
        poseStack.m_85837_(this.Position.x, this.Position.y, this.Position.z);
        poseStack.m_252781_(this.Orientation);
        poseStack.m_85841_(this.Scale.x, this.Scale.y, this.Scale.z);
        return poseStack;
    }

    @Nonnull
    public static Quaternionf quatFromEuler(@Nonnull Vector3f euler) {
        return new Quaternionf().rotateY(-euler.y * ((float)Math.PI / 180)).rotateX(-euler.x * ((float)Math.PI / 180)).rotateZ(-euler.z * ((float)Math.PI / 180));
    }

    @Nonnull
    public static Quaternionf quatFromEulerRadians(float pitch, float yaw, float roll) {
        return new Quaternionf().rotateY(-yaw).rotateX(-pitch).rotateZ(-roll);
    }

    @Nonnull
    public static Quaternionf quatFromEuler(float pitch, float yaw, float roll) {
        return new Quaternionf().rotateY(-yaw * ((float)Math.PI / 180)).rotateX(-pitch * ((float)Math.PI / 180)).rotateZ(-roll * ((float)Math.PI / 180));
    }

    @Nonnull
    public Transform reflect(boolean inX, boolean inY, boolean inZ) {
        Vec3 reflectedPos = new Vec3(inX ? -this.Position.x : this.Position.x, inY ? -this.Position.y : this.Position.y, inZ ? -this.Position.z : this.Position.z);
        Vec3 fwd = this.forward();
        Vec3 reflectedFwd = new Vec3(inX ? -fwd.f_82479_ : fwd.f_82479_, inY ? -fwd.f_82480_ : fwd.f_82480_, inZ ? -fwd.f_82481_ : fwd.f_82481_);
        Vec3 up = this.up();
        Vec3 reflectedUp = new Vec3(inX ? -up.f_82479_ : up.f_82479_, inY ? -up.f_82480_ : up.f_82480_, inZ ? -up.f_82481_ : up.f_82481_);
        return Transform.fromPositionAndLookDirection(reflectedPos, reflectedFwd, reflectedUp);
    }

    @Nonnull
    public Transform withEulerAngles(float pitch, float yaw, float roll) {
        return new Transform(this.Position, Transform.quatFromEuler(pitch, yaw, roll), this.Scale);
    }

    @Nonnull
    public Transform withPosition(double x, double y, double z) {
        return new Transform(new Vec3(x, y, z), this.Orientation, this.Scale);
    }

    @Nonnull
    public Transform withPosition(@Nonnull Vec3 pos) {
        return new Transform(pos, this.Orientation, this.Scale);
    }

    @Nonnull
    public Transform translated(@Nonnull Vec3 pos) {
        return new Transform(new Vector3d(this.Position.x + pos.f_82479_, this.Position.y + pos.f_82480_, this.Position.z + pos.f_82481_), this.Orientation, this.Scale);
    }

    @Nonnull
    public Transform withYaw(float yaw) {
        Vector3f euler = this.euler();
        return new Transform(this.Position, Transform.quatFromEuler(euler.x, yaw, euler.z), this.Scale);
    }

    @Nonnull
    public Transform withPitch(float pitch) {
        Vector3f euler = this.euler();
        return new Transform(this.Position, Transform.quatFromEuler(pitch, euler.y, euler.z), this.Scale);
    }

    @Nonnull
    public Transform withRoll(float roll) {
        Vector3f euler = this.euler();
        return new Transform(this.Position, Transform.quatFromEuler(euler.x, euler.y, roll), this.Scale);
    }

    @Nonnull
    public Transform rotateYaw(float dYaw) {
        return new Transform(this.Position, this.Orientation.mul((Quaternionfc)Transform.quatFromEuler(0.0f, dYaw, 0.0f), new Quaternionf()), this.Scale);
    }

    @Nonnull
    public Transform rotatePitch(float dPitch) {
        return new Transform(this.Position, this.Orientation.mul((Quaternionfc)Transform.quatFromEuler(dPitch, 0.0f, 0.0f), new Quaternionf()), this.Scale);
    }

    @Nonnull
    public Transform rotateRoll(float dRoll) {
        return new Transform(this.Position, this.Orientation.mul((Quaternionfc)Transform.quatFromEuler(0.0f, 0.0f, dRoll), new Quaternionf()), this.Scale);
    }

    @Nonnull
    public static Vector3f getScale(@Nonnull Matrix4f mat) {
        Vector3f result = new Vector3f();
        mat.getScale(result);
        return result;
    }

    @Nonnull
    public static Vector3f toEuler(@Nonnull Quaternionf quat) {
        Vector3f euler = quat.getEulerAnglesYXZ(new Vector3f());
        return euler.mul(-57.29578f, -57.29578f, -57.29578f);
    }

    @Nonnull
    public static Quaternionf lookAlong(@Nonnull Vec3 forward, @Nonnull Vec3 up) {
        return new Quaternionf().lookAlong((float)forward.f_82479_, (float)forward.f_82480_, (float)forward.f_82481_, (float)up.f_82479_, (float)up.f_82480_, (float)up.f_82481_).invert();
    }

    @Nonnull
    public static Quaternionf compose(@Nonnull Quaternionf firstA, @Nonnull Quaternionf thenB) {
        return thenB.mul((Quaternionfc)firstA, new Quaternionf());
    }

    @Nonnull
    public static Quaternionf compose(@Nonnull Quaternionf firstA, @Nonnull Quaternionf thenB, @Nonnull Quaternionf thenC) {
        return thenC.mul((Quaternionfc)thenB, new Quaternionf()).mul((Quaternionfc)firstA, new Quaternionf());
    }

    @Nonnull
    public static Vector3f rotate(@Nonnull Vector3f vec, @Nonnull Quaternionf around) {
        return around.transform((Vector3fc)vec, new Vector3f());
    }

    @Nonnull
    public BlockPos blockPos() {
        return new BlockPos(Maths.floor(this.Position.x), Maths.floor(this.Position.y), Maths.floor(this.Position.z));
    }

    @Nonnull
    public Vec3 positionVec3() {
        return new Vec3(this.Position.x, this.Position.y, this.Position.z);
    }

    @Nonnull
    public Vec3 forward() {
        return this.localToGlobalDirection(new Vec3(0.0, 0.0, -1.0));
    }

    @Nonnull
    public Vec3 back() {
        return this.localToGlobalDirection(new Vec3(0.0, 0.0, 1.0));
    }

    @Nonnull
    public Vec3 up() {
        return this.localToGlobalDirection(new Vec3(0.0, 1.0, 0.0));
    }

    @Nonnull
    public Vec3 down() {
        return this.localToGlobalDirection(new Vec3(0.0, -1.0, 0.0));
    }

    @Nonnull
    public Vec3 right() {
        return this.localToGlobalDirection(new Vec3(1.0, 0.0, 0.0));
    }

    @Nonnull
    public Vec3 left() {
        return this.localToGlobalDirection(new Vec3(-1.0, 0.0, 0.0));
    }

    @Nonnull
    public Vec3 directionVec(@Nonnull Direction dir) {
        return this.localToGlobalDirection(new Vec3(dir.m_253071_()));
    }

    public boolean isIdentity() {
        return this.Position.lengthSquared() <= 1.0E-7 && this.Orientation.equals((Quaternionfc)IDENTITY_QUAT, 1.0E-6f) && Maths.approx(this.Scale.x, 1.0f) && Maths.approx(this.Scale.y, 1.0f) && Maths.approx(this.Scale.z, 1.0f);
    }

    @Nonnull
    public Vector3f euler() {
        return Transform.toEuler(this.Orientation);
    }

    public float yaw() {
        return Transform.toEuler((Quaternionf)this.Orientation).y;
    }

    public float pitch() {
        return Transform.toEuler((Quaternionf)this.Orientation).x;
    }

    public float roll() {
        return Transform.toEuler((Quaternionf)this.Orientation).z;
    }

    @Nonnull
    public Matrix3f oriMatrix() {
        FloatBuffer buf = MemoryUtil.memAllocFloat((int)9);
        buf.mark();
        this.Orientation.getAsMatrix3f(buf);
        buf.reset();
        Matrix3f ret = new Matrix3f(buf);
        MemoryUtil.memFree((Buffer)buf);
        return ret;
    }

    public boolean hasNaN() {
        return Double.isNaN(this.Position.x) || Double.isNaN(this.Position.y) || Double.isNaN(this.Position.z) || Double.isNaN(this.Orientation.x) || Double.isNaN(this.Orientation.y) || Double.isNaN(this.Orientation.z) || Double.isNaN(this.Orientation.w) || Double.isNaN(this.Scale.x) || Double.isNaN(this.Scale.y) || Double.isNaN(this.Scale.z);
    }

    public boolean equals(Object other) {
        if (other instanceof Transform) {
            Transform otherT = (Transform)other;
            return otherT.Position.equals((Object)this.Position) && otherT.Orientation.equals((Object)this.Orientation) && otherT.Scale.equals((Object)this.Scale);
        }
        return false;
    }

    public boolean isApprox(@Nonnull Transform other, double posEpsilon, float angleEpsilon, float scaleEpsilon) {
        return this.Position.distanceSquared((Vector3dc)other.Position) < posEpsilon * posEpsilon && this.Orientation.equals((Quaternionfc)other.Orientation, angleEpsilon) && this.Scale.equals((Vector3fc)other.Scale, scaleEpsilon);
    }

    public boolean isApprox(@Nonnull Transform other, double epsilon) {
        return this.Position.distanceSquared((Vector3dc)other.Position) < epsilon * epsilon && this.Orientation.equals((Quaternionfc)other.Orientation, (float)epsilon) && this.Scale.equals((Vector3fc)other.Scale, (float)epsilon);
    }

    @Nonnull
    public Vec3 localToGlobalPosition(@Nonnull Vec3 localPos) {
        Vector3d scratch = new Vector3d(localPos.f_82479_, localPos.f_82480_, localPos.f_82481_);
        this.Orientation.transform(scratch);
        scratch.mul((Vector3fc)this.Scale);
        scratch.add((Vector3dc)this.Position);
        return new Vec3(scratch.x, scratch.y, scratch.z);
    }

    @Nonnull
    public Vec3 globalToLocalPosition(@Nonnull Vec3 globalPos) {
        Vector3d scratch = new Vector3d(globalPos.f_82479_, globalPos.f_82480_, globalPos.f_82481_);
        scratch.sub((Vector3dc)this.Position);
        this.Orientation.transformInverse(scratch);
        scratch.mul((double)(1.0f / this.Scale.x), (double)(1.0f / this.Scale.y), (double)(1.0f / this.Scale.z));
        return new Vec3(scratch.x, scratch.y, scratch.z);
    }

    @Nonnull
    public Vec3 localToGlobalVelocity(@Nonnull Vec3 localVelocity) {
        Vector3d scratch = new Vector3d(localVelocity.f_82479_, localVelocity.f_82480_, localVelocity.f_82481_);
        this.Orientation.transform(scratch);
        scratch.mul((Vector3fc)this.Scale);
        return new Vec3(scratch.x, scratch.y, scratch.z);
    }

    @Nonnull
    public Vec3 globalToLocalVelocity(@Nonnull Vec3 globalVelocity) {
        Vector3d scratch = new Vector3d(globalVelocity.f_82479_, globalVelocity.f_82480_, globalVelocity.f_82481_);
        scratch.mul((double)(1.0f / this.Scale.x), (double)(1.0f / this.Scale.y), (double)(1.0f / this.Scale.z));
        this.Orientation.transformInverse(scratch);
        return new Vec3(scratch.x, scratch.y, scratch.z);
    }

    @Nonnull
    public Vec3 localToGlobalDirection(@Nonnull Vec3 localDirection) {
        Vector3d scratch = new Vector3d(localDirection.f_82479_, localDirection.f_82480_, localDirection.f_82481_);
        this.Orientation.transform(scratch);
        return new Vec3(scratch.x, scratch.y, scratch.z);
    }

    @Nonnull
    public Vec3 globalToLocalDirection(@Nonnull Vec3 globalDirection) {
        Vector3d scratch = new Vector3d(globalDirection.f_82479_, globalDirection.f_82480_, globalDirection.f_82481_);
        this.Orientation.transformInverse(scratch);
        return new Vec3(scratch.x, scratch.y, scratch.z);
    }

    @Nonnull
    public Quaternionf localToGlobalOrientation(@Nonnull Quaternionf localOri) {
        boolean flipZ;
        boolean flipX = this.Scale.x < 0.0f;
        boolean flipY = this.Scale.y < 0.0f;
        boolean bl = flipZ = this.Scale.z < 0.0f;
        if (flipX || flipY || flipZ) {
            return this.reflect((boolean)flipX, (boolean)flipY, (boolean)flipZ).Orientation.mul((Quaternionfc)localOri, new Quaternionf());
        }
        return this.Orientation.mul((Quaternionfc)localOri, new Quaternionf()).normalize();
    }

    @Nonnull
    public Quaternionf globalToLocalOrientation(@Nonnull Quaternionf globalOri) {
        boolean flipZ;
        boolean flipX = this.Scale.x < 0.0f;
        boolean flipY = this.Scale.y < 0.0f;
        boolean bl = flipZ = this.Scale.z < 0.0f;
        if (flipX || flipY || flipZ) {
            return this.reflect((boolean)flipX, (boolean)flipY, (boolean)flipZ).Orientation.invert(new Quaternionf()).mul((Quaternionfc)globalOri, new Quaternionf()).normalize();
        }
        return this.Orientation.invert(new Quaternionf()).mul((Quaternionfc)globalOri, new Quaternionf());
    }

    @Nonnull
    public Vector3f localToGlobalScale(@Nonnull Vector3f localScale) {
        return localScale.mul((Vector3fc)this.Scale, new Vector3f());
    }

    @Nonnull
    public Vector3f globalToLocalScale(@Nonnull Vector3f globalScale) {
        return globalScale.div((Vector3fc)this.Scale, new Vector3f());
    }

    @Nonnull
    public Transform localToGlobalTransform(@Nonnull Transform localTransform) {
        return new Transform(this.localToGlobalPosition(localTransform.positionVec3()), this.localToGlobalOrientation(localTransform.Orientation), this.localToGlobalScale(localTransform.Scale));
    }

    @Nonnull
    public Transform globalToLocalTransform(@Nonnull Transform globalTransform) {
        return new Transform(this.globalToLocalPosition(globalTransform.positionVec3()), this.globalToLocalOrientation(globalTransform.Orientation), this.globalToLocalScale(globalTransform.Scale));
    }

    @Nonnull
    public AABB localToGlobalBounds(@Nonnull AABB localBounds) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    Vec3 rotated = this.localToGlobalPosition(new Vec3(localBounds.f_82288_ + localBounds.m_82362_() * (double)x, localBounds.f_82289_ + localBounds.m_82376_() * (double)y, localBounds.f_82290_ + localBounds.m_82385_() * (double)z));
                    minX = Maths.min(minX, rotated.f_82479_);
                    minY = Maths.min(minY, rotated.f_82480_);
                    minZ = Maths.min(minZ, rotated.f_82481_);
                    maxX = Maths.max(maxX, rotated.f_82479_);
                    maxY = Maths.max(maxY, rotated.f_82480_);
                    maxZ = Maths.max(maxZ, rotated.f_82481_);
                }
            }
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Nonnull
    public static Transform interpolate(@Nonnull Transform a, @Nonnull Transform b, float t) {
        return new Transform(a.Position.lerp((Vector3dc)b.Position, (double)t, new Vector3d()), a.Orientation.slerp((Quaternionfc)b.Orientation, t, new Quaternionf()), a.Scale.lerp((Vector3fc)b.Scale, t, new Vector3f()));
    }

    @Nonnull
    public static Transform interpolate(@Nonnull List<Transform> transforms) {
        if (transforms.size() <= 0) {
            return IDENTITY;
        }
        if (transforms.size() == 1) {
            return transforms.get(0);
        }
        Vector3d position = new Vector3d();
        Quaternionf[] orientations = new Quaternionf[transforms.size()];
        float[] weights = new float[transforms.size()];
        for (int i = 0; i < transforms.size(); ++i) {
            position.add((Vector3dc)transforms.get((int)i).Position);
            orientations[i] = transforms.get((int)i).Orientation;
            weights[i] = 1.0f / (float)transforms.size();
        }
        return Transform.fromPosAndQuat(position.mul(1.0 / (double)transforms.size()), (Quaternionf)Quaternionf.slerp((Quaternionf[])orientations, (float[])weights, (Quaternionf)new Quaternionf()));
    }

    @Nonnull
    public static Transform interpolate(@Nonnull List<Transform> transforms, @Nonnull float[] weights) {
        if (transforms.size() <= 0) {
            return IDENTITY;
        }
        if (transforms.size() == 1) {
            return transforms.get(0);
        }
        Vector3d position = new Vector3d();
        Quaternionf[] orientations = new Quaternionf[transforms.size()];
        float totalWeight = 0.0f;
        for (int i = 0; i < transforms.size(); ++i) {
            position.add((Vector3dc)transforms.get((int)i).Position.mul((double)weights[i], new Vector3d()));
            orientations[i] = transforms.get((int)i).Orientation;
            totalWeight += weights[i];
        }
        return Transform.fromPosAndQuat(position.mul(1.0 / (double)totalWeight), (Quaternionf)Quaternionf.slerp((Quaternionf[])orientations, (float[])weights, (Quaternionf)new Quaternionf()));
    }

    public String toString() {
        boolean isOneScale;
        boolean isZeroPos = Maths.approx(this.Position.lengthSquared(), 0.0);
        boolean isIdentityRot = Maths.approx(this.Orientation.x, 0.0f) && Maths.approx(this.Orientation.y, 0.0f) && Maths.approx(this.Orientation.z, 0.0f) && Maths.approx(this.Orientation.w, 1.0f);
        boolean bl = isOneScale = Maths.approx(this.Scale.x, 1.0f) && Maths.approx(this.Scale.y, 1.0f) && Maths.approx(this.Scale.z, 1.0f);
        if (isZeroPos && isIdentityRot && isOneScale) {
            return "IDENTITY";
        }
        StringBuilder output = new StringBuilder("{");
        if (!isZeroPos) {
            output.append("\"Pos\":[").append(Runtime.format((double)this.Position.x, (NumberFormat)FLOAT_FORMAT)).append(", ").append(Runtime.format((double)this.Position.y, (NumberFormat)FLOAT_FORMAT)).append(", ").append(Runtime.format((double)this.Position.z, (NumberFormat)FLOAT_FORMAT)).append("]");
        }
        if (!isIdentityRot) {
            if (!isZeroPos) {
                output.append(',');
            }
            Vector3f euler = Transform.toEuler(this.Orientation);
            output.append("\"Rot\":[").append(Runtime.format((double)euler.x, (NumberFormat)ANGLE_FORMAT)).append(", ").append(Runtime.format((double)euler.y, (NumberFormat)ANGLE_FORMAT)).append(", ").append(Runtime.format((double)euler.z, (NumberFormat)ANGLE_FORMAT)).append("]");
        }
        if (!isOneScale) {
            if (!isZeroPos || !isIdentityRot) {
                output.append(',');
            }
            if (Maths.approx(this.Scale.x, this.Scale.y) && Maths.approx(this.Scale.y, this.Scale.z)) {
                output.append("\"Scl\":").append(Runtime.format((double)this.Scale.x, (NumberFormat)FLOAT_FORMAT));
            } else {
                output.append("\"Scl\":[").append(Runtime.format((double)this.Scale.x, (NumberFormat)FLOAT_FORMAT)).append(", ").append(Runtime.format((double)this.Scale.y, (NumberFormat)FLOAT_FORMAT)).append(", ").append(Runtime.format((double)this.Scale.z, (NumberFormat)FLOAT_FORMAT)).append("]");
            }
        }
        return output.toString();
    }
}

