/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.util;

import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.util.EContextSide;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MinecraftHelpers {
    @Nullable
    public static Level getLevel(@Nonnull ResourceKey<Level> dimension) {
        MinecraftServer server;
        if (MinecraftHelpers.isClientThread()) {
            if (MinecraftHelpers.isClientDist()) {
                Level clientLevel = (Level)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> MinecraftHelpers::clientGetCurrentLevel);
                if (clientLevel.m_46472_().equals(dimension)) {
                    return clientLevel;
                }
                FlansPhysicsMod.LOGGER.warn("Tried to access non-loaded client dimension: {}", dimension);
                return null;
            }
            FlansPhysicsMod.LOGGER.error("How are we on a client thread outside of a client dist???");
            return null;
        }
        if (!MinecraftHelpers.isServerThread()) {
            FlansPhysicsMod.LOGGER.error("What thread are you trying to get the level on?");
        }
        if ((server = MinecraftHelpers.getServer()) != null && server.m_130010_()) {
            return server.m_129880_(dimension);
        }
        return null;
    }

    @Nonnull
    public static Iterable<? extends Level> serverGetLoadedLevels() {
        MinecraftServer server = MinecraftHelpers.getServer();
        if (server != null && server.m_130010_()) {
            return server.m_129785_();
        }
        return new ArrayList();
    }

    public static boolean tagEqual(@Nonnull Tag tag, @Nonnull String stringValue) {
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            return intTag.m_7047_() == Integer.parseInt(stringValue);
        }
        if (tag instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tag;
            return floatTag.m_7057_() == Float.parseFloat(stringValue);
        }
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            return stringTag.m_7916_().equals(stringValue);
        }
        if (tag instanceof DoubleTag) {
            DoubleTag doubleTag = (DoubleTag)tag;
            return doubleTag.m_7061_() == Double.parseDouble(stringValue);
        }
        FlansPhysicsMod.LOGGER.warn("Unknown tag type in ingredient");
        return true;
    }

    public static long getTick() {
        if (MinecraftHelpers.isClientDist()) {
            Level level = MinecraftHelpers.clientGetCurrentLevel();
            if (level != null) {
                return level.m_46467_();
            }
        } else {
            ServerLevel level;
            MinecraftServer server = MinecraftHelpers.getServer();
            if (server != null && server.m_130010_() && (level = server.m_129880_(Level.f_46428_)) != null) {
                return level.m_46467_();
            }
        }
        return 0L;
    }

    @Nonnull
    public static String getFEString(int fe) {
        if (fe >= 1000000000) {
            return String.format("%.2f GFE", Float.valueOf((float)fe / 1.0E9f));
        }
        if (fe >= 1000000) {
            return String.format("%.2f MFE", Float.valueOf((float)fe / 1000000.0f));
        }
        if (fe >= 1000) {
            return String.format("%.2f KFE", Float.valueOf((float)fe / 1000.0f));
        }
        return fe + " FE";
    }

    public static boolean isClientDist() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    public static boolean isClientThread() {
        return MinecraftHelpers.getLogicalSide() == EContextSide.Client;
    }

    public static boolean isServerThread() {
        return MinecraftHelpers.getLogicalSide() == EContextSide.Server;
    }

    @Nonnull
    public static EContextSide getLogicalSide(@Nonnull Entity entity) {
        return MinecraftHelpers.getLogicalSide(entity.m_9236_());
    }

    @Nonnull
    public static EContextSide getLogicalSide(@Nonnull Level level) {
        return level.f_46443_ ? EContextSide.Client : EContextSide.Server;
    }

    @Nonnull
    public static EContextSide getLogicalSide() {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer != null && Thread.currentThread() == currentServer.m_6304_()) {
            return EContextSide.Server;
        }
        if (MinecraftHelpers.isClientDist()) {
            return EContextSide.Client;
        }
        return EContextSide.Unknown;
    }

    @Nullable
    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public static HumanoidArm getArm(@Nonnull InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? (HumanoidArm)Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() : ((HumanoidArm)Minecraft.m_91087_().f_91066_.m_232107_().m_231551_()).m_20828_();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public static HumanoidArm getArm(@Nonnull ItemDisplayContext hand) {
        return switch (hand) {
            case ItemDisplayContext.FIRST_PERSON_LEFT_HAND, ItemDisplayContext.THIRD_PERSON_LEFT_HAND -> HumanoidArm.LEFT;
            default -> HumanoidArm.RIGHT;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public static InteractionHand getHand(@Nullable ItemDisplayContext transformType) {
        boolean rightHanded;
        boolean bl = rightHanded = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT;
        if (transformType == null) {
            return InteractionHand.MAIN_HAND;
        }
        return switch (transformType) {
            case ItemDisplayContext.FIRST_PERSON_LEFT_HAND -> {
                if (rightHanded) {
                    yield InteractionHand.OFF_HAND;
                }
                yield InteractionHand.MAIN_HAND;
            }
            case ItemDisplayContext.FIRST_PERSON_RIGHT_HAND -> {
                if (rightHanded) {
                    yield InteractionHand.MAIN_HAND;
                }
                yield InteractionHand.OFF_HAND;
            }
            case ItemDisplayContext.THIRD_PERSON_LEFT_HAND -> InteractionHand.OFF_HAND;
            default -> InteractionHand.MAIN_HAND;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public static ItemDisplayContext getFirstPersonTransformType(@Nonnull InteractionHand hand) {
        boolean rightHanded = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT;
        return switch (hand) {
            default -> throw new IncompatibleClassChangeError();
            case InteractionHand.MAIN_HAND -> {
                if (rightHanded) {
                    yield ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
                }
                yield ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
            }
            case InteractionHand.OFF_HAND -> rightHanded ? ItemDisplayContext.FIRST_PERSON_LEFT_HAND : ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public static ItemDisplayContext getThirdPersonTransformType(boolean isLocalPlayer, @Nonnull InteractionHand hand) {
        boolean rightHanded = !isLocalPlayer || Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT;
        return switch (hand) {
            default -> throw new IncompatibleClassChangeError();
            case InteractionHand.MAIN_HAND -> {
                if (rightHanded) {
                    yield ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                }
                yield ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
            }
            case InteractionHand.OFF_HAND -> rightHanded ? ItemDisplayContext.THIRD_PERSON_LEFT_HAND : ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Entity getCamera() {
        return Minecraft.m_91087_().f_91075_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Minecraft getClient() {
        return Minecraft.m_91087_();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static Level clientGetCurrentLevel() {
        return MinecraftHelpers.getClient().f_91073_;
    }

    @Nullable
    public static ResourceLocation createLocation(@Nonnull String locString) {
        return ResourceLocation.m_135820_((String)locString);
    }

    @Nonnull
    public static TagKey<Block> findBlockTag(@Nonnull String location) {
        ResourceLocation resLoc = new ResourceLocation(location);
        return TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)resLoc);
    }
}

