/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.util;

import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public interface ITransformPair {
    public static final ITransformPair Identity = new ITransformPair(){

        @Override
        @Nonnull
        public Transform previous() {
            return Transform.identity();
        }

        @Override
        @Nonnull
        public Transform current() {
            return Transform.identity();
        }
    };

    @Nonnull
    public Transform previous();

    @Nonnull
    public Transform current();

    @Nonnull
    default public Transform delta(float dt) {
        if (Maths.approx(dt, 0.0f)) {
            return this.previous();
        }
        if (Maths.approx(dt, 1.0f)) {
            return this.current();
        }
        return Transform.interpolate(this.previous(), this.current(), dt);
    }

    @Nonnull
    public static ITransformPair of(final @Nonnull Supplier<Transform> prev, final @Nonnull Supplier<Transform> current) {
        return new ITransformPair(){

            @Override
            @Nonnull
            public Transform previous() {
                return (Transform)prev.get();
            }

            @Override
            @Nonnull
            public Transform current() {
                return (Transform)current.get();
            }
        };
    }

    @Nonnull
    public static ITransformPair compose(final @Nonnull ITransformPair a, final @Nonnull ITransformPair b) {
        return new ITransformPair(){

            @Override
            @Nonnull
            public Transform previous() {
                return Transform.compose(a.previous(), b.previous());
            }

            @Override
            @Nonnull
            public Transform current() {
                return Transform.compose(a.current(), b.current());
            }
        };
    }
}

