/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.units;

import com.flansmod.physics.common.units.AngularAcceleration;
import com.flansmod.physics.common.units.AngularVelocity;
import com.flansmod.physics.common.units.IAcceleration;
import com.flansmod.physics.common.units.LinearAcceleration;
import com.flansmod.physics.common.units.LinearForce;
import com.flansmod.physics.common.units.LinearVelocity;
import com.flansmod.physics.common.units.Units;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;

public record OffsetAcceleration(@Nonnull Vec3 Acceleration, @Nonnull Vec3 Origin) implements IAcceleration
{
    public static final OffsetAcceleration Zero = new OffsetAcceleration(Vec3.f_82478_, Vec3.f_82478_);

    @Nonnull
    public static OffsetAcceleration blocksPerSecondSq(@Nonnull Vec3 blocksPerSecSq, @Nonnull Vec3 offset) {
        return new OffsetAcceleration(Units.Acceleration.BlocksPerSecondSq_To_BlocksPerTickSq(blocksPerSecSq), offset);
    }

    @Nonnull
    public static OffsetAcceleration blocksPerTickSq(@Nonnull Vec3 blocksPerTickSq, @Nonnull Vec3 offset) {
        return new OffsetAcceleration(blocksPerTickSq, offset);
    }

    @Nonnull
    public static OffsetAcceleration offset(@Nonnull LinearAcceleration acceleration, @Nonnull Vec3 offset) {
        return new OffsetAcceleration(acceleration.Acceleration(), offset);
    }

    @Nonnull
    public Vec3 getTicksPerSecondSq() {
        return this.Acceleration;
    }

    @Nonnull
    public Vec3 getBlocksPerSecondSq() {
        return this.getInUnits(Units.Acceleration.BlocksPerSecondSquared);
    }

    @Nonnull
    public Pair<LinearVelocity, AngularVelocity> applyOneTick() {
        return this.applyOneTick(Transform.IDENTITY);
    }

    @Nonnull
    public Pair<LinearVelocity, AngularVelocity> applyOneTick(@Nonnull Transform actingOn) {
        return Pair.of((Object)this.getLinearComponent(actingOn).applyOneTick(), (Object)this.getAngularComponent(actingOn).applyOneTick());
    }

    @Nonnull
    public LinearForce multiplyBy(double mass) {
        return new LinearForce(this.Acceleration.m_82490_(mass));
    }

    @Nonnull
    public Units.Acceleration getDefaultUnits() {
        return Units.Acceleration.BlocksPerTickSquared;
    }

    @Nonnull
    public Vec3 getInUnits(@Nonnull Units.Acceleration toUnit) {
        return Units.Acceleration.Convert(this.Acceleration, Units.Acceleration.BlocksPerTickSquared, toUnit);
    }

    @Override
    @Nonnull
    public OffsetAcceleration inverse() {
        return new OffsetAcceleration(this.Acceleration.m_82490_(-1.0), this.Origin);
    }

    @Override
    public boolean isApproxZero() {
        return this.Acceleration.m_82556_() < 9.999999999999998E-15;
    }

    @Override
    public boolean hasLinearComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public LinearAcceleration getLinearComponent(@Nonnull Transform actingOn) {
        return new LinearAcceleration(this.Acceleration);
    }

    @Override
    public boolean hasAngularComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public AngularAcceleration getAngularComponent(@Nonnull Transform actingOn) {
        Vec3 relativeOffset = this.Origin.m_82546_(actingOn.positionVec3());
        double radius = relativeOffset.m_82553_();
        if (Maths.approx(radius, 0.0)) {
            return AngularAcceleration.Zero;
        }
        Vec3 axis = relativeOffset.m_82537_(this.Acceleration).m_82541_();
        double magnitude = this.Acceleration.m_82553_() / radius;
        return new AngularAcceleration(axis, magnitude);
    }

    @Override
    public String toString() {
        return "OffsetAcceleration [" + this.Acceleration + "] at [" + this.Origin + "]";
    }

    @Override
    @Nonnull
    public Component toFancyString() {
        return Component.m_237110_((String)"flansphysics.offset_acceleration", (Object[])new Object[]{this.Acceleration.f_82479_, this.Acceleration.f_82480_, this.Acceleration.f_82481_, this.Origin.f_82479_, this.Origin.f_82480_, this.Origin.f_82481_});
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof OffsetAcceleration) {
            OffsetAcceleration otherOffsetA = (OffsetAcceleration)other;
            return otherOffsetA.Acceleration.equals((Object)this.Acceleration) && otherOffsetA.Origin.equals((Object)this.Origin);
        }
        return false;
    }

    public boolean isApprox(@Nonnull OffsetAcceleration other) {
        return Maths.approx(other.Acceleration, this.Acceleration) && Maths.approx(other.Origin, this.Origin);
    }

    public boolean isApprox(@Nonnull OffsetAcceleration other, double epsilon) {
        return Maths.approx(other.Acceleration, this.Acceleration, epsilon) && Maths.approx(other.Origin, this.Origin, epsilon);
    }
}

