/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.units;

import com.flansmod.physics.common.units.AngularVelocity;
import com.flansmod.physics.common.units.CompoundVelocity;
import com.flansmod.physics.common.units.IForce;
import com.flansmod.physics.common.units.LinearForce;
import com.flansmod.physics.common.units.LinearVelocity;
import com.flansmod.physics.common.units.Torque;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;

public record Impulse(@Nonnull Vec3 momentumDelta) implements IForce
{
    @Nonnull
    public LinearVelocity applyTo(double inverseMass) {
        return new LinearVelocity(this.momentumDelta.m_82490_(inverseMass));
    }

    @Nonnull
    public LinearVelocity applyTo(@Nonnull LinearVelocity v, double inverseMass) {
        return new LinearVelocity(v.Velocity().m_82549_(this.momentumDelta.m_82490_(inverseMass)));
    }

    @Nonnull
    public AngularVelocity applyAtOffset(@Nonnull Vec3 offset, @Nonnull Vec3 inertiaTensor) {
        Vec3 angleAxis = this.momentumDelta.m_82537_(offset);
        if (Maths.approx(angleAxis = angleAxis.m_82559_(inertiaTensor), Vec3.f_82478_)) {
            return AngularVelocity.Zero;
        }
        return AngularVelocity.radiansPerTick(angleAxis);
    }

    @Nonnull
    public AngularVelocity applyTo(@Nonnull Vec3 center, @Nonnull Vec3 inertiaTensor, @Nonnull Vec3 applyAtPoint) {
        return this.applyAtOffset(center.m_82546_(applyAtPoint), inertiaTensor);
    }

    @Nonnull
    public AngularVelocity applyAtOffset(@Nonnull AngularVelocity v, @Nonnull Vec3 offset, @Nonnull Vec3 inertiaTensor) {
        Vec3 angleAxis = this.momentumDelta.m_82537_(offset);
        if (Maths.approx(angleAxis = angleAxis.m_82559_(inertiaTensor), Vec3.f_82478_)) {
            return v;
        }
        AngularVelocity deltaAngularV = AngularVelocity.radiansPerTick(angleAxis);
        return v.compose(deltaAngularV);
    }

    @Nonnull
    public AngularVelocity applyTo(@Nonnull AngularVelocity v, @Nonnull Vec3 center, @Nonnull Vec3 inertiaTensor, @Nonnull Vec3 applyAtPoint) {
        return this.applyAtOffset(v, center.m_82546_(applyAtPoint), inertiaTensor);
    }

    @Nonnull
    public static Vec3 vectorTripleProduct(@Nonnull Vec3 a, @Nonnull Vec3 b, @Nonnull Vec3 c) {
        return a.m_82490_(-c.m_82526_(b)).m_82549_(b.m_82490_(c.m_82526_(a)));
    }

    @Nonnull
    public static Impulse calculateAtOffsets(@Nonnull CompoundVelocity vA, double inverseMassA, @Nonnull Vec3 inertiaTensorA, @Nonnull Vec3 collisionRelA, @Nonnull CompoundVelocity vB, double inverseMassB, @Nonnull Vec3 inertiaTensorB, @Nonnull Vec3 collisionRelB, @Nonnull Vec3 normal, double coefficientOfRestitution) {
        LinearVelocity linearVAtA = vA.linearAtPoint(collisionRelA);
        LinearVelocity linearVAtB = vB.linearAtPoint(collisionRelB);
        LinearVelocity deltaV = linearVAtB.subtract(linearVAtA);
        double collisionSpeedLinear = -(1.0 + coefficientOfRestitution) * deltaV.Velocity().m_82526_(normal);
        Vec3 tangentA = Impulse.vectorTripleProduct(collisionRelA, normal, collisionRelA);
        Vec3 thetaA = inertiaTensorA.m_82559_(tangentA);
        Vec3 tangentB = Impulse.vectorTripleProduct(collisionRelB, normal, collisionRelB);
        Vec3 thetaB = inertiaTensorB.m_82559_(tangentB);
        double impulseMagnitude = collisionSpeedLinear / (inverseMassA + inverseMassB + thetaA.m_82549_(thetaB).m_82526_(normal));
        return new Impulse(normal.m_82490_(impulseMagnitude));
    }

    @Nonnull
    public static Impulse calculateAtOffset(@Nonnull CompoundVelocity vA, double inverseMassA, @Nonnull Vec3 inertiaTensorA, @Nonnull Vec3 collisionRelA, @Nonnull Vec3 normal, double coefficientOfRestitution) {
        LinearVelocity linearVAtA;
        LinearVelocity deltaV = linearVAtA = vA.linearAtPoint(collisionRelA);
        double collisionSpeedLinear = -(1.0 + coefficientOfRestitution) * deltaV.Velocity().m_82526_(normal);
        Vec3 tangentA = Impulse.vectorTripleProduct(collisionRelA, normal, collisionRelA);
        Vec3 thetaA = inertiaTensorA.m_82559_(tangentA);
        double impulseMagnitude = collisionSpeedLinear / (inverseMassA + thetaA.m_82526_(normal));
        impulseMagnitude = Maths.max(impulseMagnitude, 0.0);
        return new Impulse(normal.m_82490_(impulseMagnitude));
    }

    @Nonnull
    public static Impulse calculateLinear(@Nonnull LinearVelocity vA, double inverseMassA, @Nonnull LinearVelocity vB, double inverseMassB, @Nonnull Vec3 normal, double coefficientOfRestitution) {
        LinearVelocity deltaV = vB.subtract(vA);
        double collisionSpeed = -(1.0 + coefficientOfRestitution) * deltaV.Velocity().m_82526_(normal);
        return new Impulse(normal.m_82490_(collisionSpeed / (inverseMassA + inverseMassB)));
    }

    @Nonnull
    public static Impulse calculateAtPoint(@Nonnull CompoundVelocity vA, @Nonnull Vec3 centerA, double invMassA, @Nonnull Vec3 inertiaTensorA, @Nonnull CompoundVelocity vB, @Nonnull Vec3 centerB, double invMassB, @Nonnull Vec3 inertiaTensorB, @Nonnull Vec3 collisionPoint, @Nonnull Vec3 collisionNormal, double coefficientOfRestitution) {
        return Impulse.calculateAtOffsets(vA, invMassA, inertiaTensorA, collisionPoint.m_82546_(centerA), vB, invMassB, inertiaTensorB, collisionPoint.m_82546_(centerB), collisionNormal, coefficientOfRestitution);
    }

    @Nonnull
    public static Impulse calculateAtPoint(@Nonnull CompoundVelocity vA, @Nonnull Vec3 centerA, double invMassA, @Nonnull Vec3 inertiaTensorA, @Nonnull Vec3 collisionPoint, @Nonnull Vec3 collisionNormal, double coefficientOfRestitution) {
        return Impulse.calculateAtOffset(vA, invMassA, inertiaTensorA, collisionPoint.m_82546_(centerA), collisionNormal, coefficientOfRestitution);
    }

    @Nonnull
    public static Impulse linearImpulse(@Nonnull LinearVelocity from, @Nonnull LinearVelocity to, double mass) {
        return new Impulse(from.subtract(to).scale(mass).applyOneTick());
    }

    @Nonnull
    public Impulse project(@Nonnull Vec3 ontoAxis) {
        return new Impulse(ontoAxis.m_82490_(ontoAxis.m_82526_(this.momentumDelta)));
    }

    @Override
    public boolean isApproxZero() {
        return Maths.approx(this.momentumDelta, Vec3.f_82478_);
    }

    @Override
    @Nonnull
    public Impulse inverse() {
        return new Impulse(this.momentumDelta.m_82490_(-1.0));
    }

    @Override
    public boolean hasLinearComponent(@Nonnull Transform actingOn) {
        return false;
    }

    @Override
    @Nonnull
    public LinearForce getLinearComponent(@Nonnull Transform actingOn) {
        return LinearForce.Zero;
    }

    @Override
    public boolean hasAngularComponent(@Nonnull Transform actingOn) {
        return false;
    }

    @Override
    @Nonnull
    public Torque getTorqueComponent(@Nonnull Transform actingOn) {
        return Torque.Zero;
    }

    @Override
    public String toString() {
        return "Impulse [" + this.momentumDelta + "] kgm/tick";
    }

    @Override
    @Nonnull
    public Component toFancyString() {
        return Component.m_237110_((String)"flansphysics.impulse", (Object[])new Object[]{this.momentumDelta.f_82479_, this.momentumDelta.f_82480_, this.momentumDelta.f_82481_});
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Impulse) {
            Impulse otherImpulse = (Impulse)other;
            return otherImpulse.momentumDelta.equals((Object)this.momentumDelta);
        }
        return false;
    }
}

