/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.entity;

import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.collision.ColliderHandle;
import com.flansmod.physics.common.collision.DynamicCollisionEvent;
import com.flansmod.physics.common.collision.ICollisionSystem;
import com.flansmod.physics.common.collision.IDynamicObjectUpdateReceiver;
import com.flansmod.physics.common.collision.StaticCollisionEvent;
import com.flansmod.physics.common.deprecated.ForcesOnPart;
import com.flansmod.physics.common.units.AngularAcceleration;
import com.flansmod.physics.common.units.AngularVelocity;
import com.flansmod.physics.common.units.IAcceleration;
import com.flansmod.physics.common.units.LinearAcceleration;
import com.flansmod.physics.common.units.LinearForce;
import com.flansmod.physics.common.units.LinearVelocity;
import com.flansmod.physics.common.units.Torque;
import com.flansmod.physics.common.util.DeltaRingBuffer;
import com.flansmod.physics.common.util.ITransformPair;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.network.PhysicsSyncMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.function.TriFunction;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class PhysicsComponent {
    public static final PhysicsComponent invalid = new PhysicsComponent();
    public static final double DEFAULT_MASS = 1.0;
    public static final Vec3 DEFAULT_MOMENT = new Vec3(1.0, 1.0, 1.0);
    public static final int MAX_HISTORY_FRAMES = 20;
    public static final double LINEAR_VELOCITY_SYNC_THRESHOLD = 0.02;
    public static final double ANGULAR_VELOCITY_SYNC_THRESHOLD = 1.0;
    public static final double POSITION_SYNC_THRESHOLD = 0.1;
    public static final float ORIENTATION_SYNC_THRESHOLD = 0.1f;
    public static final float SCALE_SYNC_THRESHOLD = 0.01f;
    public double mass = 1.0;
    public Vec3 momentOfInertia = DEFAULT_MOMENT;
    private boolean scheduledUpdate = false;
    private ColliderHandle physicsHandle;
    private final DeltaRingBuffer<Frame> frameHistory;
    private Frame lastSyncFrame = null;
    private Frame localFrameAtLastReceive = null;
    private ForcesOnPart pendingForces;
    public static long REMOTE_LERP_CONVERGE_TICKS = 3L;

    @Nonnull
    public ColliderHandle getPhysicsHandle() {
        return this.physicsHandle;
    }

    @Nonnull
    public ForcesOnPart getPendingForces() {
        return this.pendingForces;
    }

    @Nonnull
    public List<IAcceleration> getCurrentForces() {
        return this.getMostRecentFrame().accelerations;
    }

    @Nonnull
    public List<IAcceleration> getCurrentReactionForces() {
        return this.getMostRecentFrame().reactions;
    }

    @Nonnull
    public Transform getCurrentTransform() {
        return this.getMostRecentFrame().location;
    }

    @Nonnull
    public LinearVelocity getCurrentLinearVelocity() {
        return this.getMostRecentFrame().linearVelocity;
    }

    @Nonnull
    public AngularVelocity getCurrentAngularVelocity() {
        return this.getMostRecentFrame().angularVelocity;
    }

    @Nonnull
    public List<IAcceleration> getPreviousForces() {
        return this.getPreviousRecentFrame().accelerations;
    }

    @Nonnull
    public List<IAcceleration> getPreviousReactionForce() {
        return this.getPreviousRecentFrame().reactions;
    }

    @Nonnull
    public Transform getPreviousTransform() {
        return this.getPreviousRecentFrame().location;
    }

    @Nonnull
    public LinearVelocity getPreviousLinearVelocity() {
        return this.getPreviousRecentFrame().linearVelocity;
    }

    @Nonnull
    public AngularVelocity getPreviousAngularVelocity() {
        return this.getPreviousRecentFrame().angularVelocity;
    }

    @Nonnull
    public ITransformPair pair() {
        return ITransformPair.of(this::getPreviousTransform, this::getCurrentTransform);
    }

    public PhysicsComponent() {
        this.physicsHandle = ColliderHandle.invalid;
        this.frameHistory = new DeltaRingBuffer<Frame>(20, new Frame());
        this.pendingForces = new ForcesOnPart();
    }

    public PhysicsComponent(@Nonnull Transform initialTransform, long gameTick, @Nonnull ColliderHandle handle) {
        this.physicsHandle = handle;
        this.frameHistory = new DeltaRingBuffer<Frame>(20, new Frame(gameTick, initialTransform));
        this.pendingForces = new ForcesOnPart();
    }

    public void unregister(@Nonnull ICollisionSystem system) {
        if (this.physicsHandle.IsValid()) {
            system.unregisterDynamic(this.getPhysicsHandle());
            this.physicsHandle = ColliderHandle.invalid;
        }
    }

    public void syncCollisionToComponent(@Nonnull ICollisionSystem system) {
        Frame pendingFrame = new Frame();
        pendingFrame.gameTick = system.getGameTick();
        this.generatePendingFrameFromCollision(system, pendingFrame);
        boolean changed = this.frameHistory.addIfChanged(pendingFrame);
        if (changed) {
            this.scheduledUpdate = this.checkIfUpdateNeeded(pendingFrame);
        }
    }

    private void generatePendingFrameFromCollision(@Nonnull ICollisionSystem system, @Nonnull Frame target) {
        LinearForce impactForce = this.pendingForces.sumLinearForces(this.getCurrentTransform(), false);
        this.pendingForces.endFrame();
        if (this.physicsHandle.IsValid()) {
            system.copyDynamicState(this.physicsHandle, target);
        }
    }

    public void syncComponentToCollision(@Nonnull ICollisionSystem physics) {
        if (this.physicsHandle.IsValid()) {
            LinearForce linear = this.pendingForces.sumLinearForces(this.getCurrentTransform(), true);
            Torque angular = this.pendingForces.sumTorque(this.getCurrentTransform(), true);
            physics.applyForce(this.physicsHandle, linear);
            physics.applyTorque(this.physicsHandle, angular);
        }
    }

    @Nonnull
    private Optional<Frame> getExactFrame(long gameTick) {
        return this.getFrame(gameTick, false, false);
    }

    @Nonnull
    private Optional<Frame> getInterpolatedFrame(long gameTick) {
        return this.getFrame(gameTick, true, false);
    }

    @Nonnull
    private Optional<Frame> getExtrapolatedFrame(long gameTick) {
        return this.getFrame(gameTick, false, true);
    }

    @Nonnull
    private Optional<Frame> getFrame(long gameTick, boolean allowInterpolation, boolean allowExtrapolation) {
        return new FrameBuilder(gameTick).test(this.frameHistory).build(allowInterpolation, allowExtrapolation);
    }

    @Nonnull
    private Frame getMostRecentFrame() {
        return this.frameHistory.getMostRecent();
    }

    @Nonnull
    private Frame getPreviousRecentFrame() {
        return this.getInterpolatedFrame(this.frameHistory.getMostRecent().gameTick - 1L).orElse(this.getMostRecentFrame());
    }

    @Nonnull
    public Transform getLocation(long gameTick) {
        return this.interpolate(gameTick, frame -> frame.location, Transform::interpolate, Transform.IDENTITY);
    }

    @Nonnull
    public LinearVelocity getLinearVelocity(long gameTick) {
        return this.interpolate(gameTick, frame -> frame.linearVelocity, LinearVelocity::interpolate, LinearVelocity.Zero);
    }

    @Nonnull
    public AngularVelocity getAngularVelocity(long gameTick) {
        return this.interpolate(gameTick, frame -> frame.angularVelocity, AngularVelocity::interpolate, AngularVelocity.Zero);
    }

    private <T> T interpolate(long gameTick, @Nonnull Function<Frame, T> getFunc, @Nonnull TriFunction<T, T, Float, T> interpFunc, @Nullable T defaultValue) {
        Frame before = null;
        Frame after = null;
        for (Frame frame : this.frameHistory) {
            long delta = gameTick - frame.gameTick;
            if (delta == 0L) {
                return getFunc.apply(frame);
            }
            if (delta < 0L) {
                if (before != null && frame.gameTick <= before.gameTick) continue;
                before = frame;
                continue;
            }
            if (after != null && frame.gameTick >= after.gameTick) continue;
            after = frame;
        }
        if (before != null && after != null) {
            float blend = (float)(gameTick - before.gameTick) / (float)(after.gameTick - before.gameTick);
            return (T)interpFunc.apply(getFunc.apply(before), getFunc.apply(after), (Object)Float.valueOf(blend));
        }
        if (before != null) {
            return getFunc.apply(before);
        }
        if (after != null) {
            return getFunc.apply(after);
        }
        FlansPhysicsMod.LOGGER.warn("Could not get location of physics component");
        return defaultValue;
    }

    public void teleportTo(@Nonnull ICollisionSystem system, @Nonnull Transform newLocation) {
        if (this.physicsHandle.IsValid()) {
            system.teleport(this.physicsHandle, newLocation);
        } else {
            Frame pendingFrame = new Frame();
            pendingFrame.gameTick = system.getGameTick();
            pendingFrame.location = newLocation;
            pendingFrame.linearVelocity = this.getCurrentLinearVelocity();
            pendingFrame.angularVelocity = this.getCurrentAngularVelocity();
            pendingFrame.accelerations.addAll(this.getCurrentForces());
            this.frameHistory.add(pendingFrame);
            this.frameHistory.add(pendingFrame);
        }
    }

    @Nonnull
    private Frame createExtrapolatedFrame(@Nonnull Frame startingFrame, long ticks) {
        return Frame.extrapolate(startingFrame, ticks);
    }

    private boolean checkIfUpdateNeeded(@Nonnull Frame newSyncFrame) {
        if (this.lastSyncFrame == null) {
            return true;
        }
        if (newSyncFrame.gameTick <= this.lastSyncFrame.gameTick) {
            return false;
        }
        long deltaT = newSyncFrame.gameTick - this.lastSyncFrame.gameTick;
        Frame remotePredicition = this.createExtrapolatedFrame(this.lastSyncFrame, deltaT);
        if (!remotePredicition.linearVelocity.isApprox(newSyncFrame.linearVelocity, 0.02)) {
            return true;
        }
        if (!remotePredicition.angularVelocity.isApprox(newSyncFrame.angularVelocity, 1.0)) {
            return true;
        }
        return !remotePredicition.location.isApprox(newSyncFrame.location, 0.1, 0.1f, 0.01f);
    }

    public void receiveUpdate(long gameTick, @Nonnull PhysicsSyncMessage.PhysicsStateChange syncMessage) {
        this.lastSyncFrame = new Frame();
        this.lastSyncFrame.location = syncMessage.Location != null ? syncMessage.Location : this.getLocation(gameTick);
        this.lastSyncFrame.linearVelocity = syncMessage.LinearVelocityUpdate != null ? syncMessage.LinearVelocityUpdate : this.getLinearVelocity(gameTick);
        this.lastSyncFrame.angularVelocity = syncMessage.AngularVelocityUpdate != null ? syncMessage.AngularVelocityUpdate : this.getAngularVelocity(gameTick);
        this.lastSyncFrame.gameTick = gameTick;
        this.localFrameAtLastReceive = this.getMostRecentFrame();
    }

    public void syncAndLerpToComponent(@Nonnull ICollisionSystem system) {
        Frame pendingFrame = new Frame();
        pendingFrame.gameTick = system.getGameTick();
        if (this.lastSyncFrame != null && this.localFrameAtLastReceive != null) {
            long remoteT = this.lastSyncFrame.gameTick;
            long receiveT = this.localFrameAtLastReceive.gameTick;
            long convergeT = receiveT + REMOTE_LERP_CONVERGE_TICKS;
            if (pendingFrame.gameTick <= convergeT) {
                float blend = 1.0f - Maths.clamp((float)(convergeT - pendingFrame.gameTick) / (float)REMOTE_LERP_CONVERGE_TICKS, 0.0f, 1.0f);
                this.blendExtrapolated(this.localFrameAtLastReceive, this.lastSyncFrame, blend, pendingFrame.gameTick, pendingFrame);
                this.frameHistory.addIfChanged(pendingFrame);
                this.pendingForces.endFrame();
                return;
            }
        }
        this.generatePendingFrameFromCollision(system, pendingFrame);
        this.frameHistory.addIfChanged(pendingFrame);
    }

    private void blendExtrapolated(@Nonnull Frame a, @Nonnull Frame b, float t, long targetTime, @Nonnull Frame target) {
        long ticksSinceA = targetTime - a.gameTick;
        long ticksSinceB = targetTime - b.gameTick;
        this.blend(this.createExtrapolatedFrame(a, ticksSinceA), this.createExtrapolatedFrame(b, ticksSinceB), t, target);
    }

    private void blend(@Nonnull Frame a, @Nonnull Frame b, float t, @Nonnull Frame target) {
        target.location = Transform.interpolate(a.location, b.location, t);
        target.linearVelocity = LinearVelocity.interpolate(a.linearVelocity, b.linearVelocity, t);
        target.angularVelocity = AngularVelocity.interpolate(a.angularVelocity, b.angularVelocity, t);
    }

    public void forceUpdate() {
        this.scheduledUpdate = true;
    }

    public boolean needsUpdate() {
        return this.scheduledUpdate;
    }

    private static class Frame
    implements Comparable<Frame>,
    IDynamicObjectUpdateReceiver {
        public long gameTick;
        public Transform location;
        public final List<IAcceleration> accelerations;
        public final List<IAcceleration> reactions;
        public LinearVelocity linearVelocity;
        public AngularVelocity angularVelocity;

        public Frame(long tick, @Nonnull Transform loc) {
            this.gameTick = tick;
            this.location = loc;
            this.accelerations = new ArrayList<IAcceleration>(3);
            this.reactions = new ArrayList<IAcceleration>(3);
            this.linearVelocity = LinearVelocity.Zero;
            this.angularVelocity = AngularVelocity.Zero;
        }

        public Frame() {
            this(0L, Transform.IDENTITY);
        }

        @Nonnull
        public static Frame interpolate(@Nonnull Frame a, @Nonnull Frame b, float t) {
            Frame interp = new Frame();
            interp.linearVelocity = LinearVelocity.interpolate(a.linearVelocity, b.linearVelocity, t);
            interp.angularVelocity = AngularVelocity.interpolate(a.angularVelocity, b.angularVelocity, t);
            interp.location = Transform.interpolate(a.location, b.location, t);
            interp.gameTick = Maths.roundLerp(a.gameTick, b.gameTick, (double)t);
            return interp;
        }

        @Nonnull
        public static Frame extrapolate(@Nonnull Frame startingFrame, long ticks) {
            Frame extrapolatedFrame = new Frame();
            extrapolatedFrame.gameTick = startingFrame.gameTick + ticks;
            extrapolatedFrame.accelerations.addAll(startingFrame.accelerations);
            LinearAcceleration linearA = startingFrame.sumLinearAcceleration(startingFrame.location, false);
            AngularAcceleration angularA = startingFrame.sumAngularAcceleration(startingFrame.location, false);
            extrapolatedFrame.linearVelocity = startingFrame.linearVelocity.add(linearA.applyOverTicks(ticks));
            extrapolatedFrame.angularVelocity = startingFrame.angularVelocity.compose(angularA.applyOverTicks(ticks));
            Vec3 linearVTerm = startingFrame.linearVelocity.applyOverTicks(ticks);
            Vec3 linearATerm = linearA.applyOverTicks(ticks).scale(0.5).applyOverTicks(ticks);
            Vec3 pos = startingFrame.location.positionVec3().m_82549_(linearVTerm).m_82549_(linearATerm);
            Quaternionf angularVTerm = startingFrame.angularVelocity.applyOverTicks(ticks);
            Quaternionf angularATerm = angularA.applyOverTicks(ticks).scale(0.5).applyOverTicks(ticks);
            Quaternionf ori = new Quaternionf((Quaternionfc)startingFrame.location.Orientation);
            ori.mul((Quaternionfc)angularVTerm);
            ori.mul((Quaternionfc)angularATerm);
            extrapolatedFrame.location = Transform.fromPosAndQuat(pos, ori);
            return extrapolatedFrame;
        }

        @Nonnull
        private LinearAcceleration sumLinearAcceleration(@Nonnull Transform actingOn, boolean includeReaction) {
            LinearAcceleration total = LinearAcceleration.Zero;
            for (IAcceleration acceleration : this.accelerations) {
                if (!acceleration.hasLinearComponent(actingOn)) continue;
                total = total.add(acceleration.getLinearComponent(actingOn));
            }
            return total;
        }

        @Nonnull
        private AngularAcceleration sumAngularAcceleration(@Nonnull Transform actingOn, boolean includeReaction) {
            AngularAcceleration total = AngularAcceleration.Zero;
            for (IAcceleration acceleration : this.accelerations) {
                if (!acceleration.hasAngularComponent(actingOn)) continue;
                total = total.compose(acceleration.getAngularComponent(actingOn));
            }
            return total;
        }

        @Override
        public int compareTo(@Nonnull Frame other) {
            if (Frame.isSameLocation(this, other) && Frame.isSameForces(this, other) && Frame.isSameLinearVelocity(this, other) && Frame.isSameAngularVelocity(this, other)) {
                return 0;
            }
            return Long.compare(this.gameTick, other.gameTick);
        }

        public static boolean isSameForces(@Nonnull Frame a, @Nonnull Frame b) {
            return a.accelerations.equals(b.accelerations) && a.reactions.equals(b.reactions);
        }

        public static boolean isSameLinearVelocity(@Nonnull Frame a, @Nonnull Frame b) {
            return a.linearVelocity.equals(b.linearVelocity);
        }

        public static boolean isSameAngularVelocity(@Nonnull Frame a, @Nonnull Frame b) {
            return a.angularVelocity.equals(b.angularVelocity);
        }

        public static boolean isSameLocation(@Nonnull Frame a, @Nonnull Frame b) {
            return a.location.equals(b.location);
        }

        @Nonnull
        public String toString() {
            return "[" + this.gameTick + "]@" + this.location + " with [" + this.linearVelocity + "] and [" + this.angularVelocity + "]";
        }

        @Override
        public void handleStaticCollision(@Nonnull StaticCollisionEvent event) {
        }

        @Override
        public void handleDynamicCollision(@Nonnull DynamicCollisionEvent event) {
        }

        @Override
        public void updateLocation(@Nonnull Transform newLoc) {
            this.location = newLoc;
        }

        @Override
        public void updateLinearVelocity(@Nonnull LinearVelocity linearV) {
            this.linearVelocity = linearV;
        }

        @Override
        public void updateAngularVelocity(@Nonnull AngularVelocity angularV) {
            this.angularVelocity = angularV;
        }

        @Override
        public void updateReactionForce(@Nonnull List<IAcceleration> reactionAccelerations) {
            this.reactions.clear();
            this.reactions.addAll(reactionAccelerations);
        }
    }

    private static class FrameBuilder {
        public Frame FrameA;
        public Frame FrameB;
        public final long TargetTick;

        public FrameBuilder(long gameTick) {
            this.TargetTick = gameTick;
        }

        @Nonnull
        public FrameBuilder unknown() {
            return this;
        }

        @Nonnull
        public FrameBuilder interpolated(@Nonnull Frame srcA, @Nonnull Frame srcB) {
            this.FrameA = srcA;
            this.FrameB = srcB;
            return this;
        }

        @Nonnull
        public FrameBuilder extrapolated(@Nonnull Frame src) {
            this.FrameA = src;
            return this;
        }

        @Nonnull
        public FrameBuilder exact(@Nonnull Frame src) {
            this.FrameA = src;
            return this;
        }

        @Nonnull
        public FrameBuilder test(@Nonnull DeltaRingBuffer<Frame> frameHistory) {
            Frame before = null;
            Frame after = null;
            for (Frame frame : frameHistory) {
                long delta = this.TargetTick - frame.gameTick;
                if (delta == 0L) {
                    return this.exact(frame);
                }
                if (delta < 0L) {
                    if (before != null && frame.gameTick <= before.gameTick) continue;
                    before = frame;
                    continue;
                }
                if (after != null && frame.gameTick >= after.gameTick) continue;
                after = frame;
            }
            if (before != null && after != null) {
                return this.interpolated(before, after);
            }
            if (before != null) {
                return this.extrapolated(before);
            }
            if (after != null) {
                return this.extrapolated(after);
            }
            return this.unknown();
        }

        public boolean isExact() {
            return this.FrameA != null && this.FrameA.gameTick == this.TargetTick;
        }

        public boolean isExtrapolation() {
            return this.FrameA != null && this.FrameB == null && this.FrameA.gameTick != this.TargetTick;
        }

        public boolean isInterpolation() {
            return this.FrameA != null && this.FrameB != null;
        }

        @Nonnull
        public Optional<Frame> build(boolean allowInterpolation, boolean allowExtrapolation) {
            if (this.FrameA == null) {
                return Optional.empty();
            }
            if (this.FrameB == null) {
                if (this.FrameA.gameTick == this.TargetTick) {
                    return Optional.of(this.FrameA);
                }
                if (allowExtrapolation) {
                    return Optional.of(Frame.extrapolate(this.FrameA, this.TargetTick - this.FrameA.gameTick));
                }
                return Optional.empty();
            }
            if (allowInterpolation) {
                return Optional.of(Frame.interpolate(this.FrameA, this.FrameB, (float)(this.TargetTick - this.FrameA.gameTick) / (float)(this.FrameB.gameTick - this.FrameA.gameTick)));
            }
            return Optional.empty();
        }
    }
}

