/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.collision.threading;

import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.collision.obb.FullSeparationResult;
import com.flansmod.physics.common.collision.obb.SeparationResult;
import com.flansmod.physics.common.units.AngularVelocity;
import com.flansmod.physics.common.units.CompoundVelocity;
import com.flansmod.physics.common.units.Impulse;
import com.flansmod.physics.common.units.LinearVelocity;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.ProjectedRange;
import com.flansmod.physics.common.util.ProjectionUtil;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.shapes.Plane;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CollisionTasks {
    private static final Vec3 X_AXIS = new Vec3(1.0, 0.0, 0.0);
    private static final Vec3 Y_AXIS = new Vec3(0.0, 1.0, 0.0);
    private static final Vec3 Z_AXIS = new Vec3(0.0, 0.0, 1.0);
    private static final Vec3[] GLOBAL_AXES = new Vec3[]{X_AXIS, Y_AXIS, Z_AXIS};
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.EAST, Direction.NORTH, Direction.UP};

    @Nullable
    private static SeparationResult quickSeparateSpheres(@Nonnull Vec3 aCenter, double aRadius, @Nonnull Vec3 bCenter, double bRadius) {
        Vec3 deltaPos = bCenter.m_82546_(aCenter);
        double deltaLengthSq = deltaPos.m_82556_();
        if (deltaLengthSq > (aRadius + bRadius) * (aRadius + bRadius)) {
            return SeparationResult.successful(Plane.ofNormalAndPointOnPlane(deltaPos.m_82541_(), aCenter.m_82549_(deltaPos.m_82490_(0.5))));
        }
        return null;
    }

    @Nonnull
    public static SeparationResult separateSpheres(@Nonnull Vec3 aCenter, double aRadius, @Nonnull Vec3 bCenter, double bRadius) {
        Vec3 deltaPos = bCenter.m_82546_(aCenter);
        double deltaLengthSq = deltaPos.m_82556_();
        if (deltaLengthSq > (aRadius + bRadius) * (aRadius + bRadius)) {
            return SeparationResult.successful(Plane.ofNormalAndPointOnPlane(deltaPos.m_82541_(), aCenter.m_82549_(deltaPos.m_82490_(0.5))));
        }
        double dist = aRadius + bRadius - Maths.sqrt(deltaLengthSq);
        return SeparationResult.failure(Plane.ofNormalAndPointOnPlane(deltaPos.m_82541_(), aCenter.m_82549_(deltaPos.m_82490_(0.5))), dist);
    }

    @Nonnull
    public static FullSeparationResult separateGetAllOptions(final @Nonnull TransformedBB aCollider, final @Nonnull TransformedBB bCollider) {
        return CollisionTasks.separateGetAllOptions(new AxisPermutationIterator3D(){

            @Override
            public Vec3 getAxisA(int index) {
                return aCollider.GetAxis(DIRECTIONS[index]);
            }

            @Override
            public Vec3 getAxisB(int index) {
                return bCollider.GetAxis(DIRECTIONS[index]);
            }
        }, normal -> ProjectionUtil.ProjectOBBMinMax(normal, aCollider), normal -> ProjectionUtil.ProjectOBBMinMax(normal, bCollider));
    }

    @Nonnull
    public static FullSeparationResult separateGetAllOptions(final @Nonnull TransformedBB aCollider, @Nonnull AABB bCollider) {
        return CollisionTasks.separateGetAllOptions(new AxisPermutationIterator3D(){

            @Override
            public Vec3 getAxisA(int index) {
                return aCollider.GetAxis(DIRECTIONS[index]);
            }

            @Override
            public Vec3 getAxisB(int index) {
                return GLOBAL_AXES[index];
            }
        }, normal -> ProjectionUtil.ProjectOBBMinMax(normal, aCollider), normal -> ProjectionUtil.ProjectAABBMinMax(normal, bCollider));
    }

    @Nonnull
    public static FullSeparationResult separateGetAllOptions(@Nonnull AABB aCollider, @Nonnull AABB bCollider) {
        return CollisionTasks.separateGetAllOptions(new AxisPermutationIterator3D(){

            @Override
            public Vec3 getAxisA(int index) {
                return GLOBAL_AXES[index];
            }

            @Override
            public Vec3 getAxisB(int index) {
                return GLOBAL_AXES[index];
            }
        }, normal -> ProjectionUtil.ProjectAABBMinMax(normal, aCollider), normal -> ProjectionUtil.ProjectAABBMinMax(normal, bCollider));
    }

    @Nonnull
    public static SeparationResult separate(final @Nonnull TransformedBB aCollider, final @Nonnull TransformedBB bCollider) {
        return CollisionTasks.separate(new AxisPermutationIterator3D(){

            @Override
            public Vec3 getAxisA(int index) {
                return aCollider.GetAxis(DIRECTIONS[index]);
            }

            @Override
            public Vec3 getAxisB(int index) {
                return bCollider.GetAxis(DIRECTIONS[index]);
            }
        }, normal -> ProjectionUtil.ProjectOBBMinMax(normal, aCollider), normal -> ProjectionUtil.ProjectOBBMinMax(normal, bCollider));
    }

    @Nonnull
    public static SeparationResult separate(final @Nonnull TransformedBB aCollider, @Nonnull AABB bCollider) {
        return CollisionTasks.separate(new AxisPermutationIterator3D(){

            @Override
            public Vec3 getAxisA(int index) {
                return aCollider.GetAxis(DIRECTIONS[index]);
            }

            @Override
            public Vec3 getAxisB(int index) {
                return GLOBAL_AXES[index];
            }
        }, normal -> ProjectionUtil.ProjectOBBMinMax(normal, aCollider), normal -> ProjectionUtil.ProjectAABBMinMax(normal, bCollider));
    }

    @Nonnull
    public static SeparationResult separate(@Nonnull AABB aCollider, @Nonnull AABB bCollider) {
        return CollisionTasks.separate(new AxisPermutationIterator3D(){

            @Override
            public Vec3 getAxisA(int index) {
                return GLOBAL_AXES[index];
            }

            @Override
            public Vec3 getAxisB(int index) {
                return GLOBAL_AXES[index];
            }
        }, normal -> ProjectionUtil.ProjectAABBMinMax(normal, aCollider), normal -> ProjectionUtil.ProjectAABBMinMax(normal, bCollider));
    }

    @Nonnull
    private static FullSeparationResult separateGetAllOptions(@Nonnull AxisPermutationIterator testAxes, @Nonnull Function<Vec3, ProjectedRange> projectFuncA, @Nonnull Function<Vec3, ProjectedRange> projectFuncB) {
        ArrayList<Vec3> testedNormals = new ArrayList<Vec3>(6);
        ImmutableList.Builder failedTests = new ImmutableList.Builder();
        while (testAxes.hasNext()) {
            SeparationResult axisResult;
            Vec3 axis = (Vec3)testAxes.next();
            if (Maths.approx(axis.m_82556_(), 0.0) || (axisResult = CollisionTasks.test(projectFuncA, projectFuncB, axis = axis.m_82541_(), testedNormals, null)) == null) continue;
            if (axisResult.success()) {
                return FullSeparationResult.of(axisResult);
            }
            failedTests.add((Object)axisResult);
        }
        return FullSeparationResult.of((ImmutableList<SeparationResult>)failedTests.build());
    }

    @Nonnull
    private static SeparationResult separate(@Nonnull AxisPermutationIterator testAxes, @Nonnull Function<Vec3, ProjectedRange> projectFuncA, @Nonnull Function<Vec3, ProjectedRange> projectFuncB) {
        ArrayList<Vec3> testedNormals = new ArrayList<Vec3>(6);
        SeparationResult bestResult = null;
        while (testAxes.hasNext()) {
            Vec3 axis = (Vec3)testAxes.next();
            if (Maths.approx(axis.m_82556_(), 0.0) || (bestResult = CollisionTasks.test(projectFuncA, projectFuncB, axis = axis.m_82541_(), testedNormals, bestResult)) == null || !bestResult.success()) continue;
            return bestResult;
        }
        if (bestResult == null) {
            FlansPhysicsMod.LOGGER.error("Ended separation tests with no results at all, not even a failure");
            return new SeparationResult(false, Plane.of(X_AXIS, 0.0), -1.0);
        }
        return bestResult;
    }

    @Nullable
    private static SeparationResult test(@Nonnull Function<Vec3, ProjectedRange> projectFuncA, @Nonnull Function<Vec3, ProjectedRange> projectFuncB, @Nonnull Vec3 normal, @Nonnull List<Vec3> testedNormals, @Nullable SeparationResult previousBestResult) {
        if (normal.m_82556_() <= 1.0E-7) {
            return previousBestResult;
        }
        for (Vec3 alreadyTested : testedNormals) {
            double dot = alreadyTested.m_82526_(normal);
            if (!Maths.absApprox(dot, 1.0)) continue;
            return previousBestResult;
        }
        testedNormals.add(normal);
        ProjectedRange bProjection = projectFuncA.apply(normal);
        ProjectedRange aProjection = projectFuncB.apply(normal);
        Pair<Double, ProjectionUtil.ProjectionComparison> comparison = ProjectionUtil.GetSeparationDistanceAndOrder(aProjection, bProjection);
        double sepDist = (Double)comparison.getFirst();
        if (sepDist >= 0.0) {
            if (comparison.getSecond() == ProjectionUtil.ProjectionComparison.Separate_B_Then_A) {
                return SeparationResult.successful(Plane.of(normal, bProjection.max()));
            }
            return SeparationResult.successful(Plane.of(normal.m_82490_(-1.0), -bProjection.min()));
        }
        if (comparison.getSecond() == ProjectionUtil.ProjectionComparison.Colliding_B_Then_A) {
            return SeparationResult.bestFailResult(previousBestResult, Plane.of(normal.m_82490_(-1.0), -aProjection.min()), sepDist);
        }
        return SeparationResult.bestFailResult(previousBestResult, Plane.of(normal, aProjection.max()), sepDist);
    }

    @Nonnull
    public static Pair<Transform, Transform> resolveByProjection(@Nonnull Transform posA, double inverseMassA, @Nonnull Transform posB, double inverseMassB, @Nonnull Vec3 collisionNormal, double penetrationDepth) {
        double totalInverseMass = inverseMassA + inverseMassB;
        if (Maths.approx(totalInverseMass, 0.0)) {
            return Pair.of((Object)posA, (Object)posB);
        }
        double depthA = penetrationDepth * (inverseMassA / totalInverseMass);
        double depthB = penetrationDepth * (inverseMassB / totalInverseMass);
        Transform projectedA = posA.translated(collisionNormal.m_82490_(-depthA));
        Transform projectedB = posB.translated(collisionNormal.m_82490_(depthB));
        return Pair.of((Object)projectedA, (Object)projectedB);
    }

    @Nonnull
    public static Transform resolveByProjectionAgainstStatic(@Nonnull Transform posA, @Nonnull Vec3 collisionNormal, double penetrationDepth) {
        return posA.translated(collisionNormal.m_82490_(-penetrationDepth));
    }

    @Nonnull
    public static Pair<LinearVelocity, LinearVelocity> resolveByLinearImpulse(@Nonnull LinearVelocity vA, double inverseMassA, @Nonnull LinearVelocity vB, double inverseMassB, @Nonnull Vec3 normal, double coefficientOfRestitution) {
        Impulse j = Impulse.calculateLinear(vA, inverseMassA, vB, inverseMassB, normal, coefficientOfRestitution);
        return Pair.of((Object)j.applyTo(vA, inverseMassA), (Object)j.applyTo(vB, inverseMassB));
    }

    @Nonnull
    public static Pair<CompoundVelocity, CompoundVelocity> findResponseByImpulse(@Nonnull CompoundVelocity vA, @Nonnull Vec3 centerA, double inverseMassA, @Nonnull Vec3 inertiaTensorA, @Nonnull CompoundVelocity vB, @Nonnull Vec3 centerB, double inverseMassB, @Nonnull Vec3 inertiaTensorB, @Nonnull Vec3 collisionPoint, @Nonnull Vec3 collisionNormal, double coefficientOfRestitution) {
        Impulse impulse = Impulse.calculateAtPoint(vA, centerA, inverseMassA, inertiaTensorA, vB, centerB, inverseMassB, inertiaTensorB, collisionPoint, collisionNormal, coefficientOfRestitution);
        LinearVelocity linearA = impulse.applyTo(inverseMassA);
        AngularVelocity angularA = impulse.applyTo(centerA, inertiaTensorA, collisionPoint);
        LinearVelocity linearB = impulse.applyTo(inverseMassB);
        AngularVelocity angularB = impulse.applyTo(centerB, inertiaTensorB, collisionPoint);
        return Pair.of((Object)CompoundVelocity.of(linearA, angularA), (Object)CompoundVelocity.of(linearB, angularB));
    }

    @Nonnull
    public static CompoundVelocity findResponseByImpulseAgainstStatic(@Nonnull CompoundVelocity vA, @Nonnull Vec3 centerA, double inverseMassA, @Nonnull Vec3 inertiaTensorA, @Nonnull Vec3 collisionPoint, @Nonnull Vec3 collisionNormal, double coefficientOfRestitution) {
        Impulse impulse = Impulse.calculateAtPoint(vA, centerA, inverseMassA, inertiaTensorA, collisionPoint, collisionNormal, coefficientOfRestitution);
        LinearVelocity linearA = impulse.applyTo(inverseMassA);
        AngularVelocity angularA = impulse.applyTo(centerA, inertiaTensorA, collisionPoint);
        return CompoundVelocity.of(linearA, angularA);
    }

    private static abstract class AxisPermutationIterator
    implements Iterator<Vec3> {
        private AxisPermutationIterator() {
        }
    }

    private static abstract class AxisPermutationIterator3D
    extends AxisPermutationIterator {
        public static final int NUM_TESTS = 15;
        private int IterIndex = -1;

        private AxisPermutationIterator3D() {
        }

        public abstract Vec3 getAxisA(int var1);

        public abstract Vec3 getAxisB(int var1);

        @Override
        public boolean hasNext() {
            return this.IterIndex < 14;
        }

        @Override
        public Vec3 next() {
            ++this.IterIndex;
            if (this.IterIndex < 3) {
                return this.getAxisA(this.IterIndex);
            }
            if (this.IterIndex < 6) {
                return this.getAxisB(this.IterIndex - 3);
            }
            int index = this.IterIndex - 6;
            int indexA = index / 3;
            int indexB = index % 3;
            return this.getAxisA(indexA).m_82537_(this.getAxisB(indexB));
        }
    }
}

