/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.collision.threading;

import com.flansmod.physics.common.collision.ColliderHandle;
import com.flansmod.physics.common.collision.DynamicCollisionEvent;
import com.flansmod.physics.common.collision.StaticCollisionEvent;
import com.flansmod.physics.common.collision.TransformedBBCollection;
import com.flansmod.physics.common.collision.obb.ICollisionAccessDynamicObject;
import com.flansmod.physics.common.collision.threading.CollisionTasks;
import com.flansmod.physics.common.collision.threading.ICollisionTask;
import com.flansmod.physics.common.units.AngularVelocity;
import com.flansmod.physics.common.units.CompoundVelocity;
import com.flansmod.physics.common.units.LinearVelocity;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class CollisionTaskResolveDynamic
implements ICollisionTask<Input, Output> {
    @Nonnull
    public final ColliderHandle Handle;
    @Nullable
    private Input Input;
    @Nullable
    private Output Output;

    @Nonnull
    public static CollisionTaskResolveDynamic of(@Nonnull ColliderHandle handle, @Nonnull ICollisionAccessDynamicObject dynamic, @Nonnull List<DynamicCollisionEvent> dynamicCollisions, @Nonnull List<StaticCollisionEvent> staticCollisions) {
        CollisionTaskResolveDynamic task = new CollisionTaskResolveDynamic(handle);
        task.prepare(new Input(dynamic, dynamicCollisions, staticCollisions));
        return task;
    }

    private CollisionTaskResolveDynamic(@Nonnull ColliderHandle handle) {
        this.Handle = handle;
    }

    @Override
    public void prepare(@Nonnull Input input) {
        this.Input = input;
    }

    @Override
    public boolean canRun() {
        return this.Input != null;
    }

    @Nonnull
    private List<Pair<Double, StaticCollisionEvent>> sort(@Nonnull TransformedBBCollection currentBBs, @Nonnull List<StaticCollisionEvent> unsorted) {
        ArrayList<Pair<Double, StaticCollisionEvent>> byIntersectionTime = new ArrayList<Pair<Double, StaticCollisionEvent>>(unsorted.size());
        for (StaticCollisionEvent event : unsorted) {
            double depthPre;
            double depthPost;
            double depthDelta;
            double aMaxAfter;
            double aMaxBefore = event.separationPlane().getOBBsHeightAbove(currentBBs);
            double intersectionFractionalTick = aMaxBefore > (aMaxAfter = 0.0) ? 1.0 : (Maths.approx(depthDelta = (depthPost = event.depth()) - (depthPre = depthPost - aMaxBefore), 0.0) ? 1.0 : Maths.clamp(-depthPre / (depthPost - depthPre), 0.0, 1.0));
            byIntersectionTime.add((Pair<Double, StaticCollisionEvent>)Pair.of((Object)intersectionFractionalTick, (Object)event));
        }
        byIntersectionTime.sort(Comparator.comparingDouble(Pair::getFirst));
        return byIntersectionTime;
    }

    private double getFirstIntersectTime(@Nonnull List<Pair<Double, StaticCollisionEvent>> byIntersectionTime) {
        if (byIntersectionTime.isEmpty()) {
            return 1.0;
        }
        return (Double)byIntersectionTime.get(0).getFirst();
    }

    @Nonnull
    private List<Pair<Double, StaticCollisionEvent>> popSimultaneousEvents(@Nonnull List<Pair<Double, StaticCollisionEvent>> byIntersectionTime, double epsilon) {
        double ti;
        if (byIntersectionTime.size() == 0) {
            return List.of();
        }
        ArrayList<Pair<Double, StaticCollisionEvent>> simultaneousGroup = new ArrayList<Pair<Double, StaticCollisionEvent>>(byIntersectionTime.size());
        simultaneousGroup.add(byIntersectionTime.get(0));
        double t = (Double)byIntersectionTime.get(0).getFirst();
        for (int i = 1; i < byIntersectionTime.size() && Maths.approx(t, ti = ((Double)byIntersectionTime.get(i).getFirst()).doubleValue(), epsilon); ++i) {
            simultaneousGroup.add(byIntersectionTime.get(i));
        }
        return simultaneousGroup;
    }

    private void resolveEventAtTime(@Nonnull StaticCollisionEvent event, double t) {
    }

    @Override
    public void run() {
        Transform pendingLocation;
        if (this.Input == null) {
            this.Output = new Output(1.0, Transform.IDENTITY, CompoundVelocity.Zero);
            return;
        }
        LinearVelocity linearV = this.Input.Dynamic.getLinearVelocity();
        AngularVelocity angularV = this.Input.Dynamic.getAngularVelocity();
        Transform currentLocation = this.Input.Dynamic().getCurrentLocation();
        TransformedBBCollection currentBBs = new TransformedBBCollection(currentLocation, this.Input.Dynamic.getCurrentColliders().Colliders());
        List<Pair<Double, StaticCollisionEvent>> byIntersectionTime = this.sort(currentBBs, this.Input.StaticCollisions);
        double firstIntersect = this.getFirstIntersectTime(byIntersectionTime);
        Transform projectedLocation = pendingLocation = this.extrapolate(currentLocation, linearV, angularV, firstIntersect);
        CompoundVelocity compoundV = CompoundVelocity.of(linearV, angularV);
        if (!byIntersectionTime.isEmpty()) {
            List<Pair<Double, StaticCollisionEvent>> nextGroup = this.popSimultaneousEvents(byIntersectionTime, 1.0E-7);
            CompoundVelocity[] impulseResults = new CompoundVelocity[nextGroup.size()];
            for (int i = 0; i < nextGroup.size(); ++i) {
                StaticCollisionEvent collision = (StaticCollisionEvent)nextGroup.get(i).getSecond();
                impulseResults[i] = CollisionTasks.findResponseByImpulseAgainstStatic(compoundV, pendingLocation.positionVec3(), this.Input.Dynamic.getInverseMass(), this.Input.Dynamic.getInertiaTensor(), collision.contactSurface().getAveragePos(), collision.separationPlane().getNormal(), 0.6);
                projectedLocation = CollisionTasks.resolveByProjectionAgainstStatic(projectedLocation, collision.separationPlane().getNormal(), collision.depth());
            }
            compoundV = compoundV.compose(CompoundVelocity.average(impulseResults));
        }
        this.Output = new Output(firstIntersect, projectedLocation, compoundV);
    }

    @Nonnull
    private Transform extrapolate(@Nonnull Transform t, @Nonnull LinearVelocity linearV, @Nonnull AngularVelocity angularV, double parameter) {
        if (Maths.approx(parameter, 0.0)) {
            return t;
        }
        return Transform.fromPosAndQuat(t.positionVec3().m_82549_(linearV.applyOverTicks(parameter)), t.Orientation.mul((Quaternionfc)angularV.applyOverTicks(parameter), new Quaternionf()));
    }

    @Nonnull
    private Transform extrapolate(@Nonnull Transform t, @Nonnull LinearVelocity linearV, @Nonnull AngularVelocity angularV) {
        return Transform.fromPosAndQuat(t.positionVec3().m_82549_(linearV.applyOneTick()), t.Orientation.mul((Quaternionfc)angularV.applyOneTick(), new Quaternionf()));
    }

    @Override
    public boolean isComplete() {
        return this.Output != null;
    }

    @Override
    public boolean canCancel() {
        return false;
    }

    @Override
    public void cancel() {
    }

    @Override
    @Nullable
    public Output getResult() {
        return this.Output;
    }

    public record Input(@Nonnull ICollisionAccessDynamicObject Dynamic, @Nonnull List<DynamicCollisionEvent> DynamicCollisions, @Nonnull List<StaticCollisionEvent> StaticCollisions) {
    }

    public record Output(double resolvedPartialTick, @Nonnull Transform ResolvedLocation, @Nonnull CompoundVelocity ResolvedVelocity) {
    }
}

