/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.collision.obb;

import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.collision.TransformedBBCollection;
import com.flansmod.physics.common.units.AngularVelocity;
import com.flansmod.physics.common.units.LinearVelocity;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface IConstDynamicObject {
    public boolean isInvalid();

    @Nonnull
    public AABB getLocalBounds();

    public double getMass();

    public double getInverseMass();

    @Nonnull
    public Vec3 getMomentOfInertia();

    @Nonnull
    public Vec3 getInertiaTensor();

    public double getLinearDrag();

    default public double getLinearDecayPerTick() {
        return 1.0 - this.getLinearDrag();
    }

    public double getAngularDrag();

    default public double getAngularDecayPerTick() {
        return 1.0 - this.getAngularDrag();
    }

    @Nonnull
    public AABB getSweepTestAABB();

    @Nonnull
    public Transform getCurrentLocation();

    @Nonnull
    public TransformedBB getCurrentBB();

    @Nonnull
    public TransformedBBCollection getCurrentColliders();

    @Nonnull
    public AABB getCurrentWorldBounds();

    @Nonnull
    public LinearVelocity getLinearVelocity();

    @Nonnull
    public AngularVelocity getAngularVelocity();
}

