/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.collision;

import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public record TransformedBBCollection(@Nonnull Transform Location, @Nonnull ImmutableList<AABB> Colliders) {
    public int getCount() {
        return this.Colliders.size();
    }

    @Nonnull
    public Vec3 getCenter(int index) {
        return this.Location.positionVec3().m_82549_(((AABB)this.Colliders.get(index)).m_82399_());
    }

    @Nonnull
    public Vector3f getHalfExtents(int index) {
        AABB aabb = (AABB)this.Colliders.get(index);
        return new Vector3f((float)aabb.m_82362_() / 2.0f, (float)aabb.m_82376_() / 2.0f, (float)aabb.m_82385_() / 2.0f);
    }

    @Nonnull
    public TransformedBB getColliderBB(int index) {
        return new TransformedBB(Transform.fromPosAndQuat(this.getCenter(index), this.Location.Orientation), this.getHalfExtents(index));
    }

    @Nonnull
    public TransformedBB getBoundingBB() {
        return TransformedBB.Of(this.Location, this.getLocalBounds());
    }

    @Nonnull
    public AABB getLocalBounds() {
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        double zMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        double yMax = -1.7976931348623157E308;
        double zMax = -1.7976931348623157E308;
        for (AABB aabb : this.Colliders) {
            xMax = Maths.max(aabb.f_82291_, xMax);
            yMax = Maths.max(aabb.f_82292_, yMax);
            zMax = Maths.max(aabb.f_82293_, zMax);
            xMin = Maths.min(aabb.f_82288_, xMin);
            yMin = Maths.min(aabb.f_82289_, yMin);
            zMin = Maths.min(aabb.f_82290_, zMin);
        }
        return new AABB(xMin, yMin, zMin, xMax, yMax, zMax);
    }
}

