/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.collision;

import com.flansmod.physics.common.collision.ColliderHandle;
import com.flansmod.physics.common.collision.DynamicCollisionEvent;
import com.flansmod.physics.common.collision.IDynamicObjectUpdateReceiver;
import com.flansmod.physics.common.collision.StaticCollisionEvent;
import com.flansmod.physics.common.units.AngularVelocity;
import com.flansmod.physics.common.units.LinearForce;
import com.flansmod.physics.common.units.LinearVelocity;
import com.flansmod.physics.common.units.Torque;
import com.flansmod.physics.common.util.Transform;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface ICollisionSystem {
    public void preTick();

    public void physicsTick();

    public long getGameTick();

    @Nonnull
    default public ColliderHandle registerDynamic(@Nonnull List<AABB> localColliders, @Nonnull Transform initialTransform, double mass) {
        return this.registerDynamic(localColliders, initialTransform, mass, new Vec3(mass, mass, mass));
    }

    @Nonnull
    public ColliderHandle registerDynamic(@Nonnull List<AABB> var1, @Nonnull Transform var2, double var3, @Nonnull Vec3 var5);

    public void unregisterDynamic(@Nonnull ColliderHandle var1);

    public void updateColliders(@Nonnull ColliderHandle var1, @Nonnull List<AABB> var2);

    public boolean isHandleInvalidated(@Nonnull ColliderHandle var1);

    @Nonnull
    public AngularVelocity getAngularVelocity(@Nonnull ColliderHandle var1);

    @Nonnull
    public LinearVelocity getLinearVelocity(@Nonnull ColliderHandle var1);

    public void setLinearVelocity(@Nonnull ColliderHandle var1, @Nonnull LinearVelocity var2);

    public void setAngularVelocity(@Nonnull ColliderHandle var1, @Nonnull AngularVelocity var2);

    public void teleport(@Nonnull ColliderHandle var1, @Nonnull Transform var2);

    public void applyForce(@Nonnull ColliderHandle var1, @Nonnull LinearForce var2);

    public void applyTorque(@Nonnull ColliderHandle var1, @Nonnull Torque var2);

    @Nonnull
    public Transform processEvents(@Nonnull ColliderHandle var1, @Nonnull Consumer<StaticCollisionEvent> var2, @Nonnull Consumer<DynamicCollisionEvent> var3);

    public void copyDynamicState(@Nonnull ColliderHandle var1, @Nonnull IDynamicObjectUpdateReceiver var2);
}

