/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common;

import com.flansmod.physics.client.DebugRenderer;
import com.flansmod.physics.client.PhysicsDebugRenderer;
import com.flansmod.physics.client.PhysicsKeyMappings;
import com.flansmod.physics.client.TestCubeEntityRenderer;
import com.flansmod.physics.common.collision.ColliderHandle;
import com.flansmod.physics.common.collision.ICollisionSystem;
import com.flansmod.physics.common.collision.obb.OBBCollisionSystem;
import com.flansmod.physics.common.entity.PhysicsEntity;
import com.flansmod.physics.common.tests.CollisionTests;
import com.flansmod.physics.common.tests.TestCubeEntity;
import com.flansmod.physics.common.tests.TransformTests;
import com.flansmod.physics.network.PhysicsPacketHandler;
import com.flansmod.physics.network.PhysicsSyncMessage;
import com.flansmod.physics.server.command.CommandPhysicsDebug;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="flansphysics")
public class FlansPhysicsMod {
    public static final String MODID = "flansphysics";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static boolean PAUSE_PHYSICS = false;
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"flansphysics");
    public static final RegistryObject<EntityType<TestCubeEntity>> ENT_TYPE_TEST_CUBE = ENTITY_TYPES.register("test_cube", () -> EntityType.Builder.m_20704_(TestCubeEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20712_("test_cube"));

    @Nonnull
    public static ICollisionSystem forLevel(@Nonnull Level level) {
        return OBBCollisionSystem.ForLevel(level);
    }

    public FlansPhysicsMod() {
        TransformTests.runTests();
        CollisionTests.runTests();
        PhysicsPacketHandler.registerMessages();
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ENTITY_TYPES.register(modEventBus);
    }

    @SubscribeEvent
    public void OnLevelTick(@Nonnull TickEvent.LevelTickEvent levelTick) {
        ICollisionSystem physics = FlansPhysicsMod.forLevel(levelTick.level);
        if (levelTick.phase == TickEvent.Phase.START) {
            physics.preTick();
        }
        if (levelTick.phase == TickEvent.Phase.END) {
            physics.physicsTick();
        }
    }

    @SubscribeEvent
    public void OnRegisterCommands(@Nonnull RegisterCommandsEvent event) {
        CommandPhysicsDebug.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    public static void HandlePhysicsSync(@Nonnull PhysicsSyncMessage syncMessage, @Nonnull ServerPlayer player) {
        Entity entity = player.m_9236_().m_6815_(syncMessage.EntityID);
        if (entity instanceof PhysicsEntity) {
            PhysicsEntity physicsEntity = (PhysicsEntity)entity;
            if (physicsEntity.m_6688_() == player) {
                physicsEntity.handleSyncMessage(syncMessage);
            } else {
                LOGGER.warn("Player " + player + " tried to send physics packet for server-controlled entity " + entity);
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="flansphysics")
    public static class ClientMod {
        public static final DebugRenderer DEBUG_RENDERER = new DebugRenderer();
        public static final PhysicsDebugRenderer PHYSICS_DEBUG_RENDERER = new PhysicsDebugRenderer();

        @SubscribeEvent
        public static void ClientInit(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)ENT_TYPE_TEST_CUBE.get()), TestCubeEntityRenderer::new);
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            modEventBus.addListener(ClientMod::OnKeyMappings);
            MinecraftForge.EVENT_BUS.addListener(ClientMod::OnClientTick);
        }

        public static void OnClientTick(@Nonnull TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                while (((KeyMapping)PhysicsKeyMappings.DEBUG_PAUSE_PHYSICS.get()).m_90859_()) {
                    boolean bl = PAUSE_PHYSICS = !PAUSE_PHYSICS;
                    if (PAUSE_PHYSICS) {
                        Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237115_((String)"Phys Pause"), false);
                        continue;
                    }
                    Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237115_((String)"Phys Resume"), false);
                }
                while (((KeyMapping)PhysicsKeyMappings.DEBUG_INCREASE_PHYSICS_INSPECT.get()).m_90859_()) {
                    ClientMod.CyclePhysDebug(1);
                }
                while (((KeyMapping)PhysicsKeyMappings.DEBUG_DECREASE_PHYSICS_INSPECT.get()).m_90859_()) {
                    ClientMod.CyclePhysDebug(-1);
                }
            }
        }

        public static void OnKeyMappings(@Nonnull RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)PhysicsKeyMappings.DEBUG_INCREASE_PHYSICS_INSPECT.get());
            event.register((KeyMapping)PhysicsKeyMappings.DEBUG_DECREASE_PHYSICS_INSPECT.get());
        }

        private static void CyclePhysDebug(int delta) {
            if (Minecraft.m_91087_().f_91073_ != null) {
                ColliderHandle handle = OBBCollisionSystem.Debug_CycleInspectHandle((Level)Minecraft.m_91087_().f_91073_, delta);
                int numHandles = OBBCollisionSystem.Debug_GetNumHandles((Level)Minecraft.m_91087_().f_91073_);
                if (handle.Handle() == 0L) {
                    Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237115_((String)"No Debug"), false);
                } else {
                    Minecraft.m_91087_().m_240442_().m_240494_((Component)Component.m_237113_((String)("Debug handle:" + handle.Handle() + "/" + numHandles)), false);
                }
            }
        }

        public static void HandlePhysicsSync(@Nonnull PhysicsSyncMessage syncMessage) {
            Entity entity;
            if (Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(syncMessage.EntityID)) instanceof PhysicsEntity) {
                PhysicsEntity physicsEntity = (PhysicsEntity)entity;
                physicsEntity.handleSyncMessage(syncMessage);
            }
        }
    }
}

