/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.client;

import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.flansmod.physics.common.util.Transform;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import org.joml.AxisAngle4d;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class DebugRenderer {
    private static final Queue<DebugRenderItem> itemsToAdd = new ConcurrentLinkedQueue<DebugRenderItem>();
    private static final ArrayList<DebugRenderItem> renderItems = new ArrayList();

    public static void renderCube(Transform t, int ticks, Vector4f col, Vector3f h) {
        itemsToAdd.add(new DebugRenderCube(t, ticks, col, h));
    }

    public static void renderPoint(Transform t, int ticks, Vector4f col) {
        itemsToAdd.add(new DebugRenderPoint(t, ticks, col));
    }

    public static void renderLine(Transform t, int ticks, Vector4f col, Vec3 ray) {
        if (!Maths.approx(ray.m_82556_(), 0.0)) {
            itemsToAdd.add(new DebugRenderLine(t, ticks, col, ray, false));
        }
    }

    public static void renderArrow(Transform t, int ticks, Vector4f col, Vec3 ray) {
        if (!Maths.approx(ray.m_82556_(), 0.0)) {
            itemsToAdd.add(new DebugRenderLine(t, ticks, col, ray, true));
        }
    }

    public static void renderRotation(Transform t, int ticks, Vector4f col, Vec3 axis, double magnitude) {
        if (!Maths.approx(magnitude, 0.0)) {
            itemsToAdd.add(new DebugRenderRotation(t, ticks, col, axis, magnitude, true));
        }
    }

    public static void renderAxes(Transform t, int ticks, Vector4f col) {
        itemsToAdd.add(new DebugRenderAxes(t, ticks, col));
    }

    public DebugRenderer() {
        MinecraftForge.EVENT_BUS.addListener(this::renderTick);
        MinecraftForge.EVENT_BUS.addListener(this::clientTick);
    }

    public void renderTick(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableCull();
            Tesselator tesselator = Tesselator.m_85913_();
            RenderSystem.setShader(GameRenderer::m_172811_);
            PoseStack poseStack = event.getPoseStack();
            Camera camera = event.getCamera();
            Vec3 pos = camera.m_90583_();
            while (!itemsToAdd.isEmpty()) {
                DebugRenderItem item = itemsToAdd.poll();
                renderItems.add(item);
            }
            for (int i = 0; i < renderItems.size(); ++i) {
                DebugRenderItem item = renderItems.get(i);
                poseStack.m_85836_();
                poseStack.m_85837_(item.transform.Position.x - pos.f_82479_, item.transform.Position.y - pos.f_82480_, item.transform.Position.z - pos.f_82481_);
                poseStack.m_252781_(item.transform.Orientation);
                item.render(poseStack, tesselator);
                poseStack.m_85849_();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
        }
    }

    public void clientTick(TickEvent.ClientTickEvent event) {
        for (int i = renderItems.size() - 1; i >= 0; --i) {
            if (--DebugRenderer.renderItems.get((int)i).ticksLeft > 0) continue;
            renderItems.remove(i);
        }
    }

    private static class DebugRenderCube
    extends DebugRenderItem {
        public Vector3f halfExtents;
        private static int[] BoxTriangles = new int[]{0, 1, 3, 0, 3, 2, 4, 7, 5, 4, 6, 7, 0, 2, 6, 0, 6, 4, 1, 7, 3, 1, 5, 7, 0, 1, 5, 0, 5, 4, 2, 7, 3, 2, 6, 7};

        public DebugRenderCube(Transform t, int ticks, Vector4f col, Vector3f h) {
            super(t, ticks, col);
            this.halfExtents = h;
        }

        @Override
        public void render(PoseStack poseStack, Tesselator tesselator) {
            BufferBuilder buf = tesselator.m_85915_();
            Vector3f[] verts = new Vector3f[8];
            for (int x = 0; x < 2; ++x) {
                for (int y = 0; y < 2; ++y) {
                    for (int z = 0; z < 2; ++z) {
                        verts[z * 4 + y * 2 + x] = new Vector3f((float)(x * 2 - 1) * this.halfExtents.x, (float)(y * 2 - 1) * this.halfExtents.y, (float)(z * 2 - 1) * this.halfExtents.z);
                    }
                }
            }
            buf.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[0].x, verts[0].y, verts[0].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[1].x, verts[1].y, verts[1].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[5].x, verts[5].y, verts[5].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[1].x, verts[1].y, verts[1].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[3].x, verts[3].y, verts[3].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[7].x, verts[7].y, verts[7].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[3].x, verts[3].y, verts[3].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[2].x, verts[2].y, verts[2].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[6].x, verts[6].y, verts[6].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[2].x, verts[2].y, verts[2].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[0].x, verts[0].y, verts[0].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[4].x, verts[4].y, verts[4].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[5].x, verts[5].y, verts[5].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[7].x, verts[7].y, verts[7].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[6].x, verts[6].y, verts[6].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), verts[4].x, verts[4].y, verts[4].z).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            tesselator.m_85914_();
        }
    }

    private static class DebugRenderPoint
    extends DebugRenderItem {
        private static final int NUM_SEGMENTS = 16;
        private static final float RADIUS = 0.04f;
        private static final float RADS_PER_SEGMENT = 0.3926991f;

        public DebugRenderPoint(Transform t, int ticks, Vector4f col) {
            super(t, ticks, col);
        }

        @Override
        public void render(PoseStack poseStack, Tesselator tesselator) {
            if (MinecraftHelpers.getCamera() == null) {
                return;
            }
            Vec3 toCamera = MinecraftHelpers.getCamera().m_20156_().m_82541_();
            Vec3 verticalAxis = MinecraftHelpers.getCamera().m_20289_(0.0f).m_82541_();
            Vec3 lateralAxis = Maths.cross(toCamera, verticalAxis).m_82541_();
            BufferBuilder buf = tesselator.m_85915_();
            buf.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            buf.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, 0.0f, 0.0f).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            for (int i = 0; i <= 16; ++i) {
                Vec3 pos = lateralAxis.m_82490_((double)(0.04f * Maths.sinF((float)i * 0.3926991f)));
                pos = pos.m_82549_(verticalAxis.m_82490_((double)(0.04f * Maths.cosF((float)i * 0.3926991f))));
                buf.m_252986_(poseStack.m_85850_().m_252922_(), (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_).m_85950_(this.colour.x, this.colour.y, this.colour.z, 1.0f).m_5752_();
            }
            tesselator.m_85914_();
        }
    }

    private static class DebugRenderLine
    extends DebugRenderItem {
        public Vec3 direction;
        public boolean Arrow;

        public DebugRenderLine(Transform t, int ticks, Vector4f col, Vec3 dir, boolean arrow) {
            super(t, ticks, col);
            this.direction = dir;
            this.Arrow = arrow;
        }

        protected void renderLineSegment(PoseStack poseStack, Tesselator tesselator, Vec3 start, Vec3 ray, Vector4f col, boolean asArrow) {
            BufferBuilder buf = tesselator.m_85915_();
            buf.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
            Vec3 center = new Vec3(start.f_82479_ + ray.f_82479_ * 0.5, start.f_82480_ + ray.f_82480_ * 0.5, start.f_82481_ + ray.f_82481_ * 0.5);
            Vector3f centerInModelSpace = poseStack.m_85850_().m_252922_().transformPosition(center.m_252839_());
            Vector3f rayInModelSpace = poseStack.m_85850_().m_252922_().transformDirection(ray.m_252839_());
            centerInModelSpace.normalize();
            rayInModelSpace.normalize();
            Vector3f lateralAxis = centerInModelSpace.cross((Vector3fc)rayInModelSpace, new Vector3f());
            lateralAxis.normalize();
            lateralAxis.mul(0.02f);
            lateralAxis.mulTransposeDirection((Matrix4fc)poseStack.m_85850_().m_252922_());
            Vec3 v0 = start;
            Vector3f vAxis = ray.m_252839_();
            Vector3f uAxis = lateralAxis;
            BiConsumer<Float, Float> vertexFunc = (u, v) -> buf.m_252986_(poseStack.m_85850_().m_252922_(), (float)(v0.f_82479_ + (double)(uAxis.x * u.floatValue()) + (double)(vAxis.x * v.floatValue())), (float)(v0.f_82480_ + (double)(uAxis.y * u.floatValue()) + (double)(vAxis.y * v.floatValue())), (float)(v0.f_82481_ + (double)(uAxis.z * u.floatValue()) + (double)(vAxis.z * v.floatValue()))).m_85950_(col.x, col.y, col.z, col.w).m_5752_();
            if (asArrow) {
                vertexFunc.accept(Float.valueOf(1.0f), Float.valueOf(0.0f));
                vertexFunc.accept(Float.valueOf(-1.0f), Float.valueOf(0.0f));
                vertexFunc.accept(Float.valueOf(-1.0f), Float.valueOf(0.9f));
                vertexFunc.accept(Float.valueOf(1.0f), Float.valueOf(0.0f));
                vertexFunc.accept(Float.valueOf(-1.0f), Float.valueOf(0.9f));
                vertexFunc.accept(Float.valueOf(1.0f), Float.valueOf(0.9f));
                vertexFunc.accept(Float.valueOf(4.0f), Float.valueOf(0.9f));
                vertexFunc.accept(Float.valueOf(-4.0f), Float.valueOf(0.9f));
                vertexFunc.accept(Float.valueOf(0.0f), Float.valueOf(1.0f));
            } else {
                vertexFunc.accept(Float.valueOf(1.0f), Float.valueOf(0.0f));
                vertexFunc.accept(Float.valueOf(-1.0f), Float.valueOf(0.0f));
                vertexFunc.accept(Float.valueOf(-1.0f), Float.valueOf(1.0f));
                vertexFunc.accept(Float.valueOf(1.0f), Float.valueOf(0.0f));
                vertexFunc.accept(Float.valueOf(-1.0f), Float.valueOf(1.0f));
                vertexFunc.accept(Float.valueOf(1.0f), Float.valueOf(1.0f));
            }
            tesselator.m_85914_();
        }

        @Override
        public void render(PoseStack poseStack, Tesselator tesselator) {
            if (MinecraftHelpers.getCamera() == null) {
                return;
            }
            this.renderLineSegment(poseStack, tesselator, Vec3.f_82478_, this.direction, this.colour, this.Arrow);
        }
    }

    private static class DebugRenderRotation
    extends DebugRenderLine {
        private final double RADIUS = 0.5;
        private final int NUM_SEGMENTS = 10;
        private final double RADS_PER_SEGMENT = 0.6283185307179586;
        public final double Magnitude;

        public DebugRenderRotation(Transform t, int ticks, Vector4f col, Vec3 dir, double mag, boolean arrow) {
            super(t, ticks, col, dir, arrow);
            this.Magnitude = mag;
        }

        @Override
        public void render(PoseStack poseStack, Tesselator tesselator) {
            if (MinecraftHelpers.getCamera() == null) {
                return;
            }
            Vec3 from = this.getPoint(0);
            Vec3 to = this.getPoint(1);
            for (int i = 1; i < 11; ++i) {
                this.renderLineSegment(poseStack, tesselator, from, to.m_82546_(from), this.colour, i == 10);
                from = to;
                to = this.getPoint(i + 1);
            }
        }

        private Vec3 getPoint(int index) {
            AxisAngle4d axisAngle = new AxisAngle4d(this.Magnitude * (double)index * 0.6283185307179586, this.direction.f_82479_, this.direction.f_82480_, this.direction.f_82481_);
            Vector3d sweepVec = new Vector3d(this.direction.f_82479_, this.direction.f_82480_, this.direction.f_82481_);
            sweepVec.cross((Vector3dc)new Vector3d(0.0, 1.0, 0.0));
            sweepVec.normalize();
            sweepVec.normalize(0.5);
            axisAngle.transform(sweepVec);
            return new Vec3(sweepVec.x, sweepVec.y, sweepVec.z);
        }
    }

    private static class DebugRenderAxes
    extends DebugRenderLine {
        public DebugRenderAxes(Transform t, int ticks, Vector4f col) {
            super(t, ticks, col, t.forward(), false);
        }

        @Override
        public void render(PoseStack poseStack, Tesselator tesselator) {
            if (MinecraftHelpers.getCamera() == null) {
                return;
            }
            this.renderLineSegment(poseStack, tesselator, Vec3.f_82478_, this.transform.forward(), new Vector4f(1.0f, 0.0f, 0.0f, 1.0f), false);
            this.renderLineSegment(poseStack, tesselator, Vec3.f_82478_, this.transform.up(), new Vector4f(0.0f, 1.0f, 0.0f, 1.0f), false);
            this.renderLineSegment(poseStack, tesselator, Vec3.f_82478_, this.transform.right(), new Vector4f(0.0f, 0.0f, 1.0f, 1.0f), false);
        }
    }

    private static abstract class DebugRenderItem {
        public Transform transform;
        public int ticksLeft;
        public Vector4f colour;

        public DebugRenderItem(Transform t, int ticks, Vector4f col) {
            this.transform = t;
            this.ticksLeft = ticks;
            this.colour = col;
        }

        public abstract void render(PoseStack var1, Tesselator var2);
    }
}

