/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.teams;

import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.teams.elements.LevelUpDefinition;
import com.flansmod.common.types.teams.elements.LoadoutChoiceDefinition;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;

public class LoadoutPoolDefinition
extends JsonDefinition {
    public static final LoadoutPoolDefinition INVALID = new LoadoutPoolDefinition(new ResourceLocation("flansmod", "loadout_pools/null"));
    public static final String TYPE = "loadout_pool";
    public static final String FOLDER = "loadout_pools";
    @JsonField
    public int maxLevel = 20;
    @JsonField
    public int xpForKill = 10;
    @JsonField
    public int xpForDeath = 5;
    @JsonField
    public int xpForKillstreakBonus = 10;
    @JsonField
    public int xpForAssist = 5;
    @JsonField
    public int xpForMultikill = 10;
    @JsonField
    public String[] availableRewardBoxes = new String[0];
    @JsonField(Docs="Level 0 will be unlocked automatically. Put starter gear in there.")
    public LevelUpDefinition[] levelUps = new LevelUpDefinition[0];
    @JsonField
    public LoadoutChoiceDefinition[] choices = new LoadoutChoiceDefinition[0];
    private Map<String, LoadoutChoiceDefinition> SortedChoices = null;

    @Override
    public String GetTypeName() {
        return TYPE;
    }

    public LoadoutPoolDefinition(ResourceLocation resLoc) {
        super(resLoc);
    }

    public void addDefaultChoices(@Nonnull Map<String, Integer> choiceMap) {
        for (LoadoutChoiceDefinition choice : this.choices) {
            if (!choice.selectionMandatory) continue;
            choiceMap.put(choice.choiceName, 0);
        }
    }

    @Nonnull
    public Map<String, LoadoutChoiceDefinition> getSortedChoices() {
        if (this.SortedChoices == null) {
            this.SortedChoices = new HashMap<String, LoadoutChoiceDefinition>();
            for (LoadoutChoiceDefinition choice : this.choices) {
                this.SortedChoices.put(choice.choiceName, choice);
            }
        }
        return this.SortedChoices;
    }
}

