/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.guns.elements;

import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.guns.elements.EReloadStage;
import javax.annotation.Nonnull;

public class ReloadDefinition {
    @JsonField(Docs="This should match the action group key")
    public String key = "primary";
    @JsonField(Docs="If true, the player can press [R] to reload manually")
    public boolean manualReloadAllowed = true;
    @JsonField(Docs="If true, attempting to fire on empty will trigger a reload")
    public boolean autoReloadWhenEmpty = true;
    @JsonField
    public String startActionKey = "primary_reload_start";
    @JsonField
    public String ejectActionKey = "primary_reload_eject";
    @JsonField
    public String loadOneActionKey = "primary_reload_load_one";
    @JsonField
    public String endActionKey = "primary_reload_end";

    public boolean Contains(String actionGroupPath) {
        return this.startActionKey.length() > 0 && actionGroupPath.contains(this.startActionKey) || this.ejectActionKey.length() > 0 && actionGroupPath.contains(this.ejectActionKey) || this.loadOneActionKey.length() > 0 && actionGroupPath.contains(this.loadOneActionKey) || this.endActionKey.length() > 0 && actionGroupPath.contains(this.endActionKey);
    }

    public EReloadStage GetStage(String actionGroupPath) {
        if (this.startActionKey.length() > 0 && actionGroupPath.contains(this.startActionKey)) {
            return EReloadStage.Start;
        }
        if (this.ejectActionKey.length() > 0 && actionGroupPath.contains(this.ejectActionKey)) {
            return EReloadStage.Eject;
        }
        if (this.loadOneActionKey.length() > 0 && actionGroupPath.contains(this.loadOneActionKey)) {
            return EReloadStage.LoadOne;
        }
        if (this.endActionKey.length() > 0 && actionGroupPath.contains(this.endActionKey)) {
            return EReloadStage.End;
        }
        return null;
    }

    @Nonnull
    public String GetReloadActionKey(EReloadStage stage) {
        switch (stage) {
            case Start: {
                return this.startActionKey;
            }
            case Eject: {
                return this.ejectActionKey;
            }
            case LoadOne: {
                return this.loadOneActionKey;
            }
            case End: {
                return this.endActionKey;
            }
        }
        return "";
    }
}

