/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.guns.elements;

import com.flansmod.common.actions.contexts.TargetsContext;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.abilities.elements.AbilityEffectDefinition;
import com.flansmod.common.types.abilities.elements.AbilityStackingDefinition;
import com.flansmod.common.types.abilities.elements.AbilityTargetDefinition;
import com.flansmod.common.types.abilities.elements.AbilityTriggerDefinition;
import com.flansmod.common.types.abilities.elements.EAbilityTrigger;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;

public class AbilityDefinition {
    @JsonField
    public AbilityTriggerDefinition[] startTriggers = new AbilityTriggerDefinition[0];
    @JsonField
    public AbilityTriggerDefinition[] endTriggers = new AbilityTriggerDefinition[0];
    @JsonField
    public AbilityTargetDefinition[] targets = new AbilityTargetDefinition[0];
    @JsonField
    public AbilityEffectDefinition[] effects = new AbilityEffectDefinition[0];
    @JsonField
    public AbilityStackingDefinition stacking = new AbilityStackingDefinition();

    public boolean IsValid() {
        return this.startTriggers.length > 0 && this.targets.length > 0 && this.effects.length > 0;
    }

    public boolean IsStackable() {
        return this.stacking.IsStackable();
    }

    public boolean MatchTrigger(@Nonnull EAbilityTrigger checkTriggerType, @Nonnull TriggerContext triggerContext) {
        for (AbilityTriggerDefinition triggerDef : this.startTriggers) {
            if (!triggerDef.Matches(checkTriggerType, triggerContext)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public TargetsContext MatchTargets(@Nonnull TriggerContext triggerContext) {
        TargetsContext targetsContext = new TargetsContext();
        for (AbilityTargetDefinition targetDef : this.targets) {
            targetDef.ApplyTo(triggerContext, targetsContext);
        }
        return targetsContext;
    }

    @Nonnull
    public Component GetTriggerTooltip(boolean expanded) {
        Component fromComponent;
        Component[] startTriggerTooltips = new Component[this.startTriggers.length];
        for (int i = 0; i < this.startTriggers.length; ++i) {
            startTriggerTooltips[i] = this.startTriggers[i].GetTooltip(expanded);
        }
        Component triggerComponent = fromComponent = FlanItem.ListOf(startTriggerTooltips);
        if (this.endTriggers.length > 0) {
            Component[] endTriggerTooltips = new Component[this.endTriggers.length];
            for (int i = 0; i < this.endTriggers.length; ++i) {
                endTriggerTooltips[i] = this.endTriggers[i].GetTooltip(expanded);
            }
            Component toComponent = FlanItem.ListOf(endTriggerTooltips);
            triggerComponent = Component.m_237110_((String)"trigger.expanded.to_from", (Object[])new Object[]{fromComponent, toComponent});
        }
        return triggerComponent;
    }

    @Nonnull
    public Component GetTargetTooltip(boolean expanded) {
        Component[] targetTooltips = new Component[this.targets.length];
        for (int i = 0; i < this.targets.length; ++i) {
            targetTooltips[i] = this.targets[i].GetTooltip(expanded);
        }
        return FlanItem.ListOf(targetTooltips);
    }

    @Nonnull
    public Component GetEffectTooltip(boolean expanded) {
        Component[] effectTooltips = new Component[this.effects.length];
        for (int i = 0; i < this.effects.length; ++i) {
            effectTooltips[i] = this.effects[i].GetTooltip(expanded);
        }
        return FlanItem.ListOf(effectTooltips);
    }

    @Nonnull
    public Component GetTooltip(boolean expanded) {
        Component triggers = this.GetTriggerTooltip(expanded);
        Component targets = this.GetTargetTooltip(expanded);
        Component effects = this.GetEffectTooltip(expanded);
        return Component.m_237110_((String)(expanded ? "trigger.compose.expanded" : "trigger.compose.icon"), (Object[])new Object[]{triggers, targets, effects});
    }
}

