/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.crafting.elements;

import com.flansmod.common.FlansMod;
import com.flansmod.common.crafting.recipes.PartFabricationRecipe;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.elements.ItemCollectionDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class PartCraftingDefinition {
    @JsonField
    public boolean isActive = false;
    @JsonField
    public int inputSlots = 8;
    @JsonField
    public int outputSlots = 8;
    @JsonField(Docs="In seconds")
    public float timePerCraft = 1.0f;
    @JsonField
    public float FECostPerCraft = 0.0f;
    @JsonField
    public ItemCollectionDefinition craftableParts = new ItemCollectionDefinition();
    private final HashMap<Level, List<PartFabricationRecipe>> RecipeCaches = new HashMap();

    @Nonnull
    public List<ItemStack> GetAllOutputs() {
        return this.craftableParts.GetItemMatches();
    }

    @Nonnull
    public List<PartFabricationRecipe> GetAllRecipes(Level level) {
        List<ItemStack> allOutputs = this.GetAllOutputs();
        if (!this.RecipeCaches.containsKey(level)) {
            ArrayList<PartFabricationRecipe> recipeCache = new ArrayList<PartFabricationRecipe>();
            if (level != null) {
                List allRecipes = level.m_7465_().m_44013_((RecipeType)FlansMod.PART_FABRICATION_RECIPE_TYPE.get());
                for (PartFabricationRecipe recipe : allRecipes) {
                    boolean allowed = false;
                    for (ItemStack validOutput : allOutputs) {
                        if (!ItemStack.m_41656_((ItemStack)validOutput, (ItemStack)recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_))) continue;
                        allowed = true;
                    }
                    if (!allowed) continue;
                    recipeCache.add(recipe);
                }
            }
            recipeCache.sort((o1, o2) -> {
                String hash2;
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                String hash1 = o1.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41720_().m_204114_().m_205785_().m_135782_().toString();
                int outputComparison = hash1.compareTo(hash2 = o2.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41720_().m_204114_().m_205785_().m_135782_().toString());
                if (outputComparison != 0) {
                    return outputComparison;
                }
                return o1.m_6423_().compareTo(o2.m_6423_());
            });
            this.RecipeCaches.put(level, recipeCache);
        }
        return this.RecipeCaches.get(level);
    }
}

