/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.crafting;

import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.crafting.EMaterialType;
import com.flansmod.common.types.elements.MaterialSourceDefinition;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class MaterialDefinition
extends JsonDefinition {
    public static final MaterialDefinition INVALID = new MaterialDefinition(new ResourceLocation("flansmod", "materials/null"));
    public static final String TYPE = "material";
    public static final String FOLDER = "materials";
    @JsonField
    public MaterialSourceDefinition[] sources = new MaterialSourceDefinition[0];
    @JsonField
    public int craftingTier = 1;
    @JsonField
    public EMaterialType materialType = EMaterialType.Misc;
    private List<MaterialSourceDefinition> SortedByValue = null;

    @Override
    public String GetTypeName() {
        return TYPE;
    }

    public MaterialDefinition(ResourceLocation resLoc) {
        super(resLoc);
    }

    public List<MaterialSourceDefinition> GetSortedByValue() {
        if (this.SortedByValue == null) {
            this.SortedByValue = new ArrayList<MaterialSourceDefinition>(this.sources.length);
            this.SortedByValue.addAll(Arrays.asList(this.sources));
            this.SortedByValue.sort(Comparator.comparingInt(a -> a.count));
        }
        return this.SortedByValue;
    }

    public List<Pair<MaterialSourceDefinition, Integer>> ResolveAmount(int count) {
        ArrayList<Pair<MaterialSourceDefinition, Integer>> list = new ArrayList<Pair<MaterialSourceDefinition, Integer>>(this.sources.length);
        List<MaterialSourceDefinition> sortedSources = this.GetSortedByValue();
        for (int i = sortedSources.size() - 1; i >= 0; --i) {
            int numOfType = count / sortedSources.get((int)i).count;
            if (numOfType <= 0) continue;
            list.add((Pair<MaterialSourceDefinition, Integer>)Pair.of((Object)sortedSources.get(i), (Object)numOfType));
            count -= numOfType * sortedSources.get((int)i).count;
        }
        return list;
    }

    public String GenerateString(int count) {
        List<MaterialSourceDefinition> sortedSources = this.GetSortedByValue();
        if (sortedSources.size() == 0) {
            return "0";
        }
        if (count == 0) {
            return "0" + sortedSources.get((int)0).icon.GetIcon();
        }
        StringBuilder builder = new StringBuilder();
        for (int i = sortedSources.size() - 1; i >= 0; --i) {
            int numOfType = count / sortedSources.get((int)i).count;
            if (numOfType <= 0) continue;
            builder.append(numOfType);
            builder.append(sortedSources.get((int)i).icon.GetIcon());
            if (i <= 0 || (count -= numOfType * sortedSources.get((int)i).count) <= 0) continue;
            builder.append(" ");
        }
        return builder.toString();
    }
}

