/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.attachments;

import javax.annotation.Nonnull;

public enum EAttachmentType {
    Barrel,
    Sights,
    Stock,
    Grip,
    Generic,
    Tool,
    Arm,
    Leg,
    Head,
    Shoulder,
    Feet,
    Hips,
    Charm;


    public static EAttachmentType Parse(String attachType) {
        return switch (attachType.toLowerCase()) {
            case "barrel" -> Barrel;
            case "sights" -> Sights;
            case "stock" -> Stock;
            case "grip" -> Grip;
            case "tool" -> Tool;
            case "arm" -> Arm;
            case "leg" -> Leg;
            case "head" -> Head;
            case "shoulder" -> Shoulder;
            case "feet" -> Feet;
            case "hips" -> Hips;
            case "charm" -> Charm;
            default -> Generic;
        };
    }

    @Nonnull
    public String indexedName(int index) {
        return this.name().toLowerCase() + "_" + index;
    }

    @Nonnull
    public String unindexedName(int index) {
        return index == 0 ? this.name().toLowerCase() : this.indexedName(index);
    }
}

