/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.entity.vehicle.PerPartMap;
import com.flansmod.common.entity.vehicle.save.ArticulationSyncState;
import com.flansmod.common.entity.vehicle.save.DamageSyncState;
import com.flansmod.common.entity.vehicle.save.EngineSyncState;
import com.flansmod.common.entity.vehicle.save.GunSyncState;
import com.flansmod.common.entity.vehicle.save.SeatSyncState;
import com.flansmod.common.entity.vehicle.save.WheelSyncState;
import com.flansmod.common.types.Definitions;
import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.abilities.CraftingTraitDefinition;
import com.flansmod.common.types.armour.ArmourDefinition;
import com.flansmod.common.types.attachments.AttachmentDefinition;
import com.flansmod.common.types.bullets.BulletDefinition;
import com.flansmod.common.types.crafting.MaterialDefinition;
import com.flansmod.common.types.crafting.WorkbenchDefinition;
import com.flansmod.common.types.grenades.GrenadeDefinition;
import com.flansmod.common.types.guns.GunDefinition;
import com.flansmod.common.types.magazines.MagazineDefinition;
import com.flansmod.common.types.npc.NpcDefinition;
import com.flansmod.common.types.parts.PartDefinition;
import com.flansmod.common.types.vehicles.ControlSchemeDefinition;
import com.flansmod.common.types.vehicles.VehicleDefinition;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;

public class FlansEntityDataSerializers {
    public static final DefinitionSerializer<GunDefinition> GUN_DEF = new DefinitionSerializer<GunDefinition>(FlansMod.GUNS);
    public static final DefinitionSerializer<BulletDefinition> BULLET_DEF = new DefinitionSerializer<BulletDefinition>(FlansMod.BULLETS);
    public static final DefinitionSerializer<GrenadeDefinition> GRENADE_DEF = new DefinitionSerializer<GrenadeDefinition>(FlansMod.GRENADES);
    public static final DefinitionSerializer<AttachmentDefinition> ATTACHMENT_DEF = new DefinitionSerializer<AttachmentDefinition>(FlansMod.ATTACHMENTS);
    public static final DefinitionSerializer<PartDefinition> PART_DEF = new DefinitionSerializer<PartDefinition>(FlansMod.PARTS);
    public static final DefinitionSerializer<WorkbenchDefinition> WORKBENCH_DEF = new DefinitionSerializer<WorkbenchDefinition>(FlansMod.WORKBENCHES);
    public static final DefinitionSerializer<MaterialDefinition> MATERIAL_DEF = new DefinitionSerializer<MaterialDefinition>(FlansMod.MATERIALS);
    public static final DefinitionSerializer<MagazineDefinition> MAGAZINE_DEF = new DefinitionSerializer<MagazineDefinition>(FlansMod.MAGAZINES);
    public static final DefinitionSerializer<NpcDefinition> NPC_DEF = new DefinitionSerializer<NpcDefinition>(FlansMod.NPCS);
    public static final DefinitionSerializer<CraftingTraitDefinition> TRAIT_DEF = new DefinitionSerializer<CraftingTraitDefinition>(FlansMod.TRAITS);
    public static final DefinitionSerializer<ArmourDefinition> ARMOUR_DEF = new DefinitionSerializer<ArmourDefinition>(FlansMod.ARMOURS);
    public static final DefinitionSerializer<VehicleDefinition> VEHICLE_DEF = new DefinitionSerializer<VehicleDefinition>(FlansMod.VEHICLES);
    public static final DefinitionSerializer<ControlSchemeDefinition> CONTROL_SCHEME_DEF = new DefinitionSerializer<ControlSchemeDefinition>(FlansMod.CONTROL_SCHEMES);
    public static final EntityDataSerializer<ArticulationSyncState> ARTICULATION = new EntityDataSerializer.ForValueType<ArticulationSyncState>(){

        public void write(@Nonnull FriendlyByteBuf buf, @Nonnull ArticulationSyncState data) {
            buf.writeFloat(data.Parameter);
            buf.writeFloat(data.Velocity);
        }

        @Nonnull
        public ArticulationSyncState read(@Nonnull FriendlyByteBuf buf) {
            float param = buf.readFloat();
            float velocity = buf.readFloat();
            return new ArticulationSyncState(param, velocity);
        }
    };
    public static final EntityDataSerializer<EngineSyncState> ENGINE = new EntityDataSerializer.ForValueType<EngineSyncState>(){

        public void write(@Nonnull FriendlyByteBuf buf, @Nonnull EngineSyncState data) {
            buf.writeInt(data.BurnTimeDuration);
            buf.writeInt(data.BurnTimeRemaining);
        }

        @Nonnull
        public EngineSyncState read(@Nonnull FriendlyByteBuf buf) {
            EngineSyncState state = new EngineSyncState();
            state.BurnTimeDuration = buf.readInt();
            state.BurnTimeRemaining = buf.readInt();
            return state;
        }
    };
    public static final EntityDataSerializer<SeatSyncState> SEAT = new EntityDataSerializer.ForValueType<SeatSyncState>(){

        public void write(@Nonnull FriendlyByteBuf buf, @Nonnull SeatSyncState data) {
            buf.m_130077_(data.PassengerID);
        }

        @Nonnull
        public SeatSyncState read(@Nonnull FriendlyByteBuf buf) {
            SeatSyncState state = new SeatSyncState();
            state.PassengerID = buf.m_130259_();
            return state;
        }
    };
    public static EntityDataSerializer<DamageSyncState> DAMAGE = new EntityDataSerializer.ForValueType<DamageSyncState>(){

        public void write(@Nonnull FriendlyByteBuf buf, @Nonnull DamageSyncState data) {
            EntityDataSerializers.f_135029_.m_6856_(buf, (Object)Float.valueOf(data.Health()));
        }

        @Nonnull
        public DamageSyncState read(@Nonnull FriendlyByteBuf buf) {
            return new DamageSyncState(((Float)EntityDataSerializers.f_135029_.m_6709_(buf)).floatValue());
        }
    };
    public static final EntityDataSerializer<GunSyncState> GUN = new EntityDataSerializer.ForValueType<GunSyncState>(){

        public void write(@Nonnull FriendlyByteBuf buf, @Nonnull GunSyncState data) {
            buf.writeItemStack(data.GunStack, false);
        }

        @Nonnull
        public GunSyncState read(@Nonnull FriendlyByteBuf buf) {
            GunSyncState state = new GunSyncState();
            state.GunStack = buf.m_130267_();
            return state;
        }
    };
    public static final EntityDataSerializer<WheelSyncState> WHEEL = new EntityDataSerializer.ForValueType<WheelSyncState>(){

        public void write(@Nonnull FriendlyByteBuf buf, @Nonnull WheelSyncState data) {
        }

        @Nonnull
        public WheelSyncState read(@Nonnull FriendlyByteBuf buf) {
            WheelSyncState state = new WheelSyncState();
            return state;
        }
    };
    public static final EntityDataSerializer<PerPartMap<ArticulationSyncState>> ARTICULATION_MAP = new PerPartMapSerializer<ArticulationSyncState>(ARTICULATION);
    public static final EntityDataSerializer<PerPartMap<EngineSyncState>> ENGINE_MAP = new PerPartMapSerializer<EngineSyncState>(ENGINE);
    public static final EntityDataSerializer<PerPartMap<SeatSyncState>> SEAT_MAP = new PerPartMapSerializer<SeatSyncState>(SEAT);
    public static final EntityDataSerializer<PerPartMap<DamageSyncState>> DAMAGE_MAP = new PerPartMapSerializer<DamageSyncState>(DAMAGE);
    public static final EntityDataSerializer<PerPartMap<GunSyncState>> GUN_MAP = new PerPartMapSerializer<GunSyncState>(GUN);
    public static final EntityDataSerializer<PerPartMap<WheelSyncState>> WHEEL_MAP = new PerPartMapSerializer<WheelSyncState>(WHEEL);

    public static void RegisterSerializers() {
        EntityDataSerializers.m_135050_(GUN_DEF);
        EntityDataSerializers.m_135050_(BULLET_DEF);
        EntityDataSerializers.m_135050_(GRENADE_DEF);
        EntityDataSerializers.m_135050_(ATTACHMENT_DEF);
        EntityDataSerializers.m_135050_(PART_DEF);
        EntityDataSerializers.m_135050_(WORKBENCH_DEF);
        EntityDataSerializers.m_135050_(MATERIAL_DEF);
        EntityDataSerializers.m_135050_(MAGAZINE_DEF);
        EntityDataSerializers.m_135050_(NPC_DEF);
        EntityDataSerializers.m_135050_(TRAIT_DEF);
        EntityDataSerializers.m_135050_(ARMOUR_DEF);
        EntityDataSerializers.m_135050_(VEHICLE_DEF);
        EntityDataSerializers.m_135050_(CONTROL_SCHEME_DEF);
        EntityDataSerializers.m_135050_(ARTICULATION);
        EntityDataSerializers.m_135050_(ENGINE);
        EntityDataSerializers.m_135050_(SEAT);
        EntityDataSerializers.m_135050_(DAMAGE);
        EntityDataSerializers.m_135050_(GUN);
        EntityDataSerializers.m_135050_(WHEEL);
        EntityDataSerializers.m_135050_(ARTICULATION_MAP);
        EntityDataSerializers.m_135050_(ENGINE_MAP);
        EntityDataSerializers.m_135050_(SEAT_MAP);
        EntityDataSerializers.m_135050_(DAMAGE_MAP);
        EntityDataSerializers.m_135050_(GUN_MAP);
        EntityDataSerializers.m_135050_(WHEEL_MAP);
    }

    public static class DefinitionSerializer<TDefType extends JsonDefinition>
    implements EntityDataSerializer.ForValueType<TDefType> {
        public final Definitions<TDefType> Library;

        public DefinitionSerializer(@Nonnull Definitions<TDefType> lib) {
            this.Library = lib;
        }

        public void write(@Nonnull FriendlyByteBuf buf, @Nonnull TDefType def) {
            buf.writeInt(((JsonDefinition)def).hashCode());
        }

        @Nonnull
        public TDefType read(@Nonnull FriendlyByteBuf buf) {
            return this.Library.ByHash(buf.readInt());
        }
    }

    public static class PerPartMapSerializer<TDataType>
    implements EntityDataSerializer.ForValueType<PerPartMap<TDataType>> {
        public final EntityDataSerializer<TDataType> ElementSerializer;

        public PerPartMapSerializer(@Nonnull EntityDataSerializer<TDataType> element) {
            this.ElementSerializer = element;
        }

        public void write(@Nonnull FriendlyByteBuf buf, @Nonnull PerPartMap<TDataType> data) {
            buf.writeInt(data.Values().size());
            for (Map.Entry<Integer, TDataType> kvp : data.EntrySet()) {
                buf.writeInt(kvp.getKey().intValue());
                this.ElementSerializer.m_6856_(buf, kvp.getValue());
            }
        }

        @Nonnull
        public PerPartMap<TDataType> read(@Nonnull FriendlyByteBuf buf) {
            int numEntries = buf.readInt();
            PerPartMap<Object> map = new PerPartMap<Object>();
            for (int i = 0; i < numEntries; ++i) {
                int hash = buf.readInt();
                Object element = this.ElementSerializer.m_6709_(buf);
                map.Put(hash, element);
            }
            return map;
        }
    }
}

