/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.item;

import com.flansmod.api.IAmmoItem;
import com.flansmod.client.render.bullets.BulletItemClientExtension;
import com.flansmod.common.FlansMod;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.types.bullets.BulletDefinition;
import com.flansmod.common.types.guns.elements.AbilityDefinition;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.extensions.IForgeItem;

public class BulletItem
extends FlanItem
implements IForgeItem,
IAmmoItem {
    @Override
    public BulletDefinition Def() {
        return (BulletDefinition)FlansMod.BULLETS.Get(this.DefinitionLocation);
    }

    public BulletItem(@Nonnull ResourceLocation defLoc, @Nonnull Item.Properties properties) {
        super(defLoc, properties);
    }

    @Override
    public boolean CanBeCraftedFromParts() {
        return false;
    }

    @Override
    public boolean ShouldRenderAsIcon(@Nonnull ItemDisplayContext transformType) {
        return true;
    }

    public boolean isDamageable(ItemStack stack) {
        return this.Def().GetItemDurability() > 0;
    }

    public boolean m_41465_() {
        return this.Def().GetItemDurability() > 0;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.Def().GetItemDurability();
    }

    public int getMaxStackSize(ItemStack stack) {
        if (stack.m_41773_() == 0) {
            return this.Def().GetMaxStackSize();
        }
        return 1;
    }

    @Override
    @Nonnull
    public ItemStack provideAny(@Nonnull ItemStack fromStack) {
        return fromStack.m_41620_(1);
    }

    @Override
    public boolean matchesTags(@Nonnull ItemStack fromStack, @Nonnull List<TagKey<Item>> matchTags) {
        for (TagKey<Item> tag : matchTags) {
            if (!fromStack.m_204117_(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public ItemStack provideForTags(@Nonnull ItemStack fromStack, @Nonnull List<TagKey<Item>> matchTags) {
        for (TagKey<Item> tag : matchTags) {
            if (!fromStack.m_204117_(tag)) continue;
            return fromStack.m_41620_(1);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean matchesIDs(@Nonnull ItemStack fromStack, @Nonnull List<ResourceLocation> matchIDs) {
        return matchIDs.contains(this.DefinitionLocation);
    }

    @Override
    @Nonnull
    public ItemStack provideForIDs(@Nonnull ItemStack fromStack, @Nonnull List<ResourceLocation> matchIDs) {
        if (matchIDs.contains(this.DefinitionLocation)) {
            return fromStack.m_41620_(1);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8120_(ItemStack i) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(BulletItemClientExtension.of(this));
    }

    @Override
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltips, @Nonnull TooltipFlag flags) {
        super.m_7373_(stack, level, tooltips, flags);
        boolean expanded = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340);
        BulletDefinition def = this.Def();
        if (def.IsValid()) {
            for (AbilityDefinition ability : def.triggers) {
                tooltips.add(ability.GetTooltip(expanded));
            }
        }
    }
}

