/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.item;

import com.flansmod.client.render.guns.AttachmentItemClientExtension;
import com.flansmod.common.FlansMod;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.types.abilities.CraftingTraitDefinition;
import com.flansmod.common.types.abilities.elements.CraftingTraitProviderDefinition;
import com.flansmod.common.types.attachments.AttachmentDefinition;
import com.flansmod.common.types.elements.ModifierDefinition;
import com.flansmod.common.types.guns.elements.HandlerDefinition;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class AttachmentItem
extends FlanItem {
    @Override
    public AttachmentDefinition Def() {
        return (AttachmentDefinition)FlansMod.ATTACHMENTS.Get(this.DefinitionLocation);
    }

    public AttachmentItem(@Nonnull ResourceLocation defLoc, @Nonnull Item.Properties properties) {
        super(defLoc, properties);
    }

    @Override
    public boolean CanBeCraftedFromParts() {
        return false;
    }

    @Override
    public boolean ShouldRenderAsIcon(@Nonnull ItemDisplayContext transformType) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(AttachmentItemClientExtension.of(this));
    }

    public boolean m_8120_(ItemStack i) {
        return false;
    }

    @Override
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltips, @Nonnull TooltipFlag flags) {
        super.m_7373_(stack, level, tooltips, flags);
        boolean expanded = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340);
        AttachmentDefinition def = this.Def();
        if (def.IsValid()) {
            for (ModifierDefinition mod : def.modifiers) {
                tooltips.addAll(mod.GetModifierStrings());
            }
            for (HandlerDefinition handler : def.handlerOverrides) {
                MutableComponent inputComponent = Component.m_237115_((String)("player.input." + handler.inputType.toString().toLowerCase()));
                tooltips.add((Component)Component.m_237110_((String)"attachment.add_input", (Object[])new Object[]{inputComponent}));
            }
            for (CraftingTraitProviderDefinition provider : def.abilities) {
                CraftingTraitDefinition trait = (CraftingTraitDefinition)FlansMod.TRAITS.Get(provider.trait);
                if (!trait.IsValid()) continue;
                tooltips.add(FlanItem.CreateTraitComponent(trait, provider.level, expanded));
            }
        }
    }
}

