/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.gunshots;

import com.flansmod.common.FlansMod;
import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.common.gunshots.PlayerMovementHistory;
import com.flansmod.common.gunshots.PlayerSnapshot;
import com.flansmod.common.projectiles.CasingEntity;
import com.flansmod.physics.client.DebugRenderer;
import com.flansmod.physics.common.util.Transform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.joml.Vector4f;

public class Raytracer {
    private static final int NUM_SNAPSHOTS_TO_KEEP = 100;
    private static final HashMap<LevelAccessor, Raytracer> Raytracers = new HashMap();
    @Nonnull
    private final LevelAccessor World;
    @Nonnull
    private final HashMap<Player, PlayerMovementHistory> PlayerMovementHistories = new HashMap();

    @Nonnull
    public static Raytracer ForLevel(@Nonnull LevelAccessor level) {
        if (!Raytracers.containsKey(level)) {
            Raytracer newInstance = new Raytracer(level);
            newInstance.hook();
            Raytracers.put(level, newInstance);
        }
        return Raytracers.get(level);
    }

    public Raytracer(@Nonnull LevelAccessor w) {
        this.World = w;
        Raytracers.put(w, this);
    }

    public void hook() {
        MinecraftForge.EVENT_BUS.addListener(this::commonTick);
        MinecraftForge.EVENT_BUS.addListener(this::clientTick);
    }

    public void commonTick(@Nonnull TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.level == this.World) {
            ArrayList playerList = new ArrayList(this.World.m_6907_());
            for (Player player : playerList) {
                PlayerMovementHistory moves = this.PlayerMovementHistories.get(player);
                if (moves == null) {
                    moves = new PlayerMovementHistory(100);
                    this.PlayerMovementHistories.put(player, moves);
                }
                moves.TakeSnapshot(player);
            }
        }
    }

    public void clientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (FlansMod.DEBUG || Minecraft.m_91087_().m_91290_().m_114377_()) {
            for (Map.Entry<Player, PlayerMovementHistory> kvp : this.PlayerMovementHistories.entrySet()) {
                if (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && (kvp.getKey().m_7578_() || ServerLifecycleHooks.getCurrentServer() != null && ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_().size() == 1)) continue;
                kvp.getValue().debugRender(!(this.World instanceof ServerLevel));
            }
        }
    }

    @Nonnull
    public PlayerSnapshot GetSnapshot(@Nonnull Player player, int nTicksAgo) {
        PlayerMovementHistory movementHistory = this.PlayerMovementHistories.get(player);
        if (movementHistory != null) {
            return movementHistory.GetSnapshotNTicksAgo(nTicksAgo);
        }
        return PlayerSnapshot.INVALID;
    }

    @Nullable
    public HitResult CastBullet(@Nullable Entity from, @Nonnull Vec3 origin, @Nonnull Vec3 motion) {
        ArrayList<HitResult> hits = new ArrayList<HitResult>();
        this.CastBullet(from, origin, motion, 0.0, 0.0, hits);
        if (hits.size() > 0) {
            return (HitResult)hits.get(0);
        }
        return null;
    }

    public void CastBullet(@Nullable Entity from, @Nonnull Vec3 origin, @Nonnull Vec3 motion, double penetrationPowerVsBlocks, double penetrationPowerVsEntities, @Nonnull List<HitResult> outHitList) {
        outHitList.clear();
        double distanceRemaining = motion.m_82553_();
        Vec3 testPoint = origin;
        Vec3 endPoint = origin.m_82549_(motion);
        int numTests = 0;
        while (testPoint.m_82557_(endPoint) > 1.0E-4) {
            ArrayList<HitResult> hitsFromThisSection = new ArrayList<HitResult>(8);
            testPoint = this.GetHitsUpToNextBlock(origin, endPoint, hitsFromThisSection);
            for (HitResult hit : hitsFromThisSection) {
                boolean bCanPenetrate = false;
                boolean bShouldHit = true;
                switch (hit.m_6662_()) {
                    case ENTITY: {
                        LivingEntity living;
                        EntityHitResult entHit = (EntityHitResult)hit;
                        Entity entity = entHit.m_82443_();
                        bCanPenetrate = entity instanceof LivingEntity ? penetrationPowerVsEntities >= (double)(living = (LivingEntity)entity).m_21230_() : true;
                        bShouldHit = entHit.m_82443_() != from;
                        break;
                    }
                    case BLOCK: {
                        BlockHitResult blockHit = (BlockHitResult)hit;
                        bCanPenetrate = this.World.isAreaLoaded(blockHit.m_82425_(), 1) ? penetrationPowerVsBlocks >= (double)this.World.m_8055_(blockHit.m_82425_()).m_60734_().m_155943_() : false;
                    }
                }
                if (!bShouldHit) continue;
                outHitList.add(hit);
                if (!bCanPenetrate) {
                    testPoint = endPoint;
                    break;
                }
                testPoint = endPoint;
                break;
            }
            if (++numTests <= 100) continue;
            FlansMod.LOGGER.warn("Raytrace exceeded 100 raycasts, something is probably wrong");
            if (!this.World.m_5776_()) break;
            DebugRenderer.renderLine(Transform.fromPos(origin), 100, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), endPoint.m_82546_(origin));
            break;
        }
    }

    @Nonnull
    private Vec3 GetHitsUpToNextBlock(@Nonnull Vec3 origin, @Nonnull Vec3 ray, @Nonnull List<HitResult> outResults) {
        Vec3 endPoint = ray;
        ClipContext clipContext = new ClipContext(origin, endPoint, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
        BlockHitResult blockHit = this.World.m_45547_(clipContext);
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            outResults.add((HitResult)blockHit);
            endPoint = blockHit.m_82450_();
        }
        AABB bounds = new AABB(origin, endPoint);
        for (Entity checkEnt : this.World.m_45933_(null, bounds)) {
            Player checkPlayer;
            PlayerMovementHistory history;
            if (checkEnt instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)checkEnt;
                vehicle.Raycast(origin, endPoint, 0.0f, outResults);
                continue;
            }
            if (checkEnt instanceof Player && (history = this.PlayerMovementHistories.get(checkPlayer = (Player)checkEnt)) != null) {
                history.GetSnapshotNTicksAgo(0).Raycast(checkPlayer, origin, endPoint, outResults);
                continue;
            }
            if (checkEnt instanceof CasingEntity) continue;
            Optional hit = checkEnt.m_20191_().m_82371_(origin, endPoint);
            hit.ifPresent(vec3 -> outResults.add((HitResult)new EntityHitResult(checkEnt, vec3)));
        }
        if (outResults.size() > 0) {
            outResults.sort(new CompareHits(origin));
        }
        return endPoint;
    }

    private static class CompareHits
    implements Comparator<HitResult> {
        private final Vec3 origin;

        public CompareHits(@Nonnull Vec3 ori) {
            this.origin = ori;
        }

        @Override
        public int compare(HitResult o1, HitResult o2) {
            if (o1 == null || o1.m_6662_() == HitResult.Type.MISS) {
                return -1;
            }
            if (o2 == null || o2.m_6662_() == HitResult.Type.MISS) {
                return 1;
            }
            return Double.compare(o1.m_82450_().m_82557_(this.origin), o2.m_82450_().m_82557_(this.origin));
        }
    }
}

