/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.gunshots;

import com.flansmod.common.gunshots.EPlayerHitArea;
import com.flansmod.common.gunshots.PlayerHitResult;
import com.flansmod.common.gunshots.PlayerHitbox;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class PlayerSnapshot {
    public static final PlayerSnapshot INVALID = new PlayerSnapshot();
    public boolean valid = false;
    public final PlayerHitbox[] hitboxes = new PlayerHitbox[EPlayerHitArea.NUM_AREAS];
    public long time;

    public PlayerSnapshot() {
        for (int i = 0; i < EPlayerHitArea.NUM_AREAS; ++i) {
            this.hitboxes[i] = new PlayerHitbox(EPlayerHitArea.values()[i], Transform.IDENTITY, Maths.identityPosF());
        }
    }

    public void UpdateHitbox(@Nonnull EPlayerHitArea area, @Nonnull Transform centerPoint, @Nonnull Vector3f halfExtents) {
        this.hitboxes[area.ordinal()].transform = centerPoint;
        this.hitboxes[area.ordinal()].halfExtents = halfExtents;
    }

    public void Raycast(@Nonnull Player player, @Nonnull Vec3 startPos, @Nonnull Vec3 endPos, @Nonnull List<HitResult> results) {
        for (PlayerHitbox hitbox : this.hitboxes) {
            Vector3d hitLoc = new Vector3d();
            if (!hitbox.Raycast(startPos, endPos, hitLoc)) continue;
            results.add((HitResult)new PlayerHitResult(player, hitbox, new Vec3(hitLoc.x, hitLoc.y, hitLoc.z)));
        }
    }

    @Nonnull
    public Transform GetArmTransform(@Nonnull HumanoidArm arm) {
        return switch (arm) {
            default -> throw new IncompatibleClassChangeError();
            case HumanoidArm.RIGHT -> this.hitboxes[EPlayerHitArea.RIGHTARM.ordinal()].transform;
            case HumanoidArm.LEFT -> this.hitboxes[EPlayerHitArea.LEFTARM.ordinal()].transform;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public void debugRender(@Nonnull Vec3 withOffset, @Nonnull Vector4f colour) {
        for (PlayerHitbox hitbox : this.hitboxes) {
            if (hitbox == null) continue;
            hitbox.debugRender(withOffset, colour);
        }
    }
}

