/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.gunshots;

import com.flansmod.common.FlansMod;
import com.flansmod.common.gunshots.Gunshot;
import com.flansmod.common.types.guns.GunDefinition;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class GunshotCollection {
    public static final ResourceKey<Level> InvalidDimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("null"));
    public static final int InvalidEntityID = -1;
    public int SeatID;
    public int GunHash;
    public int GroupPathHash;
    public int FiredTick;
    public boolean Processed = false;
    public List<Gunshot> Shots = new ArrayList<Gunshot>(8);

    @Nonnull
    public GunDefinition Gun() {
        return (GunDefinition)FlansMod.GUNS.ByHash(this.GunHash);
    }

    @Nonnull
    public Gunshot Get(int index) {
        return this.Shots.get(index);
    }

    public int Count() {
        return this.Shots.size();
    }

    @Nonnull
    public GunshotCollection CopySubset(int triggerMin, int triggerMax) {
        GunshotCollection copy = new GunshotCollection().WithGun(this.GunHash).FiredOnTick(this.FiredTick).FromActionGroup(this.GroupPathHash);
        for (Gunshot shot : this.Shots) {
            if (triggerMin > shot.fromShotIndex || shot.fromShotIndex > triggerMax) continue;
            copy.AddShot(shot);
        }
        return copy;
    }

    @Nonnull
    public GunshotCollection WithGun(int gunHash) {
        this.GunHash = gunHash;
        return this;
    }

    @Nonnull
    public GunshotCollection WithGun(@Nonnull GunDefinition gun) {
        this.GunHash = gun.hashCode();
        return this;
    }

    @Nonnull
    public GunshotCollection FromActionGroup(int groupPathHash) {
        this.GroupPathHash = groupPathHash;
        return this;
    }

    @Nonnull
    public GunshotCollection FromActionGroup(@Nonnull String groupPath) {
        this.GroupPathHash = groupPath.hashCode();
        return this;
    }

    @Nonnull
    public GunshotCollection FiredOnTick(int tick) {
        this.FiredTick = tick;
        return this;
    }

    @Nonnull
    public GunshotCollection AddShot(@Nonnull Gunshot shot) {
        this.Shots.add(shot);
        return this;
    }

    public static void Encode(@Nullable GunshotCollection shotCollection, @Nonnull FriendlyByteBuf buf) {
        if (shotCollection == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(shotCollection.Count());
            for (int i = 0; i < shotCollection.Count(); ++i) {
                Gunshot gunshot = shotCollection.Get(i);
                Gunshot.Encode(gunshot, buf);
            }
            buf.writeInt(shotCollection.SeatID);
            buf.writeInt(shotCollection.GunHash);
            buf.writeInt(shotCollection.GroupPathHash);
            buf.writeInt(shotCollection.FiredTick);
        }
    }

    public static void Decode(@Nonnull GunshotCollection shotCollection, @Nonnull FriendlyByteBuf buf) {
        int numShots = buf.readInt();
        if (numShots >= 0) {
            for (int i = 0; i < numShots; ++i) {
                shotCollection.Shots.add(Gunshot.Decode(buf));
            }
            shotCollection.SeatID = buf.readInt();
            shotCollection.GunHash = buf.readInt();
            shotCollection.GroupPathHash = buf.readInt();
            shotCollection.FiredTick = buf.readInt();
        }
    }
}

