/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.gunshots;

import com.flansmod.common.FlansMod;
import com.flansmod.common.gunshots.EPlayerHitArea;
import com.flansmod.common.gunshots.PlayerHitResult;
import com.flansmod.common.gunshots.UnresolvedEntityHitResult;
import com.flansmod.common.types.bullets.BulletDefinition;
import com.flansmod.physics.common.util.Maths;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Gunshot {
    private static final HitResult[] NO_HITS = new HitResult[0];
    private static final int PROJECTILE_OFFSET = 16000;
    public BulletDefinition bulletDef = BulletDefinition.INVALID;
    public int fromShotDefIndex = 0;
    public Vec3 origin = Vec3.f_82478_;
    public Vec3 trajectory = Vec3.f_82478_;
    public HitResult[] hits = NO_HITS;
    public int fromShotIndex = 0;
    public int fromBulletIndex = 0;

    public boolean IsProjectile() {
        return this.fromShotDefIndex >= 16000;
    }

    public int HitscanIndex() {
        return this.fromShotDefIndex;
    }

    public int ProjectileIndex() {
        return this.fromShotDefIndex - 16000;
    }

    @Nonnull
    public Vec3 Endpoint() {
        return new Vec3(this.origin.f_82479_ + this.trajectory.f_82479_, this.origin.f_82480_ + this.trajectory.f_82480_, this.origin.f_82481_ + this.trajectory.f_82481_);
    }

    @Nonnull
    public Gunshot FromShot(int index) {
        this.fromShotIndex = index;
        return this;
    }

    @Nonnull
    public Gunshot FromHitscan(int index) {
        this.fromShotDefIndex = index;
        return this;
    }

    @Nonnull
    public Gunshot FromProjectile(int index) {
        this.fromShotDefIndex = 16000 + index;
        return this;
    }

    @Nonnull
    public Gunshot FromBulletIndex(int index) {
        this.fromBulletIndex = index;
        return this;
    }

    @Nonnull
    public Gunshot WithOrigin(double x, double y, double z) {
        this.origin = new Vec3(x, y, z);
        return this;
    }

    @Nonnull
    public Gunshot WithOrigin(@Nonnull Vec3 o) {
        this.origin = o;
        return this;
    }

    @Nonnull
    public Gunshot WithTrajectory(double x, double y, double z) {
        this.trajectory = new Vec3(x, y, z);
        return this;
    }

    @Nonnull
    public Gunshot WithTrajectory(@Nonnull Vec3 t) {
        this.trajectory = t;
        return this;
    }

    @Nonnull
    public Gunshot WithHits(@Nonnull HitResult[] results) {
        this.hits = results;
        return this;
    }

    @Nonnull
    public Gunshot WithBullet(@Nonnull BulletDefinition bullet) {
        this.bulletDef = bullet;
        return this;
    }

    public static void Encode(@Nonnull Gunshot gunshot, @Nonnull FriendlyByteBuf buf) {
        buf.writeInt(gunshot.bulletDef.hashCode());
        buf.writeInt(gunshot.fromShotIndex);
        buf.writeInt(gunshot.fromBulletIndex);
        buf.writeInt(gunshot.fromShotDefIndex);
        buf.writeDouble(gunshot.origin.f_82479_);
        buf.writeDouble(gunshot.origin.f_82480_);
        buf.writeDouble(gunshot.origin.f_82481_);
        buf.writeFloat((float)gunshot.trajectory.f_82479_);
        buf.writeFloat((float)gunshot.trajectory.f_82480_);
        buf.writeFloat((float)gunshot.trajectory.f_82481_);
        Vec3 end = gunshot.Endpoint();
        buf.writeInt(gunshot.hits.length);
        block4: for (int j = 0; j < gunshot.hits.length; ++j) {
            float t = (float)Maths.calculateParameter(gunshot.origin, end, gunshot.hits[j].m_82450_());
            buf.writeFloat(t);
            switch (gunshot.hits[j].m_6662_()) {
                case BLOCK: {
                    buf.writeInt(-1);
                    BlockHitResult blockHit = (BlockHitResult)gunshot.hits[j];
                    int localBlockPos = Maths.blockPosToPinpointData(blockHit.m_82425_(), blockHit.m_82434_().ordinal());
                    buf.writeInt(localBlockPos);
                    continue block4;
                }
                case ENTITY: {
                    EntityHitResult entityHit = (EntityHitResult)gunshot.hits[j];
                    buf.writeInt(entityHit.m_82443_().m_19879_());
                    if (entityHit instanceof PlayerHitResult) {
                        PlayerHitResult playerHit = (PlayerHitResult)entityHit;
                        buf.writeInt(playerHit.GetHitbox().area.ordinal());
                        continue block4;
                    }
                    buf.writeInt(0);
                    continue block4;
                }
                default: {
                    buf.writeInt(-2);
                    buf.writeInt(0);
                }
            }
        }
    }

    @Nonnull
    public static Gunshot Decode(@Nonnull FriendlyByteBuf buf) {
        int bulletHash = buf.readInt();
        int fromShotIndex = buf.readInt();
        int fromBulletIndex = buf.readInt();
        int fromShotDefIndex = buf.readInt();
        BulletDefinition bulletDef = (BulletDefinition)FlansMod.BULLETS.ByHash(bulletHash);
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        double dx = buf.readFloat();
        double dy = buf.readFloat();
        double dz = buf.readFloat();
        int numHits = buf.readInt();
        HitResult[] hits = new HitResult[numHits];
        block4: for (int i = 0; i < numHits; ++i) {
            float t = buf.readFloat();
            Vec3 hitPos = new Vec3(x + dx * (double)t, y + dy * (double)t, z + dz * (double)t);
            int entityIdOrType = buf.readInt();
            int extraData = buf.readInt();
            switch (entityIdOrType) {
                case -2: {
                    hits[i] = BlockHitResult.m_82426_((Vec3)hitPos, (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)hitPos));
                    continue block4;
                }
                case -1: {
                    BlockPos roughBlockPos = BlockPos.m_274446_((Position)hitPos);
                    BlockPos exactBlockPos = Maths.resolveBlockPos(roughBlockPos, extraData);
                    hits[i] = new BlockHitResult(hitPos, Direction.values()[extraData >> 24 & 0xFF], exactBlockPos, false);
                    continue block4;
                }
                default: {
                    hits[i] = new UnresolvedEntityHitResult(hitPos, entityIdOrType, EPlayerHitArea.values()[extraData]);
                }
            }
        }
        return new Gunshot().WithOrigin(x, y, z).FromShot(fromShotIndex).FromBulletIndex(fromBulletIndex).FromHitscan(fromShotDefIndex).WithTrajectory(dx, dy, dz).WithHits(hits).WithBullet(bulletDef);
    }
}

