/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.hierarchy;

import com.flansmod.common.FlansMod;
import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.common.entity.vehicle.hierarchy.EPartDefComponent;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import com.flansmod.common.entity.vehicle.hierarchy.VehiclePartPath;
import com.flansmod.common.network.FlansEntityDataSerializers;
import com.flansmod.common.types.vehicles.VehicleDefinition;
import com.flansmod.common.types.vehicles.elements.EControlLogicHint;
import com.flansmod.common.types.vehicles.elements.WheelDefinition;
import com.flansmod.physics.common.util.ITransformChildEntity;
import com.flansmod.physics.common.util.ITransformEntity;
import com.flansmod.physics.common.util.ITransformPair;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class WheelEntity
extends Entity
implements ITransformChildEntity {
    private static final int INVALID_WHEEL_INDEX = -1;
    private WheelDefinition Def;
    public EntityDimensions Size;
    private Optional<VehicleEntity> Vehicle = Optional.empty();
    public static EntityDataAccessor<Integer> VEHICLE_ENTITY_ID = SynchedEntityData.m_135353_(WheelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static EntityDataAccessor<VehicleDefinition> VEHICLE_DEF = SynchedEntityData.m_135353_(WheelEntity.class, FlansEntityDataSerializers.VEHICLE_DEF);
    public static EntityDataAccessor<Integer> WHEEL_INDEX = SynchedEntityData.m_135353_(WheelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static EntityDataAccessor<Integer> WHEEL_PATH = SynchedEntityData.m_135353_(WheelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static EntityDataAccessor<Float> ANGULAR_VELOCITY = SynchedEntityData.m_135353_(WheelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public float TargetYawParameter = 0.0f;
    public float YawParameterPrevious = 0.0f;
    public float YawParameterCurrent = 0.0f;
    public float TargetTorqueParameter = 0.0f;
    public float TorqueParameterPrevious = 0.0f;
    public float TorqueParameterCurrent = 0.0f;
    public float AngularVelocityPrevious = 0.0f;
    public float AngularVelocityCurrent = 0.0f;

    public WheelEntity(@Nonnull EntityType<? extends WheelEntity> type, @Nonnull Level world) {
        super(type, world);
        this.Size = EntityDimensions.m_20398_((float)0.5f, (float)0.5f);
        this.m_6210_();
        this.f_19850_ = true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(VEHICLE_DEF, (Object)VehicleDefinition.INVALID);
        this.f_19804_.m_135372_(VEHICLE_ENTITY_ID, (Object)0);
        this.f_19804_.m_135372_(WHEEL_INDEX, (Object)0);
        this.f_19804_.m_135372_(WHEEL_PATH, (Object)0);
        this.f_19804_.m_135372_(ANGULAR_VELOCITY, (Object)Float.valueOf(0.0f));
    }

    public void SetLinkToVehicle(@Nonnull VehicleEntity vehicle, @Nonnull VehicleComponentPath path) {
        if (path.Type() != EPartDefComponent.Wheel) {
            FlansMod.LOGGER.error("Wheel attempted to link to vehicle at invalid path " + path);
        }
        this.SetLinkToVehicle(vehicle, path.Part(), path.Index());
    }

    public void SetLinkToVehicle(@Nonnull VehicleEntity vehicle, @Nonnull VehiclePartPath path, int wheelIndex) {
        this.SetVehicleDef(vehicle.Def());
        this.SetVehicleEntityID(vehicle.m_19879_());
        this.SetWheelPath(path);
        this.SetWheelIndex(wheelIndex);
        WheelDefinition def = this.GetWheelDef();
        this.Size = EntityDimensions.m_20398_((float)def.radius, (float)def.radius);
        this.Vehicle = Optional.of(vehicle);
        this.m_146884_(vehicle.getWorldToAP(this.GetWheelPath().Part()).current().positionVec3());
    }

    private void SetVehicleDef(@Nonnull VehicleDefinition def) {
        this.f_19804_.m_135381_(VEHICLE_DEF, (Object)def);
    }

    private void SetVehicleEntityID(int entityID) {
        this.f_19804_.m_135381_(VEHICLE_ENTITY_ID, (Object)entityID);
    }

    private void SetWheelPath(@Nonnull VehiclePartPath path) {
        this.f_19804_.m_135381_(WHEEL_PATH, (Object)path.hashCode());
    }

    private void SetWheelIndex(int index) {
        this.f_19804_.m_135381_(WHEEL_INDEX, (Object)index);
    }

    private void SetAngularVelocity(float angularVelocity) {
        this.f_19804_.m_135381_(ANGULAR_VELOCITY, (Object)Float.valueOf(angularVelocity));
    }

    @Nonnull
    public VehicleDefinition GetVehicleDef() {
        return (VehicleDefinition)this.f_19804_.m_135370_(VEHICLE_DEF);
    }

    public int GetVehicleID() {
        return (Integer)this.f_19804_.m_135370_(VEHICLE_ENTITY_ID);
    }

    @Nullable
    public VehicleEntity GetVehicle() {
        Entity entity;
        if (this.Vehicle.isEmpty() && (entity = this.m_9236_().m_6815_(this.GetVehicleID())) instanceof VehicleEntity) {
            VehicleEntity parent = (VehicleEntity)entity;
            this.Vehicle = Optional.of(parent);
        }
        return this.Vehicle.get();
    }

    public int GetWheelIndex() {
        return (Integer)this.f_19804_.m_135370_(WHEEL_INDEX);
    }

    @Nonnull
    public VehicleComponentPath GetWheelPath() {
        return VehicleComponentPath.of((Integer)this.f_19804_.m_135370_(WHEEL_PATH), EPartDefComponent.Wheel, (int)((Integer)this.f_19804_.m_135370_(WHEEL_INDEX)));
    }

    public float GetAngularVelocity() {
        return ((Float)this.f_19804_.m_135370_(ANGULAR_VELOCITY)).floatValue();
    }

    @Nonnull
    public WheelDefinition GetWheelDef() {
        VehicleDefinition vehicleDef;
        int wheelIndex;
        if (this.Def == null && (wheelIndex = this.GetWheelIndex()) != -1 && (vehicleDef = this.GetVehicleDef()).IsValid()) {
            this.Def = vehicleDef.AsHierarchy().FindWheel(this.GetWheelPath()).orElse(WheelDefinition.INVALID);
        }
        return this.Def != null ? this.Def : WheelDefinition.INVALID;
    }

    public boolean IsLinked() {
        return this.GetVehicleDef().IsValid() && this.GetWheelIndex() != -1;
    }

    @Nonnull
    public EntityDimensions m_6972_(@Nonnull Pose pose) {
        return this.Size;
    }

    public static boolean canVehicleCollide(@Nonnull Entity a, @Nonnull Entity b) {
        return (b.m_5829_() || b.m_6094_()) && !a.m_20365_(b);
    }

    public boolean m_7337_(@Nonnull Entity other) {
        return WheelEntity.canVehicleCollide(this, other);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean Is(@Nonnull EControlLogicHint hint) {
        return this.Def.IsHintedAs(hint);
    }

    public boolean m_142391_() {
        return false;
    }

    public boolean m_7306_(@Nonnull Entity other) {
        return this == other || this.GetVehicle() == other;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_5654_() {
        throw new UnsupportedOperationException();
    }

    public boolean m_6087_() {
        return true;
    }

    @Nullable
    public ItemStack m_142340_() {
        VehicleEntity vehicle = this.GetVehicle();
        return vehicle != null ? vehicle.m_142340_() : ItemStack.f_41583_;
    }

    @Nonnull
    public InteractionResult m_6096_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        VehicleEntity vehicle = this.GetVehicle();
        return vehicle != null ? vehicle.m_6096_(player, hand) : InteractionResult.PASS;
    }

    @Nonnull
    public Transform GetWorldTransformPrevious() {
        return Transform.fromPos(this.m_20318_(0.0f));
    }

    @Nonnull
    public Transform GetWorldTransformCurrent() {
        return Transform.fromPos(this.m_20318_(1.0f));
    }

    @Override
    @Nonnull
    public ITransformPair GetWorldTransform() {
        return ITransformPair.of(this::GetWorldTransformPrevious, this::GetWorldTransformCurrent);
    }

    @Override
    public void SetWorldTransform(@Nonnull Transform currentWorldTransform) {
        this.m_146884_(currentWorldTransform.positionVec3());
    }

    protected void m_7378_(@Nonnull CompoundTag tags) {
    }

    protected void m_7380_(@Nonnull CompoundTag tags) {
    }

    public void StartTick(@Nonnull VehicleEntity parent) {
        this.m_146867_();
        this.YawParameterPrevious = this.YawParameterCurrent;
        this.AngularVelocityPrevious = this.AngularVelocityCurrent;
        this.TorqueParameterPrevious = this.TorqueParameterCurrent;
    }

    public void PhysicsTick(@Nonnull VehicleEntity vehicle, int wheelIndex) {
    }

    public void EndTick(@Nonnull VehicleEntity parent) {
        if (parent.IsAuthority()) {
            this.TorqueParameterCurrent = Maths.lerpF(this.TorqueParameterCurrent, this.TargetTorqueParameter, this.GetWheelDef().TorqueLerpRate());
            this.YawParameterCurrent = Maths.lerpF(this.YawParameterCurrent, this.TargetYawParameter, this.GetWheelDef().YawLerpRate());
        }
        this.SyncTransformToEntity();
    }

    private void CheckCollisions() {
        Level level = this.m_9236_();
        List list = level.m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.m_20363_((Entity)this)) continue;
                this.m_7334_(entity);
            }
        }
    }

    public void SetYawParameter(float target) {
        this.TargetYawParameter = target;
    }

    public void SetTorqueParameter(float target) {
        this.TargetTorqueParameter = target;
    }

    @Override
    @Nonnull
    public ITransformEntity GetParent() {
        return this.GetVehicle();
    }

    @Override
    public int GetIndex() {
        return this.GetWheelIndex();
    }

    @Override
    public void SyncTransformToEntity() {
        Transform worldRoot = this.GetWorldTransformCurrent();
        Vector3f euler = worldRoot.euler();
        this.m_146884_(worldRoot.positionVec3());
        this.m_146922_(euler.y);
        this.m_146926_(euler.x);
    }

    @Override
    public void SyncEntityToTransform() {
        this.SetWorldTransform(Transform.fromPosAndEuler(this.m_20318_(1.0f), this.m_146909_(), this.m_146908_(), 0.0f));
    }

    @Nonnull
    public Vec3 GetVelocity() {
        return this.m_20184_().m_82490_(20.0);
    }

    public void SetVelocity(@Nonnull Vec3 velocityMetersPerSecond) {
        this.m_20256_(velocityMetersPerSecond.m_82490_((double)0.05f));
    }

    public void ApplyVelocity() {
        VehicleEntity parent;
        Vec3 prePos = this.m_20182_();
        Vec3 expectedMovement = this.m_20184_();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.CheckCollisions();
        Vec3 postPos = this.m_20182_();
        Vec3 actualMovement = postPos.m_82546_(prePos);
        if (!this.f_19863_ && !this.f_19862_ || (parent = this.GetVehicle()) != null) {
            // empty if block
        }
    }
}

