/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.hierarchy;

import com.flansmod.common.FlansMod;
import com.flansmod.common.entity.vehicle.hierarchy.EPartDefComponent;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import com.flansmod.common.entity.vehicle.hierarchy.VehiclePartPath;
import com.flansmod.common.types.vehicles.VehicleDefinition;
import com.flansmod.common.types.vehicles.elements.ArticulatedPartDefinition;
import com.flansmod.common.types.vehicles.elements.DamageablePartDefinition;
import com.flansmod.common.types.vehicles.elements.MountedGunDefinition;
import com.flansmod.common.types.vehicles.elements.PropellerDefinition;
import com.flansmod.common.types.vehicles.elements.SeatDefinition;
import com.flansmod.common.types.vehicles.elements.VehiclePartDefinition;
import com.flansmod.common.types.vehicles.elements.WheelDefinition;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class VehicleDefinitionHierarchy {
    public final VehicleNode RootNode;
    public final Map<VehiclePartPath, VehicleNode> AllNodes;
    public final Map<VehiclePartPath, VehicleNode> TransformableNodes = new HashMap<VehiclePartPath, VehicleNode>();

    public VehicleDefinitionHierarchy(@Nonnull VehicleNode rootNode) {
        this.RootNode = rootNode;
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        this.Hierarchise(rootNode, new Stack<String>(), (ImmutableMap.Builder<VehiclePartPath, VehicleNode>)builder);
        this.AllNodes = builder.build();
    }

    private void Hierarchise(@Nonnull VehicleNode node, @Nonnull Stack<String> pathBuilder, @Nonnull ImmutableMap.Builder<VehiclePartPath, VehicleNode> mapBuilder) {
        node.Path = VehiclePartPath.of((ImmutableList<String>)ImmutableList.copyOf(pathBuilder));
        mapBuilder.put((Object)node.Path, (Object)node);
        for (Map.Entry<String, VehicleNode> kvp : node.ChildNodes.entrySet()) {
            pathBuilder.push(kvp.getKey());
            this.Hierarchise(kvp.getValue(), pathBuilder, mapBuilder);
            pathBuilder.pop();
        }
    }

    public void FromRootToNode(@Nonnull VehiclePartPath path, @Nonnull Consumer<VehicleNode> func) {
        if (this.AllNodes.containsKey(path)) {
            this.AllNodes.get(path).IterateRootToThis(func);
        }
    }

    public void FromNodeToRoot(@Nonnull VehiclePartPath path, @Nonnull Consumer<VehicleNode> func) {
        if (this.AllNodes.containsKey(path)) {
            this.AllNodes.get(path).IterateThisToRoot(func);
        }
    }

    @Nonnull
    public Optional<VehicleNode> FindNode(@Nonnull VehiclePartPath partPath) {
        return Optional.ofNullable(this.AllNodes.get(partPath));
    }

    @Nonnull
    public Optional<VehicleNode> FindNode(@Nonnull VehicleComponentPath componentPath) {
        return this.FindNode(componentPath.Part());
    }

    public void ForEachNode(@Nonnull Consumer<VehicleNode> func) {
        for (VehicleNode node : this.AllNodes.values()) {
            func.accept(node);
        }
    }

    public void ForEachNode(@Nonnull BiConsumer<VehiclePartPath, VehicleNode> func) {
        for (Map.Entry<VehiclePartPath, VehicleNode> kvp : this.AllNodes.entrySet()) {
            func.accept(kvp.getKey(), kvp.getValue());
        }
    }

    public void ForEachArticulatedPart(@Nonnull BiConsumer<VehicleComponentPath, ArticulatedPartDefinition> func) {
        for (Map.Entry<VehiclePartPath, VehicleNode> kvp : this.AllNodes.entrySet()) {
            if (!kvp.getValue().Def.IsArticulated()) continue;
            func.accept(kvp.getKey().Articulation(), kvp.getValue().Def.articulation);
        }
    }

    public void IfArticulated(@Nonnull VehicleComponentPath partPath, @Nonnull Consumer<ArticulatedPartDefinition> func) {
        this.FindNode(partPath).ifPresent(node -> {
            if (node.Def.IsArticulated()) {
                func.accept(node.Def.articulation);
            }
        });
    }

    @Nonnull
    public <T> Optional<T> IfArticulated(@Nonnull VehicleComponentPath partPath, @Nonnull Function<ArticulatedPartDefinition, T> func) {
        return this.FindNode(partPath).flatMap(node -> {
            if (node.Def.IsArticulated()) {
                return Optional.of(func.apply(node.Def.articulation));
            }
            return Optional.empty();
        });
    }

    public void ForEachDamageable(@Nonnull BiConsumer<VehicleComponentPath, DamageablePartDefinition> func) {
        for (Map.Entry<VehiclePartPath, VehicleNode> kvp : this.AllNodes.entrySet()) {
            if (!kvp.getValue().Def.IsArticulated()) continue;
            func.accept(kvp.getKey().Damageable(), kvp.getValue().Def.damage);
        }
    }

    @Nonnull
    public Optional<DamageablePartDefinition> FindDamageable(@Nonnull VehicleComponentPath damagePath) {
        if (damagePath.Type() == EPartDefComponent.Damage) {
            return this.FindNode(damagePath).flatMap(node -> {
                if (node.Def.IsDamageable()) {
                    return Optional.of(node.Def.damage);
                }
                return Optional.empty();
            });
        }
        return Optional.empty();
    }

    public void IfDamageableExists(@Nonnull VehicleComponentPath damagePath, @Nonnull Consumer<DamageablePartDefinition> func) {
        if (damagePath.Type() == EPartDefComponent.Damage) {
            this.FindNode(damagePath).ifPresent(node -> {
                if (node.Def.IsDamageable()) {
                    func.accept(node.Def.damage);
                }
            });
        }
    }

    public void ForEachSeat(@Nonnull BiConsumer<VehicleComponentPath, SeatDefinition> func) {
        for (Map.Entry<VehiclePartPath, VehicleNode> kvp : this.AllNodes.entrySet()) {
            for (int i = 0; i < kvp.getValue().Def.seats.length; ++i) {
                func.accept(kvp.getKey().Seat(i), kvp.getValue().Def.seats[i]);
            }
        }
    }

    @Nonnull
    public Optional<SeatDefinition> FindSeat(@Nonnull VehicleComponentPath path) {
        return this.FindNode(path.Part()).flatMap(node -> {
            if (path.Index() < node.Def.seats.length) {
                return Optional.of(node.Def.seats[path.Index()]);
            }
            return Optional.empty();
        });
    }

    public void IfSeatExists(@Nonnull VehicleComponentPath seatPath, @Nonnull Consumer<SeatDefinition> func) {
        if (seatPath.Type() == EPartDefComponent.Seat) {
            this.FindNode(seatPath).ifPresent(node -> {
                if (seatPath.Index() < node.Def.seats.length) {
                    func.accept(node.Def.seats[seatPath.Index()]);
                }
            });
        }
    }

    @Nonnull
    public <T> Optional<T> IfSeatExists(@Nonnull VehicleComponentPath seatPath, @Nonnull Function<SeatDefinition, T> func) {
        if (seatPath.Type() == EPartDefComponent.Seat) {
            int seatIndex = seatPath.Index();
            return this.FindNode(seatPath).flatMap(node -> {
                if (seatIndex < node.Def.seats.length) {
                    return Optional.of(func.apply(node.Def.seats[seatIndex]));
                }
                return Optional.empty();
            });
        }
        return Optional.empty();
    }

    public int NumWheels() {
        int numWheels = 0;
        for (Map.Entry<VehiclePartPath, VehicleNode> kvp : this.AllNodes.entrySet()) {
            numWheels += kvp.getValue().Def.wheels.length;
        }
        return numWheels;
    }

    @Nonnull
    public Optional<WheelDefinition> FindWheel(@Nonnull VehicleComponentPath path) {
        return this.FindNode(path.Part()).flatMap(node -> {
            if (path.Index() < node.Def.wheels.length) {
                return Optional.of(node.Def.wheels[path.Index()]);
            }
            return Optional.empty();
        });
    }

    @Nonnull
    public List<WheelDefinition> AllWheels() {
        ArrayList<WheelDefinition> wheels = new ArrayList<WheelDefinition>();
        for (Map.Entry<VehiclePartPath, VehicleNode> kvp : this.AllNodes.entrySet()) {
            wheels.addAll(List.of(kvp.getValue().Def.wheels));
        }
        return wheels;
    }

    public void ForEachWheel(@Nonnull BiConsumer<VehicleComponentPath, WheelDefinition> func) {
        for (Map.Entry<VehiclePartPath, VehicleNode> kvp : this.AllNodes.entrySet()) {
            for (int i = 0; i < kvp.getValue().Def.wheels.length; ++i) {
                func.accept(kvp.getKey().Wheel(i), kvp.getValue().Def.wheels[i]);
            }
        }
    }

    public void IfWheelExists(@Nonnull VehicleComponentPath wheelPath, @Nonnull Consumer<WheelDefinition> func) {
        if (wheelPath.Type() == EPartDefComponent.Wheel) {
            int wheelIndex = wheelPath.Index();
            this.FindNode(wheelPath).ifPresent(node -> {
                if (wheelIndex < node.Def.wheels.length) {
                    func.accept(node.Def.wheels[wheelIndex]);
                }
            });
        }
    }

    public void ForEachGun(@Nonnull BiConsumer<VehicleComponentPath, MountedGunDefinition> func) {
        for (Map.Entry<VehiclePartPath, VehicleNode> kvp : this.AllNodes.entrySet()) {
            for (int i = 0; i < kvp.getValue().Def.guns.length; ++i) {
                func.accept(kvp.getKey().Gun(i), kvp.getValue().Def.guns[i]);
            }
        }
    }

    public void IfGunExists(@Nonnull VehicleComponentPath gunPath, @Nonnull Consumer<MountedGunDefinition> func) {
        if (gunPath.Type() == EPartDefComponent.Gun) {
            int gunIndex = gunPath.Index();
            this.FindNode(gunPath).ifPresent(node -> {
                if (gunIndex < node.Def.guns.length) {
                    func.accept(node.Def.guns[gunIndex]);
                }
            });
        }
    }

    public void ForEachPropeller(@Nonnull BiConsumer<VehicleComponentPath, PropellerDefinition> func) {
        for (Map.Entry<VehiclePartPath, VehicleNode> kvp : this.AllNodes.entrySet()) {
            for (int i = 0; i < kvp.getValue().Def.propellers.length; ++i) {
                func.accept(kvp.getKey().Propeller(i), kvp.getValue().Def.propellers[i]);
            }
        }
    }

    public void IfPropellerExists(@Nonnull VehicleComponentPath propPath, @Nonnull Consumer<PropellerDefinition> func) {
        if (propPath.Type() == EPartDefComponent.Propeller) {
            int propIndex = propPath.Index();
            this.FindNode(propPath).ifPresent(node -> {
                if (propIndex < node.Def.propellers.length) {
                    func.accept(node.Def.propellers[propIndex]);
                }
            });
        }
    }

    @Nonnull
    public static VehicleDefinitionHierarchy of(@Nonnull VehicleDefinition def) {
        HashMap<String, VehicleNode> nodes = new HashMap<String, VehicleNode>();
        for (VehiclePartDefinition partDef : def.parts) {
            if (nodes.containsKey(partDef.partName)) {
                FlansMod.LOGGER.warn("More than one VehiclePartDefinition named " + partDef.partName);
            }
            nodes.put(partDef.partName, new VehicleNode(partDef));
        }
        if (!nodes.containsKey("body")) {
            nodes.put("body", new VehicleNode(VehiclePartDefinition.INVALID));
        }
        for (Map.Entry entry : nodes.entrySet()) {
            if (((String)entry.getKey()).equals("body")) continue;
            String attachedTo = ((VehicleNode)entry.getValue()).Def.attachedTo;
            if (nodes.containsKey(attachedTo)) {
                VehicleNode parentNode = (VehicleNode)nodes.get(attachedTo);
                parentNode.ChildNodes.put((String)entry.getKey(), (VehicleNode)entry.getValue());
                ((VehicleNode)entry.getValue()).ParentNode = parentNode;
                continue;
            }
            FlansMod.LOGGER.warn("Could not find parent node " + attachedTo + " for " + (String)entry.getKey());
        }
        return new VehicleDefinitionHierarchy((VehicleNode)nodes.get("body"));
    }

    public static class VehicleNode {
        public final Map<String, VehicleNode> ChildNodes = new HashMap<String, VehicleNode>();
        public VehicleNode ParentNode = null;
        public final VehiclePartDefinition Def;
        protected VehiclePartPath Path;

        public VehicleNode(@Nonnull VehiclePartDefinition part) {
            this.Def = part;
        }

        @Nonnull
        public VehiclePartPath GetPath() {
            return this.Path != null ? this.Path : VehiclePartPath.Invalid;
        }

        @Nonnull
        public String PartName() {
            return this.Def.partName;
        }

        public void IterateRootToThis(@Nonnull Consumer<VehicleNode> func) {
            if (this.ParentNode != null) {
                this.ParentNode.IterateRootToThis(func);
            }
            func.accept(this);
        }

        public void IterateThisToRoot(@Nonnull Consumer<VehicleNode> func) {
            func.accept(this);
            if (this.ParentNode != null) {
                this.ParentNode.IterateRootToThis(func);
            }
        }
    }
}

