/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.controls;

import com.flansmod.common.FlansMod;
import com.flansmod.common.types.elements.EPlayerInput;
import com.flansmod.common.types.vehicles.ControlSchemeDefinition;
import com.flansmod.common.types.vehicles.EVehicleAxis;
import com.flansmod.common.types.vehicles.elements.ControlSchemeAxisDefinition;
import com.flansmod.common.types.vehicles.elements.EAxisBehaviourType;
import com.flansmod.physics.common.util.Maths;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class VehicleInputState {
    public Map<EVehicleAxis, Float> AxisInputs = new HashMap<EVehicleAxis, Float>();
    public Map<EPlayerInput, Boolean> AdditionalInputs = new HashMap<EPlayerInput, Boolean>();
    public Map<EVehicleAxis, Float> AxisValues = new HashMap<EVehicleAxis, Float>();

    public void SetInput(@Nonnull EPlayerInput input, boolean pressed) {
        this.AdditionalInputs.put(input, pressed);
    }

    public void SetInput(@Nonnull EVehicleAxis control, float value) {
        if (control != EVehicleAxis.Unset) {
            this.AxisInputs.put(control, Float.valueOf(value));
        } else {
            FlansMod.LOGGER.warn("Passing Unset control input to vehicle input state?");
        }
    }

    public boolean GetInput(@Nonnull EPlayerInput input) {
        return this.AdditionalInputs.getOrDefault((Object)input, false);
    }

    public float GetInput(@Nonnull EVehicleAxis axisType) {
        return this.AxisInputs.getOrDefault((Object)axisType, Float.valueOf(0.0f)).floatValue();
    }

    public void SetValue(@Nonnull EVehicleAxis control, float value) {
        this.AxisValues.put(control, Float.valueOf(value));
    }

    public float GetValue(@Nonnull EVehicleAxis control) {
        return this.AxisValues.getOrDefault((Object)control, Float.valueOf(0.0f)).floatValue();
    }

    public void Tick(@Nonnull ControlSchemeDefinition def) {
        for (ControlSchemeAxisDefinition axisDef : def.axes) {
            this.TickAxis(axisDef);
        }
    }

    public float TickAxis(@Nonnull ControlSchemeAxisDefinition axisDef) {
        float axisInput = this.GetInput(axisDef.axisType);
        float axisValue = this.GetValue(axisDef.axisType);
        if (Maths.approx(axisInput, 0.0f) && axisDef.axisBehaviour == EAxisBehaviourType.SliderWithRestPosition) {
            axisInput = Maths.sign(axisDef.restingPosition - axisValue);
        }
        float newValue = axisValue + axisInput;
        if (axisDef.axisBehaviour == EAxisBehaviourType.Notched) {
            for (float notch : axisDef.notches) {
                if (newValue > notch && axisValue < notch) {
                    newValue = notch;
                }
                if (!(newValue < notch) || !(axisValue > notch)) continue;
                newValue = notch;
            }
        }
        newValue = Maths.clamp(newValue, axisDef.minValue, axisDef.maxValue);
        this.SetValue(axisDef.axisType, newValue);
        return newValue;
    }
}

