/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle;

import com.flansmod.client.input.ClientInputHooks;
import com.flansmod.common.FlansMod;
import com.flansmod.common.entity.vehicle.ISegmentedEntity;
import com.flansmod.common.entity.vehicle.PerPartMap;
import com.flansmod.common.entity.vehicle.VehicleHitResult;
import com.flansmod.common.entity.vehicle.VehicleInventory;
import com.flansmod.common.entity.vehicle.controls.ControlLogic;
import com.flansmod.common.entity.vehicle.controls.ControlLogics;
import com.flansmod.common.entity.vehicle.controls.VehicleInputState;
import com.flansmod.common.entity.vehicle.hierarchy.EPartDefComponent;
import com.flansmod.common.entity.vehicle.hierarchy.MultiLookup;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleDefinitionHierarchy;
import com.flansmod.common.entity.vehicle.hierarchy.VehiclePartPath;
import com.flansmod.common.entity.vehicle.modules.IVehicleDamageHelper;
import com.flansmod.common.entity.vehicle.modules.IVehicleEngineModule;
import com.flansmod.common.entity.vehicle.modules.IVehicleSeatHelper;
import com.flansmod.common.entity.vehicle.modules.IVehicleTransformHelpers;
import com.flansmod.common.entity.vehicle.save.ArticulationSyncState;
import com.flansmod.common.entity.vehicle.save.DamageSyncState;
import com.flansmod.common.entity.vehicle.save.EngineSyncState;
import com.flansmod.common.entity.vehicle.save.GunSyncState;
import com.flansmod.common.entity.vehicle.save.SeatSyncState;
import com.flansmod.common.entity.vehicle.save.VehiclePropellerSaveState;
import com.flansmod.common.entity.vehicle.save.WheelSyncState;
import com.flansmod.common.item.GunItem;
import com.flansmod.common.network.FlansEntityDataSerializers;
import com.flansmod.common.types.LazyDefinition;
import com.flansmod.common.types.parts.elements.EngineDefinition;
import com.flansmod.common.types.vehicles.ControlSchemeDefinition;
import com.flansmod.common.types.vehicles.VehicleDefinition;
import com.flansmod.common.types.vehicles.elements.ControlSchemeAxisDefinition;
import com.flansmod.common.types.vehicles.elements.DamageablePartDefinition;
import com.flansmod.common.types.vehicles.elements.EControlLogicHint;
import com.flansmod.common.types.vehicles.elements.InputDefinition;
import com.flansmod.common.types.vehicles.elements.VehicleControlOptionDefinition;
import com.flansmod.common.types.vehicles.elements.VehiclePartDefinition;
import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.collision.ColliderHandle;
import com.flansmod.physics.common.collision.ICollisionSystem;
import com.flansmod.physics.common.entity.PhysicsComponent;
import com.flansmod.physics.common.entity.PhysicsEntity;
import com.flansmod.physics.common.units.IAcceleration;
import com.flansmod.physics.common.units.LinearForce;
import com.flansmod.physics.common.util.ITransformPair;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.TransformStack;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;

public class VehicleEntity
extends PhysicsEntity
implements ISegmentedEntity,
IVehicleEngineModule,
IVehicleTransformHelpers,
IVehicleSeatHelper,
IVehicleDamageHelper {
    public static final EntityDataAccessor<PerPartMap<EngineSyncState>> ENGINES_ACCESSOR = SynchedEntityData.m_135353_(VehicleEntity.class, FlansEntityDataSerializers.ENGINE_MAP);
    public static final EntityDataAccessor<PerPartMap<ArticulationSyncState>> ARTICULATIONS_ACCESSOR = SynchedEntityData.m_135353_(VehicleEntity.class, FlansEntityDataSerializers.ARTICULATION_MAP);
    public static final EntityDataAccessor<PerPartMap<SeatSyncState>> SEATS_ACCESSOR = SynchedEntityData.m_135353_(VehicleEntity.class, FlansEntityDataSerializers.SEAT_MAP);
    public static final EntityDataAccessor<PerPartMap<DamageSyncState>> DAMAGE_ACCESSOR = SynchedEntityData.m_135353_(VehicleEntity.class, FlansEntityDataSerializers.DAMAGE_MAP);
    public static final EntityDataAccessor<PerPartMap<GunSyncState>> GUNS_ACCESSOR = SynchedEntityData.m_135353_(VehicleEntity.class, FlansEntityDataSerializers.GUN_MAP);
    public static final EntityDataAccessor<PerPartMap<WheelSyncState>> WHEELS_ACCESSOR = SynchedEntityData.m_135353_(VehicleEntity.class, FlansEntityDataSerializers.WHEEL_MAP);
    public static final int INVALID_SEAT_INDEX = -1;
    public static final String INVALID_SEAT_PATH = "body/seat_-1";
    @Nonnull
    private final LazyDefinition<VehicleDefinition> DefRef;
    private final Lazy<VehicleInventory> LazyInventory = Lazy.of(this::CreateInventory);
    public final MultiLookup<EControlLogicHint, VehiclePartPath> Articulations = new MultiLookup();
    public final MultiLookup<EControlLogicHint, VehiclePropellerSaveState> Propellers = new MultiLookup();
    public final Map<ResourceLocation, ControlLogic> Controllers = new HashMap<ResourceLocation, ControlLogic>();
    @Nonnull
    public final List<VehicleComponentPath> SeatOrdering = new ArrayList<VehicleComponentPath>();
    @Nonnull
    public final List<VehicleComponentPath> GunOrdering = new ArrayList<VehicleComponentPath>();
    @Nonnull
    private ResourceLocation SelectedControllerLocation = new ResourceLocation("flansmod", "control_schemes/null");
    @Nonnull
    public final Map<VehicleComponentPath, PhysicsComponent> PhysicsParts = new HashMap<VehicleComponentPath, PhysicsComponent>();
    @Nonnull
    public ResourceLocation SelectedSkin;
    @Nonnull
    public final Map<String, VehicleInputState> InputStates = new HashMap<String, VehicleInputState>();
    @Nonnull
    public final Map<String, String> ModalStates = new HashMap<String, String>();

    @Nonnull
    public VehicleDefinition Def() {
        return (VehicleDefinition)this.DefRef.DefGetter().get();
    }

    @Nonnull
    public ResourceLocation Loc() {
        return this.DefRef.Loc();
    }

    @Nonnull
    public VehicleInventory Inventory() {
        return (VehicleInventory)this.LazyInventory.get();
    }

    public VehicleEntity(@Nonnull EntityType<? extends Entity> type, @Nonnull ResourceLocation defLoc, @Nonnull Level world) {
        super(type, world);
        this.DefRef = LazyDefinition.of(defLoc, FlansMod.VEHICLES);
        this.SelectedSkin = defLoc;
        this.f_19850_ = true;
        this.InitFromDefinition();
    }

    @Override
    public void m_142687_(@Nonnull Entity.RemovalReason reason) {
        super.m_142687_(reason);
        this.StopPhysics();
    }

    public boolean InitFromDefinition() {
        VehicleDefinition def = this.Def();
        if (!def.IsValid()) {
            return false;
        }
        this.SelectedControllerLocation = def.defaultControlScheme;
        return true;
    }

    public static boolean canVehicleCollide(@Nonnull Entity a, @Nonnull Entity b) {
        return (b.m_5829_() || b.m_6094_()) && !a.m_20365_(b);
    }

    public boolean m_7337_(@Nonnull Entity other) {
        return VehicleEntity.canVehicleCollide(this, other);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_19956_(@Nonnull Entity rider, @Nonnull Entity.MoveFunction moveFunc) {
        if (this.m_20363_(rider)) {
            int n = this.GetSeatIndexOf(rider);
        }
    }

    @Nonnull
    public Vec3 m_7688_(@Nonnull LivingEntity p_38357_) {
        Vec3 vec3 = VehicleEntity.m_19903_((double)(this.m_20205_() * Mth.f_13994_), (double)p_38357_.m_20205_(), (float)p_38357_.m_146908_());
        return vec3;
    }

    public float m_146908_() {
        return this.getRootTransform().current().yaw();
    }

    public float m_146909_() {
        return this.getRootTransform().current().pitch();
    }

    public void m_146922_(float yaw) {
        this.SetYaw(yaw);
    }

    public void m_146926_(float pitch) {
        this.SetPitch(pitch);
    }

    public void m_7678_(double x, double y, double z, float xRot, float yRot) {
        super.m_7678_(x, y, z, xRot, yRot);
        this.CheckInitPhysics();
        this.SetAllPositionsFromEntity();
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int i, boolean flag) {
        super.m_6453_(x, y, z, yaw, pitch, i, flag);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.f_19860_ = pitch;
        this.f_19859_ = yaw;
        this.syncEntityToTransform();
    }

    protected void m_20090_() {
        super.m_20090_();
        this.SetAllPositionsFromEntity();
    }

    private void SetAllPositionsFromEntity() {
        this.syncEntityToTransform();
    }

    @Override
    public void SetEulerAngles(float pitch, float yaw, float roll) {
        this.SetEulerAngles(pitch, yaw, roll);
    }

    @Nonnull
    public Transform RootTransformCurrent() {
        return this.GetWorldToRoot().current();
    }

    @Nonnull
    public Transform RootTransformPrevious() {
        return this.GetWorldToRoot().previous();
    }

    @Nonnull
    public Transform RootTransform(float dt) {
        return this.GetWorldToRoot().delta(dt);
    }

    @Nonnull
    private VehicleInputState GetInputStateFor(@Nonnull String key) {
        VehicleInputState inputState = this.InputStates.get(key);
        if (inputState == null) {
            inputState = new VehicleInputState();
            this.InputStates.put(key, inputState);
        }
        return inputState;
    }

    @Nonnull
    public VehicleInputState GetMiscInputState() {
        return this.GetInputStateFor("misc");
    }

    @Nonnull
    public VehicleInputState GetInputStateFor(@Nonnull ControlSchemeDefinition controlScheme) {
        return this.GetInputStateFor(controlScheme.Location.toString());
    }

    @Nonnull
    public VehicleInputState GetInputStateFor(@Nonnull ControlLogic controller) {
        return this.GetInputStateFor(controller.Def.Location.toString());
    }

    public boolean IsAuthority() {
        return this.m_6109_();
    }

    public boolean IsValidator() {
        return !this.m_9236_().f_46443_;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ENGINES_ACCESSOR, new PerPartMap());
        this.f_19804_.m_135372_(ARTICULATIONS_ACCESSOR, new PerPartMap());
        this.f_19804_.m_135372_(SEATS_ACCESSOR, new PerPartMap());
        this.f_19804_.m_135372_(GUNS_ACCESSOR, new PerPartMap());
        this.f_19804_.m_135372_(DAMAGE_ACCESSOR, new PerPartMap());
        this.f_19804_.m_135372_(WHEELS_ACCESSOR, new PerPartMap());
    }

    protected void m_7378_(@Nonnull CompoundTag tags) {
        if (tags.m_128441_("engine")) {
            this.LoadEngineData(tags.m_128469_("engine"));
        }
        if (tags.m_128441_("articulation")) {
            this.LoadArticulation(tags.m_128469_("articulation"));
        }
        if (tags.m_128441_("seats")) {
            this.LoadSeatState(tags.m_128469_("seats"));
        }
        if (tags.m_128441_("damage")) {
            this.LoadDamageState(tags.m_128469_("damage"));
        }
        if (tags.m_128441_("guns")) {
            this.LoadGunState(tags.m_128469_("guns"));
        }
        if (tags.m_128441_("wheels")) {
            this.LoadWheelState(tags.m_128469_("wheels"));
        }
    }

    protected void m_7380_(@Nonnull CompoundTag tags) {
        tags.m_128365_("engine", (Tag)this.SaveEngineData());
        tags.m_128365_("articulation", (Tag)this.SaveArticulation());
        tags.m_128365_("seats", (Tag)this.SaveSeatState());
        tags.m_128365_("damage", (Tag)this.SaveDamageState());
        tags.m_128365_("guns", (Tag)this.SaveGunState());
        tags.m_128365_("wheels", (Tag)this.SaveWheelState());
    }

    @Nonnull
    protected AABB m_142242_() {
        return super.m_142242_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.TickControlSchemes();
        this.TickPhysics();
    }

    protected boolean m_7310_(@Nonnull Entity entity) {
        int seatIndex = this.GetSeatIndexForNewPassenger(entity);
        return seatIndex != -1;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.GetControllingPassenger(this);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    @Nonnull
    public InteractionResult m_6096_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_) {
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    private PerPartMap<ArticulationSyncState> GetArticulationMap() {
        return (PerPartMap)this.f_19804_.m_135370_(ARTICULATIONS_ACCESSOR);
    }

    private void SetArticulationMap(@Nonnull PerPartMap<ArticulationSyncState> map) {
        this.f_19804_.m_135381_(ARTICULATIONS_ACCESSOR, map);
    }

    public void SetArticulationParameter(@Nonnull VehicleComponentPath componentPath, float parameter) {
        PerPartMap<ArticulationSyncState> map = this.GetArticulationMap();
        map.ApplyTo(componentPath, state -> state.SetParameter(parameter));
        this.SetArticulationMap(map);
    }

    public float GetArticulationParameter(@Nonnull VehicleComponentPath componentPath) {
        return this.GetArticulationMap().ApplyOrDefault(componentPath, ArticulationSyncState::GetParameter, Float.valueOf(0.0f)).floatValue();
    }

    public void SetArticulationVelocity(@Nonnull VehicleComponentPath componentPath, float velocity) {
        PerPartMap<ArticulationSyncState> map = this.GetArticulationMap();
        map.ApplyTo(componentPath, state -> state.SetVelocity(velocity));
        this.SetArticulationMap(map);
    }

    public float GetArticulationVelocity(@Nonnull VehicleComponentPath componentPath) {
        return this.GetArticulationMap().ApplyOrDefault(componentPath, ArticulationSyncState::GetVelocity, Float.valueOf(0.0f)).floatValue();
    }

    @Nonnull
    public Transform GetArticulationTransformPrevious(@Nonnull VehicleComponentPath partName) {
        Optional<Transform> result = this.GetHierarchy().IfArticulated(partName, def -> {
            if (def != null && def.active) {
                float parameter = this.GetArticulationParameter(partName);
                float velocity = this.GetArticulationVelocity(partName);
                return def.Apply(parameter - velocity);
            }
            return null;
        });
        return result.orElse(Transform.IDENTITY);
    }

    @Nonnull
    public Transform GetArticulationTransformPrevious(@Nonnull VehiclePartPath partPath) {
        return this.GetArticulationTransformPrevious(partPath.Articulation());
    }

    @Nonnull
    public Transform GetArticulationTransformCurrent(@Nonnull VehicleComponentPath partName) {
        Optional<Transform> result = this.GetHierarchy().IfArticulated(partName, def -> {
            if (def != null && def.active) {
                float parameter = this.GetArticulationParameter(partName);
                return def.Apply(parameter);
            }
            return null;
        });
        return result.orElse(Transform.IDENTITY);
    }

    @Nonnull
    public Transform GetArticulationTransformCurrent(@Nonnull VehiclePartPath partPath) {
        return this.GetArticulationTransformCurrent(partPath.Articulation());
    }

    public boolean IsArticulated(@Nonnull VehiclePartPath part) {
        return this.GetArticulationMap().TryGet(part.Articulation()).isPresent();
    }

    @Override
    @Nonnull
    public VehicleDefinitionHierarchy GetHierarchy() {
        return this.Def().AsHierarchy();
    }

    @Override
    @Nonnull
    public Transform GetRootTransformCurrent() {
        return this.GetCorePhysics().getCurrentTransform();
    }

    @Override
    @Nonnull
    public Transform GetRootTransformPrevious() {
        return this.GetCorePhysics().getPreviousTransform();
    }

    @Override
    public void SetRootTransformCurrent(@Nonnull Transform transform) {
        this.TeleportTo(transform);
    }

    @Override
    public void ApplyWorldToRootPrevious(@Nonnull TransformStack stack) {
        stack.add(this.GetCorePhysics().getCurrentTransform());
    }

    @Override
    public void ApplyWorldToRootCurrent(@Nonnull TransformStack stack) {
        stack.add(this.GetCorePhysics().getPreviousTransform());
    }

    @Override
    public void ApplyPartToPartPrevious(@Nonnull VehiclePartPath partPath, @Nonnull TransformStack stack) {
        if (this.IsArticulated(partPath)) {
            stack.add(this.GetArticulationTransformPrevious(partPath));
        } else {
            stack.add((Transform)this.GetPartDef((VehiclePartPath)partPath).LocalTransform.get());
        }
    }

    @Override
    public void ApplyPartToPartCurrent(@Nonnull VehiclePartPath partPath, @Nonnull TransformStack stack) {
        if (this.IsArticulated(partPath)) {
            stack.add(this.GetArticulationTransformCurrent(partPath));
        } else {
            stack.add((Transform)this.GetPartDef((VehiclePartPath)partPath).LocalTransform.get());
        }
    }

    @Override
    public void ApplyPartToComponentPrevious(@Nonnull VehicleComponentPath componentPath, @Nonnull TransformStack stack) {
        if (componentPath.Type() == EPartDefComponent.Wheel) {
            stack.add(this.GetWorldToPartPrevious(componentPath.Part()).inverse());
            stack.add(this.GetPartPhysics(componentPath).getPreviousTransform());
        }
    }

    @Override
    public void ApplyPartToComponentCurrent(@Nonnull VehicleComponentPath componentPath, @Nonnull TransformStack stack) {
        if (componentPath.Type() == EPartDefComponent.Wheel) {
            stack.add(this.GetWorldToPartCurrent(componentPath.Part()).inverse());
            stack.add(this.GetPartPhysics(componentPath).getCurrentTransform());
        }
    }

    public void Raycast(@Nonnull Vec3 start, @Nonnull Vec3 end, float dt, @Nonnull List<HitResult> results) {
        this.Raycast(start, end, dt, (partPath, hitPos) -> results.add((HitResult)new VehicleHitResult(this, (VehiclePartPath)partPath)));
    }

    protected void LoadArticulation(@Nonnull CompoundTag tags) {
        for (String key : tags.m_128431_()) {
            CompoundTag articulationTags = tags.m_128469_(key);
            VehiclePartPath path = VehiclePartPath.of(key);
            this.SetArticulationParameter(path.Articulation(), articulationTags.m_128457_("param"));
            this.SetArticulationVelocity(path.Articulation(), articulationTags.m_128457_("velocity"));
        }
    }

    @Nonnull
    protected CompoundTag SaveArticulation() {
        PerPartMap<ArticulationSyncState> map = this.GetArticulationMap();
        CompoundTag tags = new CompoundTag();
        this.GetHierarchy().ForEachArticulatedPart((path, def) -> {
            CompoundTag articulationTags = new CompoundTag();
            articulationTags.m_128350_("param", this.GetArticulationParameter((VehicleComponentPath)path));
            articulationTags.m_128350_("velocity", this.GetArticulationVelocity((VehicleComponentPath)path));
            tags.m_128365_(path.toString(), (Tag)articulationTags);
        });
        return tags;
    }

    @Override
    @Nonnull
    public PerPartMap<DamageSyncState> GetDamageMap() {
        return (PerPartMap)this.f_19804_.m_135370_(DAMAGE_ACCESSOR);
    }

    @Override
    public void SetDamageMap(@Nonnull PerPartMap<DamageSyncState> map) {
        this.f_19804_.m_135381_(DAMAGE_ACCESSOR, map);
    }

    @Override
    @Nonnull
    public DamageablePartDefinition GetDef(@Nonnull VehicleComponentPath partPath) {
        return this.GetHierarchy().FindDamageable(partPath).orElse(DamageablePartDefinition.INVALID);
    }

    @Nonnull
    public VehiclePartDefinition GetPartDef(@Nonnull VehiclePartPath partPath) {
        return this.GetHierarchy().FindNode(partPath).flatMap(node -> Optional.of(node.Def)).orElse(VehiclePartDefinition.INVALID);
    }

    protected void LoadDamageState(@Nonnull CompoundTag tags) {
        for (String key : tags.m_128431_()) {
            CompoundTag partTags = tags.m_128469_(key);
            VehicleComponentPath path = VehicleComponentPath.of(key);
            if (this.HasDamageablePart(path)) {
                this.SetHealthOf(path, partTags.m_128457_("hp"));
                continue;
            }
            FlansMod.LOGGER.warn("Damage key " + key + " was stored in vehicle save data, but this vehicle doesn't have that part");
        }
    }

    @Nonnull
    protected CompoundTag SaveDamageState() {
        CompoundTag tags = new CompoundTag();
        this.GetHierarchy().ForEachDamageable((partPath, damageDef) -> {
            CompoundTag partTags = new CompoundTag();
            partTags.m_128350_("hp", this.GetHealthOf((VehicleComponentPath)partPath));
            tags.m_128365_(partPath.toString(), (Tag)partTags);
        });
        return tags;
    }

    @Nonnull
    public PhysicsComponent GetPartPhysics(@Nonnull VehicleComponentPath path) {
        return this.PhysicsParts.getOrDefault(path, PhysicsComponent.invalid);
    }

    @Nonnull
    public PhysicsComponent GetCorePhysics() {
        return this.PhysicsParts.getOrDefault(VehicleComponentPath.coreArticulation, PhysicsComponent.invalid);
    }

    @Nonnull
    public List<IAcceleration> GetCoreForces() {
        return this.GetCorePhysics().getCurrentForces();
    }

    @Nonnull
    public List<IAcceleration> GetForcesOn(@Nonnull VehicleComponentPath path) {
        return this.GetPartPhysics(path).getCurrentForces();
    }

    @Nonnull
    public ColliderHandle GetCorePhsyicsHandle() {
        return this.GetCorePhysics().getPhysicsHandle();
    }

    @Nonnull
    public ColliderHandle GetPhysicsHandle(@Nonnull VehicleComponentPath path) {
        return this.GetPartPhysics(path).getPhysicsHandle();
    }

    public void AddForceTo(@Nonnull VehicleComponentPath path) {
    }

    @Override
    protected void tickPhysics() {
    }

    @Override
    protected void tickOutsidePhysicsRange() {
    }

    protected void CheckInitPhysics() {
        if (this.PhysicsParts.isEmpty()) {
            this.InitPhysics();
        }
    }

    protected void InitPhysics() {
        Map<VehiclePartPath, ImmutableList<AABB>> bbLists = this.GatherBBs();
        ICollisionSystem physics = FlansPhysicsMod.forLevel(this.m_9236_());
        for (Map.Entry<VehiclePartPath, ImmutableList<AABB>> kvp : bbLists.entrySet()) {
            ColliderHandle handle;
            if (kvp.getKey().IsRoot()) {
                Transform spawnedTransform = Transform.fromEntity(this);
                handle = physics.registerDynamic((List)kvp.getValue(), spawnedTransform, 1.0);
                this.PhysicsParts.put(VehicleComponentPath.coreArticulation, new PhysicsComponent(spawnedTransform, this.m_9236_().m_46467_(), handle));
                continue;
            }
            Transform t = this.GetWorldToPartCurrent(kvp.getKey());
            handle = physics.registerDynamic((List)kvp.getValue(), t, 1.0);
            this.PhysicsParts.put(kvp.getKey().Articulation(), new PhysicsComponent(t, this.m_9236_().m_46467_(), handle));
        }
        this.Def().AsHierarchy().ForEachWheel((wheelPath, wheelDef) -> {
            Transform t = this.GetWorldToPartCurrent((VehicleComponentPath)wheelPath);
            ColliderHandle handle = physics.registerDynamic(List.of(new AABB((double)(-wheelDef.radius), (double)(-wheelDef.radius), (double)(-wheelDef.radius), (double)wheelDef.radius, (double)wheelDef.radius, (double)wheelDef.radius)), t, 0.25);
            this.PhysicsParts.put((VehicleComponentPath)wheelPath, new PhysicsComponent(t, this.m_9236_().m_46467_(), handle));
        });
    }

    protected void StopPhysics() {
        ICollisionSystem physics = FlansPhysicsMod.forLevel(this.m_9236_());
        for (PhysicsComponent part : this.PhysicsParts.values()) {
            part.unregister(physics);
        }
        this.PhysicsParts.clear();
    }

    public void TeleportTo(@Nonnull Transform transform) {
    }

    protected void CopyResponsesToForceModel(@Nonnull ICollisionSystem physics, @Nullable ControlLogic controller) {
        if (FlansPhysicsMod.PAUSE_PHYSICS) {
            return;
        }
        for (Map.Entry<VehicleComponentPath, PhysicsComponent> kvp : this.PhysicsParts.entrySet()) {
            VehicleComponentPath path = kvp.getKey();
            PhysicsComponent part = kvp.getValue();
            part.syncCollisionToComponent(physics);
        }
    }

    protected void TickController(@Nullable ControlLogic controller) {
        if (FlansPhysicsMod.PAUSE_PHYSICS) {
            return;
        }
        if (controller != null) {
            VehicleInputState inputs = this.GetInputStateFor(controller);
            if (this.IsAuthority()) {
                controller.TickAuthoritative(this, inputs);
            } else {
                controller.TickRemote(this, inputs);
            }
            if (Double.isNaN(this.m_20182_().f_82479_) || Double.isNaN(this.m_20182_().f_82480_) || Double.isNaN(this.m_20182_().f_82481_)) {
                FlansMod.LOGGER.error("Vehicle went to NaNsville. Reverting one frame");
                this.m_6034_(this.f_19790_, this.f_19791_, this.f_19792_);
            }
        } else {
            LinearForce coreGravity = LinearForce.kgBlocksPerSecondSq(new Vec3(0.0, (double)(-9.81f * this.Def().physics.mass), 0.0));
            this.GetCorePhysics().getPendingForces().addForce(coreGravity);
            this.GetCorePhysics().getPendingForces().addDampener(0.1f);
            this.GetHierarchy().ForEachWheel((path, def) -> {
                LinearForce wheelGravity = LinearForce.kgBlocksPerSecondSq(new Vec3(0.0, (double)(-9.81f * def.mass), 0.0));
                this.GetPartPhysics((VehicleComponentPath)path).getPendingForces().addForce(wheelGravity);
                this.GetPartPhysics((VehicleComponentPath)path).getPendingForces().addDampener(0.1f);
            });
        }
    }

    protected void SendNewForcesToPhysics(@Nonnull ICollisionSystem physics) {
        if (FlansPhysicsMod.PAUSE_PHYSICS) {
            return;
        }
        PhysicsComponent corePhysics = this.GetCorePhysics();
        corePhysics.syncComponentToCollision(physics);
        this.GetHierarchy().ForEachWheel((path, def) -> {
            PhysicsComponent wheelPhysics = this.GetPartPhysics((VehicleComponentPath)path);
            wheelPhysics.syncComponentToCollision(physics);
        });
    }

    protected void TickPhysics() {
        ControlLogic controller = this.CurrentController();
        ICollisionSystem physics = FlansPhysicsMod.forLevel(this.m_9236_());
        AABB physicsBounds = null;
        for (PhysicsComponent part : this.PhysicsParts.values()) {
            if (!part.getPhysicsHandle().IsValid()) continue;
            if (physics.isHandleInvalidated(part.getPhysicsHandle())) {
                part.unregister(physics);
                continue;
            }
            if (physicsBounds == null) {
                physicsBounds = new AABB(part.getCurrentTransform().positionVec3(), part.getCurrentTransform().positionVec3());
                continue;
            }
            physicsBounds = physicsBounds.m_82369_(part.getCurrentTransform().positionVec3());
        }
        if (physicsBounds != null && (physicsBounds.m_82362_() > 1024.0 || physicsBounds.m_82376_() > 1024.0 || physicsBounds.m_82385_() > 1024.0)) {
            this.StopPhysics();
            return;
        }
        this.CopyResponsesToForceModel(physics, controller);
        this.syncTransformToEntity();
        this.TickController(controller);
        this.SendNewForcesToPhysics(physics);
        if (this.IsAuthority()) {
            // empty if block
        }
    }

    public void SetWheelSaveData(@Nonnull PerPartMap<WheelSyncState> map) {
        this.f_19804_.m_135381_(WHEELS_ACCESSOR, map);
    }

    @Nonnull
    public PerPartMap<WheelSyncState> GetWheelSaveData() {
        return (PerPartMap)this.f_19804_.m_135370_(WHEELS_ACCESSOR);
    }

    protected void LoadWheelState(@Nonnull CompoundTag tags) {
        PerPartMap<WheelSyncState> map = this.GetWheelSaveData();
        for (String key : tags.m_128431_()) {
            VehicleComponentPath path = VehicleComponentPath.of(key);
            WheelSyncState wheelState = new WheelSyncState();
            wheelState.Load(this, tags.m_128469_(key));
            map.Put(path, wheelState);
        }
        this.SetWheelSaveData(map);
    }

    @Nonnull
    protected CompoundTag SaveWheelState() {
        PerPartMap<WheelSyncState> map = this.GetWheelSaveData();
        CompoundTag tags = new CompoundTag();
        this.GetHierarchy().ForEachWheel((partPath, wheelDef) -> map.TryGet((VehicleComponentPath)partPath).ifPresent(wheelState -> tags.m_128365_(partPath.toString(), (Tag)wheelState.Save(this))));
        return tags;
    }

    @Nonnull
    private Map<VehiclePartPath, ImmutableList<AABB>> GatherBBs() {
        HashMap<VehiclePartPath, ImmutableList<AABB>> completedLists = new HashMap<VehiclePartPath, ImmutableList<AABB>>();
        ImmutableList.Builder rootObject = new ImmutableList.Builder();
        VehicleDefinitionHierarchy.VehicleNode rootNode = this.GetHierarchy().RootNode;
        this.GatherBBs(rootNode, (ImmutableList.Builder<AABB>)rootObject, completedLists);
        completedLists.put(rootNode.GetPath(), (ImmutableList<AABB>)rootObject.build());
        return completedLists;
    }

    private void GatherBBs(@Nonnull VehicleDefinitionHierarchy.VehicleNode node, @Nonnull ImmutableList.Builder<AABB> aabbListBuilder, @Nonnull Map<VehiclePartPath, ImmutableList<AABB>> completedLists) {
        if (node.Def.IsArticulated()) {
            ImmutableList.Builder articulatedObject = new ImmutableList.Builder();
            if (node.Def.IsDamageable()) {
                articulatedObject.add((Object)((AABB)node.Def.damage.Hitbox.get()));
            }
            for (VehicleDefinitionHierarchy.VehicleNode child : node.ChildNodes.values()) {
                this.GatherBBs(child, (ImmutableList.Builder<AABB>)articulatedObject, completedLists);
            }
            completedLists.put(node.GetPath(), (ImmutableList<AABB>)articulatedObject.build());
        } else {
            if (node.Def.IsDamageable()) {
                aabbListBuilder.add((Object)((AABB)node.Def.damage.Hitbox.get()));
            }
            for (VehicleDefinitionHierarchy.VehicleNode child : node.ChildNodes.values()) {
                this.GatherBBs(child, aabbListBuilder, completedLists);
            }
        }
    }

    @Override
    @Nonnull
    public EngineDefinition GetDefaultEngine() {
        return this.Def().defaultEngine;
    }

    @Override
    @Nonnull
    public PerPartMap<EngineSyncState> GetEngineSaveData() {
        return (PerPartMap)this.f_19804_.m_135370_(ENGINES_ACCESSOR);
    }

    @Override
    public void SetEngineSaveData(@Nonnull PerPartMap<EngineSyncState> map) {
        this.f_19804_.m_135381_(ENGINES_ACCESSOR, map);
    }

    @Override
    public void ModifyEngineSaveData(@Nonnull VehicleComponentPath enginePath, @Nonnull Consumer<EngineSyncState> func) {
        PerPartMap<EngineSyncState> map = this.GetEngineSaveData();
        map.CreateAndApply(enginePath, EngineSyncState::new, func);
        this.SetEngineSaveData(map);
    }

    protected void LoadEngineData(@Nonnull CompoundTag tags) {
        PerPartMap<EngineSyncState> engineMap = this.GetEngineSaveData();
        for (String key : tags.m_128431_()) {
            VehicleComponentPath path = VehicleComponentPath.of(key);
            engineMap.CreateAndApply(path, EngineSyncState::new, state -> state.Load(this, tags.m_128469_(key)));
        }
        this.SetEngineSaveData(engineMap);
    }

    @Nonnull
    protected CompoundTag SaveEngineData() {
        PerPartMap<EngineSyncState> map = this.GetEngineSaveData();
        CompoundTag tags = new CompoundTag();
        return tags;
    }

    @Override
    @Nonnull
    public List<VehicleComponentPath> GetSeatOrdering() {
        return this.SeatOrdering;
    }

    @Override
    @Nonnull
    public PerPartMap<SeatSyncState> GetSeatSaveData() {
        return (PerPartMap)this.f_19804_.m_135370_(SEATS_ACCESSOR);
    }

    @Override
    public void SetSeatSaveData(@Nonnull PerPartMap<SeatSyncState> map) {
        this.f_19804_.m_135381_(SEATS_ACCESSOR, map);
    }

    public void LoadSeatState(@Nonnull CompoundTag tags) {
        PerPartMap<SeatSyncState> seatMap = this.GetSeatSaveData();
        for (String key : tags.m_128431_()) {
            VehicleComponentPath path = VehicleComponentPath.of(key);
            seatMap.CreateAndApply(path, SeatSyncState::new, state -> state.Load(this, tags.m_128469_(key)));
        }
        this.SetSeatSaveData(seatMap);
    }

    @Nonnull
    public CompoundTag SaveSeatState() {
        PerPartMap<SeatSyncState> map = this.GetSeatSaveData();
        CompoundTag tags = new CompoundTag();
        this.GetHierarchy().ForEachSeat((seatPath, seatDef) -> map.TryGet((VehicleComponentPath)seatPath).ifPresent(state -> tags.m_128365_(seatPath.toString(), (Tag)state.Save(this))));
        return tags;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void Client_GetLocalPlayerInputs(@Nonnull List<ControlSchemeDefinition> controlSchemes, @Nonnull InputDefinition[] additionalInputs) {
        for (ControlSchemeDefinition scheme : controlSchemes) {
            VehicleInputState inputs = this.GetInputStateFor(scheme);
            for (ControlSchemeAxisDefinition axis : scheme.axes) {
                float value = ClientInputHooks.GetInput(axis.axisType);
                inputs.SetInput(axis.axisType, value);
            }
        }
        for (InputDefinition input : additionalInputs) {
            VehicleInputState miscInputs = this.GetMiscInputState();
            miscInputs.SetInput(input.key, ClientInputHooks.GetInput(input.key));
        }
    }

    protected void TickControlSchemes() {
        HashMap statesToTick = new HashMap();
        for (int i = 0; i < this.SeatOrdering.size(); ++i) {
            VehicleComponentPath seatPath = this.SeatOrdering.get(i);
            this.GetHierarchy().IfSeatExists(seatPath, seatDef -> {
                Player player;
                Entity passenger = this.GetPassengerInSeat(seatPath, this.m_20197_());
                if (passenger != null && passenger instanceof Player && (player = (Player)passenger).m_7578_()) {
                    List<ControlSchemeDefinition> controlSchemes = this.GetActiveControllersForSeat(seatPath, this.ModalStates);
                    this.Client_GetLocalPlayerInputs(controlSchemes, seatDef.inputs);
                    for (ControlSchemeDefinition scheme : controlSchemes) {
                        statesToTick.put(scheme, this.GetInputStateFor(scheme));
                    }
                }
            });
        }
        for (Map.Entry kvp : statesToTick.entrySet()) {
            ((VehicleInputState)kvp.getValue()).Tick((ControlSchemeDefinition)kvp.getKey());
        }
    }

    public void SelectController(@Nonnull ControlSchemeDefinition controllerDef) {
        if (!this.Controllers.containsKey(controllerDef.GetLocation())) {
            ControlLogic controller = ControlLogics.InstanceControlLogic(controllerDef);
            if (controller != null) {
                this.Controllers.put(controllerDef.GetLocation(), controller);
                this.SelectedControllerLocation = controllerDef.GetLocation();
            } else {
                FlansMod.LOGGER.warn(this + ": Could not create control logic for '" + controllerDef.GetLocation() + "'");
            }
        }
    }

    @Nullable
    public ControlLogic CurrentController() {
        return this.Controllers.get(this.GetActiveControllerDef().GetLocation());
    }

    @Nonnull
    public Collection<ControlSchemeDefinition> GetValidControllersForSeat(@Nonnull VehicleComponentPath seatName) {
        Optional<Collection> result = this.GetHierarchy().IfSeatExists(seatName, seatDef -> ((Map)seatDef.Controllers.get()).values());
        return result.orElse(List.of());
    }

    @Nonnull
    public List<ControlSchemeDefinition> GetActiveControllersForSeat(@Nonnull VehicleComponentPath seatName, @Nonnull Map<String, String> modes) {
        Optional<List> result = this.GetHierarchy().IfSeatExists(seatName, seatDef -> {
            ArrayList<ControlSchemeDefinition> matches = new ArrayList<ControlSchemeDefinition>();
            for (VehicleControlOptionDefinition option : seatDef.controllerOptions) {
                if (!option.Passes(modes)) continue;
                matches.add((ControlSchemeDefinition)((Map)seatDef.Controllers.get()).get(option.key));
            }
            return matches;
        });
        return result.orElse(List.of());
    }

    @Nonnull
    public List<ControlSchemeDefinition> GetAllActiveControllers(@Nonnull Map<String, String> modes) {
        ArrayList<ControlSchemeDefinition> matches = new ArrayList<ControlSchemeDefinition>();
        this.GetHierarchy().ForEachSeat((seatPath, seatDef) -> {
            for (VehicleControlOptionDefinition option : seatDef.controllerOptions) {
                ControlSchemeDefinition scheme;
                if (!option.Passes(modes) || (scheme = (ControlSchemeDefinition)((Map)seatDef.Controllers.get()).get(option.key)) == null || matches.contains(scheme)) continue;
                matches.add(scheme);
            }
        });
        return matches;
    }

    @Nullable
    public ControlSchemeDefinition GetMainActiveController(@Nonnull Map<String, String> modes) {
        for (VehicleComponentPath seatName : this.GetSeatOrdering()) {
            List<ControlSchemeDefinition> activeForSeat = this.GetActiveControllersForSeat(seatName, modes);
            if (activeForSeat.size() > 1) {
                FlansMod.LOGGER.warn("Seat " + seatName + " has more than 1 control scheme active?");
            }
            if (activeForSeat.size() <= 0) continue;
            return activeForSeat.get(0);
        }
        return null;
    }

    @Nonnull
    public List<ControlSchemeDefinition> GetAllValidControllers() {
        ArrayList<ControlSchemeDefinition> list = new ArrayList<ControlSchemeDefinition>();
        this.GetHierarchy().ForEachSeat((partPath, seatDef) -> {
            for (ControlSchemeDefinition controlScheme : ((Map)seatDef.Controllers.get()).values()) {
                if (list.contains(controlScheme)) continue;
                list.add(controlScheme);
            }
        });
        return list;
    }

    public void SetGunSaveData(@Nonnull PerPartMap<GunSyncState> map) {
        this.f_19804_.m_135381_(GUNS_ACCESSOR, map);
    }

    @Nonnull
    public PerPartMap<GunSyncState> GetGunSaveData() {
        return (PerPartMap)this.f_19804_.m_135370_(GUNS_ACCESSOR);
    }

    protected void InitGuns() {
        this.GetHierarchy().ForEachGun((partPath, gunDef) -> this.GunOrdering.add((VehicleComponentPath)partPath));
    }

    public void SetGunState(@Nonnull VehicleComponentPath partName, @Nonnull GunSyncState gunState) {
        PerPartMap<GunSyncState> map = this.GetGunSaveData();
        map.Put(partName, gunState);
        this.SetGunSaveData(map);
    }

    public void SetGunState(int index, @Nonnull GunSyncState gunState) {
        this.SetGunState(this.GunOrdering.get(index), gunState);
    }

    @Nonnull
    public GunSyncState GetGunStateAtIndex(int index) {
        return this.GetGunSaveData().GetOrDefault(this.GunOrdering.get(index), GunSyncState.INVALID);
    }

    @Nonnull
    public VehicleComponentPath GetVehiclePartNameOfGunAtIndex(int index) {
        return this.GunOrdering.get(index);
    }

    @Nonnull
    public UUID GetGunIDAtIndex(int index) {
        return this.GetGunStateAtIndex(index).GetGunID();
    }

    public int GetIndexOfGunID(@Nonnull UUID gunID) {
        for (int i = 0; i < this.GunOrdering.size(); ++i) {
            if (!this.GetGunStateAtIndex(i).GetGunID().equals(gunID)) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    public List<UUID> GetAllGunIDs() {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (GunSyncState state : this.GetGunSaveData().Values()) {
            UUID id = state.GetGunID();
            if (id.equals(GunItem.InvalidGunUUID)) continue;
            uuids.add(id);
        }
        return uuids;
    }

    protected void LoadGunState(@Nonnull CompoundTag tags) {
        PerPartMap<GunSyncState> map = this.GetGunSaveData();
        for (String key : tags.m_128431_()) {
            VehicleComponentPath path = VehicleComponentPath.of(key);
            GunSyncState gunState = new GunSyncState();
            gunState.Load(this, tags.m_128469_(key));
            map.Put(path, gunState);
        }
        this.SetGunSaveData(map);
    }

    @Nonnull
    protected CompoundTag SaveGunState() {
        PerPartMap<GunSyncState> map = this.GetGunSaveData();
        CompoundTag tags = new CompoundTag();
        this.GetHierarchy().ForEachGun((partPath, gunDef) -> map.TryGet((VehicleComponentPath)partPath).ifPresent(gunState -> tags.m_128365_(partPath.toString(), (Tag)gunState.Save(this))));
        return tags;
    }

    @Nonnull
    private VehicleInventory CreateInventory() {
        VehicleDefinition def = this.Def();
        return new VehicleInventory(1, 1, 1);
    }

    public double GetSpeedXZ() {
        return Maths.lengthXZ(this.m_20184_());
    }

    public double GetSpeed() {
        return Maths.lengthXYZ(this.m_20184_());
    }

    @Nonnull
    public ControlSchemeDefinition GetActiveControllerDef() {
        ControlSchemeDefinition active = this.GetMainActiveController(this.ModalStates);
        return active != null ? active : ControlSchemeDefinition.INVALID;
    }

    @Override
    public void teleportTo(@Nonnull Transform currentTransform) {
        this.TeleportTo(currentTransform);
    }

    @Override
    @Nonnull
    public ITransformPair getRootTransform() {
        return this.GetWorldToRoot();
    }

    @Override
    @Nonnull
    public ITransformPair getEntityToAP(@Nonnull VehiclePartPath apPath) {
        return this.GetRootToPart(apPath);
    }

    private void CheckCollisions() {
        Level level = this.m_9236_();
        List list = level.m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.m_20363_((Entity)this)) continue;
                this.m_7334_(entity);
            }
        }
    }
}

