/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.longdistance;

import com.flansmod.common.entity.longdistance.LongDistanceEntity;
import com.flansmod.common.entity.longdistance.LongDistanceEntitySystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ServerLongDistanceEntitySystem
extends LongDistanceEntitySystem {
    private final Map<UUID, TrackingEntry> Trackables = new HashMap<UUID, TrackingEntry>();
    private final Map<Player, TrackingList> Players = new HashMap<Player, TrackingList>();

    @Override
    @Nullable
    public LongDistanceEntity GetFor(@Nonnull UUID entityID) {
        if (this.Trackables.containsKey(entityID)) {
            return this.Trackables.get((Object)entityID).LongEntity;
        }
        return null;
    }

    @Override
    @Nonnull
    public Collection<LongDistanceEntity> GetAllLongEntities(@Nonnull Level level) {
        ArrayList<LongDistanceEntity> longEntities = new ArrayList<LongDistanceEntity>(this.Trackables.size());
        for (TrackingEntry entry : this.Trackables.values()) {
            if (entry.LongEntity.Dimension != level.m_46472_()) continue;
            longEntities.add(entry.LongEntity);
        }
        return longEntities;
    }

    public boolean IsTrackingLoadedEntity(@Nonnull UUID entityID) {
        return this.Trackables.containsKey(entityID) && this.Trackables.get(entityID).IsTrackedEntityLoaded();
    }

    public boolean IsTracking(@Nonnull UUID entityID) {
        return this.Trackables.containsKey(entityID);
    }

    public void OnTrackableEntitySpawn(@Nonnull Entity entity) {
        if (ServerLongDistanceEntitySystem.IsSupportedEntity(entity)) {
            UUID entityID = entity.m_20148_();
            if (this.Trackables.containsKey(entityID)) {
                TrackingEntry existing = this.Trackables.get(entityID);
                if (!existing.IsTrackedEntityLoaded()) {
                    this.OnEntityBecameLoaded(entityID, entity, existing.LongEntity);
                    this.Trackables.put(entityID, TrackingEntry.of(existing.LongEntity, entity));
                }
            } else {
                LongDistanceEntity longEntity = ServerLongDistanceEntitySystem.CreateFor(entity);
                if (longEntity != null) {
                    this.OnAddedLoadedEntity(entityID, entity, longEntity);
                    this.Trackables.put(entityID, TrackingEntry.of(longEntity, entity));
                }
            }
        }
    }

    public void OnTrackableEntityDespawn(@Nonnull Entity entity) {
        UUID entityID;
        if (ServerLongDistanceEntitySystem.IsSupportedEntity(entity) && this.Trackables.containsKey(entityID = entity.m_20148_())) {
            TrackingEntry existing = this.Trackables.get(entityID);
            this.OnEntityBecameUnloaded(entityID, entity, existing.LongEntity);
            this.Trackables.put(entityID, TrackingEntry.of(existing.LongEntity));
        }
    }

    public void OnTrackableEntityDestroyed(@Nonnull Entity entity) {
        UUID entityID = entity.m_20148_();
        if (this.Trackables.containsKey(entityID)) {
            TrackingEntry existing = this.Trackables.get(entityID);
            this.OnEntityDestroyed(entityID, entity, existing.LongEntity);
            this.OnEntityBecameUnloaded(entityID, entity, existing.LongEntity);
            this.Trackables.remove(entityID);
        }
    }

    public void OnAddedLoadedEntity(@Nonnull UUID entityID, @Nonnull Entity entity, @Nonnull LongDistanceEntity longEntity) {
        for (Map.Entry<Player, TrackingList> playerTracking : this.Players.entrySet()) {
            if (!longEntity.ShouldBeTrackedBy(playerTracking.getKey())) continue;
            playerTracking.getValue().BeginTracking(entityID);
        }
    }

    public void OnAddedUnloadedEntity(@Nonnull UUID entityID, @Nonnull LongDistanceEntity longEntity) {
        for (Map.Entry<Player, TrackingList> playerTracking : this.Players.entrySet()) {
            if (!longEntity.ShouldBeTrackedBy(playerTracking.getKey())) continue;
            playerTracking.getValue().BeginTracking(entityID);
        }
    }

    public void OnEntityBecameLoaded(@Nonnull UUID entityID, @Nonnull Entity entity, @Nonnull LongDistanceEntity longEntity) {
        longEntity.AfterEntityLoaded(entity);
    }

    public void OnEntityBecameUnloaded(@Nonnull UUID entityID, @Nonnull Entity entity, @Nonnull LongDistanceEntity longEntity) {
        longEntity.BeforeEntityUnloaded(entity);
    }

    public void OnEntityDestroyed(@Nonnull UUID entityID, @Nonnull Entity entity, @Nonnull LongDistanceEntity longEntity) {
        longEntity.BeforeEntityDestroyed(entity);
        for (Map.Entry<Player, TrackingList> playerTracking : this.Players.entrySet()) {
            playerTracking.getValue().StopTracking(entityID);
        }
    }

    public void Clear() {
        this.Trackables.clear();
        this.Players.clear();
    }

    private record TrackingEntry(@Nonnull LongDistanceEntity LongEntity, @Nonnull Optional<Entity> LoadedEntity) {
        @Nonnull
        public static TrackingEntry of(@Nonnull LongDistanceEntity longEntity, @Nonnull Entity entity) {
            return new TrackingEntry(longEntity, Optional.of(entity));
        }

        @Nonnull
        public static TrackingEntry of(@Nonnull LongDistanceEntity longEntity) {
            return new TrackingEntry(longEntity, Optional.empty());
        }

        public boolean IsTrackedEntityLoaded() {
            return this.LoadedEntity.isPresent();
        }
    }

    private static class TrackingList {
        public Map<UUID, Long> TrackingEntities = new HashMap<UUID, Long>();

        private TrackingList() {
        }

        public void BeginTracking(@Nonnull UUID entityID) {
            this.TrackingEntities.put(entityID, 0L);
        }

        public boolean IsTracking(@Nonnull UUID entityID) {
            return this.TrackingEntities.containsKey(entityID);
        }

        public long TickOfLastUpdateFor(@Nonnull UUID entityID) {
            return this.TrackingEntities.getOrDefault(entityID, 0L);
        }

        public void StopTracking(@Nonnull UUID entityID) {
            this.TrackingEntities.remove(entityID);
        }
    }
}

