/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity;

import com.flansmod.common.entity.INpcRelationshipsCapability;
import com.flansmod.common.entity.NpcRelationshipCapabilityImpl;
import com.flansmod.common.entity.NpcRelationshipsCapability;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpcRelationshipCapabilityAttacher {
    public NpcRelationshipCapabilityAttacher() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void OnRegisterCaps(RegisterCapabilitiesEvent event) {
        event.register(INpcRelationshipsCapability.class);
    }

    @SubscribeEvent
    public void OnAttachCaps(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(NpcRelationshipCapabilityProvider.NPC_RELATIONSHIPS_CAPABILITY, (ICapabilityProvider)new NpcRelationshipCapabilityProvider());
        }
    }

    private static class NpcRelationshipCapabilityProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static final ResourceLocation NPC_RELATIONSHIPS_CAPABILITY = new ResourceLocation("flansmod", "npc_relationships");
        private final INpcRelationshipsCapability Storage = new NpcRelationshipCapabilityImpl();
        private final LazyOptional<INpcRelationshipsCapability> Wrapper = LazyOptional.of(() -> this.Storage);

        private NpcRelationshipCapabilityProvider() {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return NpcRelationshipsCapability.INSTANCE.orEmpty(cap, this.Wrapper);
        }

        void Invalidate() {
            this.Wrapper.invalidate();
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.Storage.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.Storage.deserializeNBT((Tag)nbt);
        }
    }
}

