/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.crafting.menus;

import com.flansmod.common.FlansMod;
import com.flansmod.common.crafting.AbstractWorkbench;
import com.flansmod.common.crafting.menus.WorkbenchMenu;
import com.flansmod.common.crafting.slots.RestrictedSlot;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WorkbenchMenuPartCrafting
extends WorkbenchMenu {
    public static final int PART_CRAFTING_NUM_INPUT_SLOTS_X = 4;
    public static final int PART_CRAFTING_NUM_INPUT_SLOTS_Y = 11;
    public static final int PART_CRAFTING_INPUT_SLOTS_X = 5;
    public static final int PART_CRAFTING_INPUT_SLOTS_Y = 18;
    public static final int PART_CRAFTING_NUM_OUTPUT_SLOTS_X = 4;
    public static final int PART_CRAFTING_NUM_OUTPUT_SLOTS_Y = 6;
    public static final int PART_CRAFTING_OUTPUT_SLOTS_X = 279;
    public static final int PART_CRAFTING_OUTPUT_SLOTS_Y = 115;
    public static final int BUTTON_CRAFT_1 = 0;
    public static final int BUTTON_CRAFT_5 = 5;
    public static final int BUTTON_CRAFT_ALL = 15;
    public static final int BUTTON_QUEUE_CANCEL_0 = 16;
    public static final int BUTTON_QUEUE_CANCEL_MAX = 31;
    public static final int BUTTON_SELECT_PART_RECIPE_0 = 32;
    public static final int BUTTON_SELECT_PART_RECIPE_MAX = 255;
    public final Container PartCraftingInputContainer;
    public final Container PartCraftingOutputContainer;
    protected RestrictedSlot[] PartCraftingInputSlots;
    protected RestrictedSlot[] PartCraftingOutputSlots;

    public WorkbenchMenuPartCrafting(int containerID, @Nonnull Inventory inventory, @Nonnull AbstractWorkbench workbench) {
        super((MenuType<? extends WorkbenchMenu>)((MenuType)FlansMod.WORKBENCH_MENU_PART_CRAFTING.get()), containerID, inventory, workbench);
        this.PartCraftingInputContainer = this.Workbench.PartCraftingInputContainer;
        this.PartCraftingOutputContainer = this.Workbench.PartCraftingOutputContainer;
        this.CreateSlots(inventory, 0);
    }

    public WorkbenchMenuPartCrafting(int containerID, @Nonnull Inventory inventory, @Nonnull FriendlyByteBuf data) {
        super((MenuType<? extends WorkbenchMenu>)((MenuType)FlansMod.WORKBENCH_MENU_PART_CRAFTING.get()), containerID, inventory, data);
        this.PartCraftingInputContainer = this.Workbench.PartCraftingInputContainer;
        this.PartCraftingOutputContainer = this.Workbench.PartCraftingOutputContainer;
        this.CreateSlots(inventory, 0);
    }

    public boolean m_6366_(@Nonnull Player player, int buttonID) {
        if (0 <= buttonID && buttonID < 15) {
            int craftCount = buttonID - 0 + 1;
            this.CraftParts(craftCount);
            return true;
        }
        if (buttonID == 15) {
            this.CraftParts(-1);
            return true;
        }
        if (32 <= buttonID && buttonID <= 255) {
            this.Workbench.SelectPartCraftingRecipe(player.m_9236_(), buttonID - 32);
            return true;
        }
        if (16 <= buttonID && buttonID <= 31) {
            int cancelIndex = buttonID - 16;
            this.Workbench.CancelQueue(cancelIndex);
            return true;
        }
        return false;
    }

    @Override
    protected void CreateSlots(@Nonnull Inventory playerInventory, int inventorySlotOffsetX) {
        int y;
        int x;
        int i;
        super.CreateSlots(playerInventory, inventorySlotOffsetX + 92);
        this.PartCraftingInputSlots = new RestrictedSlot[this.PartCraftingInputContainer.m_6643_()];
        if (this.PartCraftingInputContainer.m_6643_() > 0) {
            for (i = 0; i < this.PartCraftingInputContainer.m_6643_(); ++i) {
                x = i % 4;
                y = i / 4;
                this.PartCraftingInputSlots[i] = new RestrictedSlot(this.PartCraftingInputContainer, i, 6 + x * 18, 19 + y * 18);
                this.m_38897_(this.PartCraftingInputSlots[i]);
            }
        }
        this.PartCraftingOutputSlots = new RestrictedSlot[this.PartCraftingOutputContainer.m_6643_()];
        if (this.PartCraftingOutputContainer.m_6643_() > 0) {
            for (i = 0; i < this.PartCraftingOutputContainer.m_6643_(); ++i) {
                x = i % 4;
                y = i / 4;
                this.PartCraftingOutputSlots[i] = new RestrictedSlot(this.PartCraftingOutputContainer, i, 280 + x * 18, 116 + y * 18);
                this.m_38897_(this.PartCraftingOutputSlots[i]);
            }
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int slot) {
        if (this.PartCraftingInputSlots != null && this.PartCraftingInputSlots.length > 0 && slot >= this.PartCraftingInputSlots[0].f_40219_ && slot < this.PartCraftingInputSlots[0].f_40219_ + this.PartCraftingInputSlots.length) {
            int craftingInputSlotIndex = slot - this.PartCraftingInputSlots[0].f_40219_;
            return this.QuickStackIntoInventory(player, this.PartCraftingInputSlots[craftingInputSlotIndex]);
        }
        if (this.PartCraftingOutputSlots != null && this.PartCraftingOutputSlots.length > 0 && slot >= this.PartCraftingOutputSlots[0].f_40219_ && slot < this.PartCraftingOutputSlots[0].f_40219_ + this.PartCraftingOutputSlots.length) {
            int craftingOutputSlotIndex = slot - this.PartCraftingOutputSlots[0].f_40219_;
            return this.QuickStackIntoInventory(player, this.PartCraftingOutputSlots[craftingOutputSlotIndex]);
        }
        ItemStack stack = ((Slot)this.f_38839_.get(slot)).m_7993_();
        for (RestrictedSlot partInputSlot : this.PartCraftingInputSlots) {
            if (!partInputSlot.m_7993_().m_41619_()) continue;
            partInputSlot.m_5852_(stack);
            ((Slot)this.f_38839_.get(slot)).m_5852_(ItemStack.f_41583_);
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public void CraftParts(int count) {
        this.Workbench.QueueCrafting(this.World, count);
    }
}

