/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.crafting.ingredients;

import com.flansmod.common.FlansMod;
import com.flansmod.common.crafting.ingredients.IExtraIngredientTooltip;
import com.flansmod.common.crafting.ingredients.StackedIngredient;
import com.flansmod.common.types.crafting.MaterialDefinition;
import com.flansmod.common.types.elements.MaterialSourceDefinition;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class TieredMaterialIngredient
extends StackedIngredient
implements IExtraIngredientTooltip {
    public final ResourceLocation MaterialLocation;
    private ItemStack[] MatchingStacks = null;

    public MaterialDefinition MaterialType() {
        return (MaterialDefinition)FlansMod.MATERIALS.Get(this.MaterialLocation);
    }

    public TieredMaterialIngredient(ResourceLocation matLoc, int count) {
        super(count);
        this.MaterialLocation = matLoc;
    }

    public boolean isSimple() {
        return true;
    }

    public boolean m_43947_() {
        return this.m_43908_().length == 0;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.MatchingStacks == null) {
            MaterialDefinition material = (MaterialDefinition)FlansMod.MATERIALS.Get(this.MaterialLocation);
            if (material.IsValid()) {
                ArrayList<ItemStack> matches = new ArrayList<ItemStack>();
                for (MaterialSourceDefinition source : material.sources) {
                    matches.addAll(source.GetMatches());
                }
                this.MatchingStacks = new ItemStack[matches.size()];
                matches.toArray(this.MatchingStacks);
            } else {
                this.MatchingStacks = new ItemStack[0];
            }
        }
        return this.MatchingStacks;
    }

    @Override
    public void GenerateTooltip(@Nonnull List<Component> lines, boolean advanced) {
        this.GenerateTooltip(lines, 0, advanced);
    }

    public void GenerateTooltip(@Nonnull List<Component> lines, int numMatching, boolean advanced) {
        int maxProduce = this.Count > 0 ? numMatching / this.Count : 999;
        String materialName = "material." + this.MaterialType().Location.m_135827_() + "." + this.MaterialType().Location.m_135815_();
        lines.add((Component)Component.m_237110_((String)"crafting.match_single", (Object[])new Object[]{Component.m_237115_((String)materialName)}));
        String matchingString = this.MaterialType().GenerateString(numMatching);
        String requiredString = this.MaterialType().GenerateString(this.Count);
        String resetColorCode = "\u00a7f";
        String colorCode = numMatching < this.Count ? "\u00a74" : resetColorCode;
        lines.add((Component)Component.m_237113_((String)(colorCode + matchingString + resetColorCode + " / " + requiredString + " (Max: " + maxProduce + ")")));
    }

    @Override
    public int Count(@Nullable ItemStack target) {
        if (target == null) {
            return 0;
        }
        int value = 0;
        for (MaterialSourceDefinition source : this.MaterialType().sources) {
            value += source.AnalyzeStack(target);
        }
        return value;
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("material", this.MaterialLocation.toString());
        json.addProperty("count", (Number)this.Count);
        return json;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<TieredMaterialIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @Nonnull
        public TieredMaterialIngredient parse(@Nonnull JsonObject json) {
            String materialName = GsonHelper.m_13851_((JsonObject)json, (String)"material", (String)"");
            ResourceLocation materialLoc = new ResourceLocation(materialName);
            int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
            return new TieredMaterialIngredient(materialLoc, count);
        }

        public void write(FriendlyByteBuf buffer, TieredMaterialIngredient ingredient) {
            buffer.writeInt(ingredient.MaterialLocation.hashCode());
            buffer.writeInt(ingredient.Count);
        }

        @Nonnull
        public TieredMaterialIngredient parse(FriendlyByteBuf buffer) {
            int materialHash = buffer.readInt();
            int count = buffer.readInt();
            return new TieredMaterialIngredient(((MaterialDefinition)FlansMod.MATERIALS.ByHash((int)materialHash)).Location, count);
        }
    }
}

